/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.core.win32;

import com.nxp.s32ds.debug.ide.core.USBDeviceAccessor;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class S32DebuggerUSBDeviceAccessorImpl
implements USBDeviceAccessor {
    private static final String PARAMETER_VALUE = " /v %s";
    private static final String DEVICE_DESCRIPTION = "DeviceDesc";
    private static final String CONTAINER_ID = "ContainerID";
    private static final String SERVICE = "Service";
    private static final String GREEN_BOX_II_FRIENDLY_NAME = "DAPLink CMSIS-DAP";
    private static final String LPC_LINK_II_FRIENDLY_NAME = "LPC-LINK2 CMSIS-DAP";
    private static final String TAP_LPC_LINK_2_ENUMERATOR = "0";
    private static final String SERVICE_USB_RNDIS = "USB_RNDIS";
    private static final String SERVICE_HID_USB = "HidUsb";
    private static final String REQUEST_TO_WINDOWS_REGISTRY = "REG QUERY \"%s\"%s\n";
    private static final String REQUEST_TO_WINDOWS_REGISTRY_USBCCGP_SERVICE = String.format("REG QUERY \"%s\"%s\n", "HKLM\\SYSTEM\\CurrentControlSet\\services\\usbccgp\\Enum", "");
    private static final String REQUEST_TO_WINDOWS_REGISTRY_USBHID_SERVICE = String.format("REG QUERY \"%s\"%s\n", "HKLM\\SYSTEM\\CurrentControlSet\\services\\HidUsb\\Enum", "");
    private static final String REQUEST_TO_WINDOWS_REGISTRY_USB_DEVICES = String.format("REG QUERY \"%s\"%s\n", "HKLM\\SYSTEM\\CurrentControlSet\\Enum\\USB\\%s", "");
    private static final String REQUEST_TO_WINDOWS_REGISTRY_CONTAINER_ID = String.format("REG QUERY \"%s\"%s\n", "HKLM\\SYSTEM\\CurrentControlSet\\Enum\\USB\\%s\\%s", " /v %s");
    private static final String REQUEST_TO_WINDOWS_REGISTRY_DEVICE_DESCRIPTION = String.format("REG QUERY \"%s\"%s\n", "HKLM\\SYSTEM\\CurrentControlSet\\Enum\\USB\\%s\\%s", " /v %s");
    private static final String REQUEST_TO_WINDOWS_REGISTRY_DEVICES_CHILDREN = String.format("REG QUERY \"%s\"%s\n", "HKLM\\SYSTEM\\CurrentControlSet\\Enum\\USB\\%s&MI_0%s", "");
    private static final String IPCONFIG_ALL_CMD = "ipconfig /all\n";
    private static final String DHCP_SERVER = "DHCP Server";

    public Collection<String> getActiveTAPDevices() {
        String vidPid = S32DEBUGGER_DEVICE_ID;
        List<String> usbCCGPDevices = this.runProcessForOutput(REQUEST_TO_WINDOWS_REGISTRY_USBCCGP_SERVICE);
        Collection<String> devicesIDs = this.retrieveDeviceStrings(usbCCGPDevices, vidPid);
        if (devicesIDs.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, String> containerIDToDevice = this.retrieveDeviceContainerIDs(devicesIDs, vidPid);
        Map<String, String> enumeratorPaths = this.createSystemEnumeratorQualifiersForActiveDevices(devicesIDs, containerIDToDevice, vidPid);
        return this.createFormattedDeviceStrings(enumeratorPaths, containerIDToDevice, vidPid);
    }

    public Collection<String> getActiveCMSISDAPDevices() {
        Collection<String> allDevices = this.retrieveCMSISDAPDevices();
        List<String> usbCCGPDevices = this.runProcessForOutput(REQUEST_TO_WINDOWS_REGISTRY_USBCCGP_SERVICE);
        Collection<String> greenBoxCCGPIDs = this.retrieveDeviceStrings(usbCCGPDevices, CMSIS_DAP_GREEN_BOX_DEVICE_ID);
        Collection<String> lpcIICCGPIDs = this.retrieveDeviceStrings(usbCCGPDevices, CMSIS_DAP_LPC_DEVICE_ID);
        List<String> usbHIDDevices = this.runProcessForOutput(REQUEST_TO_WINDOWS_REGISTRY_USBHID_SERVICE);
        Collection<String> greenBoxHIDIDs = this.retrieveDeviceStrings(usbHIDDevices, CMSIS_DAP_GREEN_BOX_DEVICE_ID);
        HashSet<String> greenBoxDevices = new HashSet<String>();
        HashSet<String> lpcLinkIIDevices = new HashSet<String>();
        for (String device : allDevices) {
            if (greenBoxCCGPIDs.contains(device) || greenBoxHIDIDs.contains(device)) {
                greenBoxDevices.add(device);
            }
            if (!lpcIICCGPIDs.contains(device)) continue;
            lpcLinkIIDevices.add(device);
        }
        HashSet<String> deviceNames = new HashSet<String>();
        deviceNames.addAll(this.createDeviceStrings(greenBoxDevices, GREEN_BOX_II_FRIENDLY_NAME, CMSIS_DAP_GREEN_BOX_DEVICE_ID));
        deviceNames.addAll(this.createDeviceStrings(lpcLinkIIDevices, LPC_LINK_II_FRIENDLY_NAME, CMSIS_DAP_LPC_DEVICE_ID));
        return deviceNames;
    }

    private Collection<String> retrieveCMSISDAPDevices() {
        String deviceId;
        HashSet<String> devices = new HashSet<String>();
        String request = String.format(REQUEST_TO_WINDOWS_REGISTRY_USB_DEVICES, CMSIS_DAP_GREEN_BOX_DEVICE_ID);
        List<String> result = this.runProcessForOutput(request);
        for (String line : result) {
            if (!line.contains(CMSIS_DAP_GREEN_BOX_DEVICE_ID)) continue;
            deviceId = line.substring(line.indexOf(CMSIS_DAP_GREEN_BOX_DEVICE_ID) + CMSIS_DAP_GREEN_BOX_DEVICE_ID.length() + 1);
            devices.add(deviceId);
        }
        request = String.format(REQUEST_TO_WINDOWS_REGISTRY_USB_DEVICES, CMSIS_DAP_LPC_DEVICE_ID);
        result = this.runProcessForOutput(request);
        for (String line : result) {
            if (!line.contains(CMSIS_DAP_LPC_DEVICE_ID)) continue;
            deviceId = line.substring(line.indexOf(CMSIS_DAP_LPC_DEVICE_ID) + CMSIS_DAP_LPC_DEVICE_ID.length() + 1);
            devices.add(deviceId);
        }
        return devices;
    }

    private Collection<String> createDeviceStrings(Collection<String> deviceIDs, String deviceName, String deviceVidPid) {
        HashSet<String> deviceNames = new HashSet<String>();
        for (String deviceId : deviceIDs) {
            StringBuilder deviceStr = new StringBuilder();
            deviceStr.append(deviceVidPid);
            deviceStr.append("--");
            deviceStr.append(deviceId);
            deviceStr.append("--");
            deviceStr.append(deviceId);
            deviceStr.append(" - ");
            deviceStr.append(deviceName);
            deviceNames.add(deviceStr.toString());
        }
        return deviceNames;
    }

    private List<String> runProcessForOutput(String toExecute) {
        Process process = null;
        BufferedReader reader = null;
        try {
            process = Runtime.getRuntime().exec(toExecute);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            S32DebuggerCoreActivator.log((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.core", "IO exception when reading process output" + e.getMessage()));
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    S32DebuggerCoreActivator.log((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.s32debugger.core", "IO exception when reading process output" + e.getMessage()));
                }
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    public String getVirtualIP(String device) {
        String[] deviceIDs = device.split("--");
        if (deviceIDs.length != 3) {
            return null;
        }
        String deviceVidPid = deviceIDs[0];
        String deviceSerial = deviceIDs[1];
        if (S32DEBUGGER_DEVICE_ID.equals(deviceVidPid)) {
            List<String> result = this.runProcessForOutput(IPCONFIG_ALL_CMD);
            boolean deviceFound = false;
            for (String line : result) {
                if (!deviceFound) {
                    if (!line.contains(deviceSerial)) continue;
                    deviceFound = true;
                    continue;
                }
                if (!line.contains(DHCP_SERVER)) continue;
                String virtualIp = line.substring(line.indexOf(58) + 2).trim();
                return "s32dbg:" + virtualIp;
            }
        }
        if (CMSIS_DAP_GREEN_BOX_DEVICE_ID.equals(deviceVidPid) || CMSIS_DAP_LPC_DEVICE_ID.equals(deviceVidPid)) {
            Collection<String> activeDevices = this.getActiveCMSISDAPDevices(deviceVidPid);
            for (String deviceId : activeDevices) {
                if (!deviceId.contains(deviceSerial)) continue;
                return "cmsisdap#" + deviceSerial;
            }
        }
        return null;
    }

    private Collection<String> getActiveCMSISDAPDevices(String vidPid) {
        List<String> usbCCGPDevices = this.runProcessForOutput(REQUEST_TO_WINDOWS_REGISTRY_USBCCGP_SERVICE);
        Collection<String> usbCCGPDeviceIDs = this.retrieveDeviceStrings(usbCCGPDevices, vidPid);
        List<String> usbHIDDevices = this.runProcessForOutput(REQUEST_TO_WINDOWS_REGISTRY_USBHID_SERVICE);
        Collection<String> usbHIDIDs = this.retrieveDeviceStrings(usbHIDDevices, vidPid);
        HashSet<String> devicesIDs = new HashSet<String>(usbCCGPDeviceIDs);
        devicesIDs.addAll(usbHIDIDs);
        return devicesIDs;
    }

    private Collection<String> retrieveDeviceStrings(Collection<String> activeDevices, String vidPid) {
        HashSet<String> devicesStrings = new HashSet<String>();
        for (String line : activeDevices) {
            int vidPidIndex = line.lastIndexOf(vidPid);
            if (vidPidIndex == -1) continue;
            String deviceIdStr = line.substring(vidPidIndex + 1 + vidPid.length());
            int slashIndex = deviceIdStr.lastIndexOf(92);
            if (slashIndex != -1 && deviceIdStr.length() > slashIndex + 1) {
                deviceIdStr = deviceIdStr.substring(slashIndex + 1);
            }
            devicesStrings.add(deviceIdStr);
        }
        return devicesStrings;
    }

    private Map<String, String> retrieveDeviceContainerIDs(Collection<String> devicesIDs, String vidPid) {
        HashMap<String, String> containerToDevice = new HashMap<String, String>();
        block0: for (String deviceId : devicesIDs) {
            String request = String.format(REQUEST_TO_WINDOWS_REGISTRY_CONTAINER_ID, vidPid, deviceId, CONTAINER_ID);
            List<String> result = this.runProcessForOutput(request);
            for (String line : result) {
                if (!line.contains(CONTAINER_ID)) continue;
                String containerId = line.substring(line.indexOf(123));
                containerToDevice.put(containerId, deviceId);
                continue block0;
            }
        }
        return containerToDevice;
    }

    private Map<String, String> createSystemEnumeratorQualifiersForActiveDevices(Collection<String> devicesIDs, Map<String, String> containerIDToDevice, String vidPid) {
        HashMap<String, String> qualifiers = new HashMap<String, String>();
        for (String deviceId : devicesIDs) {
            String request = String.format(REQUEST_TO_WINDOWS_REGISTRY_DEVICES_CHILDREN, vidPid, TAP_LPC_LINK_2_ENUMERATOR);
            List<String> devicesChildren = this.runProcessForOutput(request);
            block1: for (String childDevice : devicesChildren) {
                if (childDevice.isEmpty()) continue;
                String childRequest = String.format(REQUEST_TO_WINDOWS_REGISTRY, childDevice, String.format(PARAMETER_VALUE, CONTAINER_ID));
                List<String> result = this.runProcessForOutput(childRequest);
                for (String line : result) {
                    if (!line.contains(CONTAINER_ID)) continue;
                    String containerId = line.substring(line.indexOf(123));
                    String deviceByContainer = containerIDToDevice.get(containerId);
                    if (!deviceId.equals(deviceByContainer)) continue block1;
                    qualifiers.put(containerId, childDevice);
                    continue block1;
                }
            }
        }
        return qualifiers;
    }

    private Collection<String> createFormattedDeviceStrings(Map<String, String> containerIDToQualifier, Map<String, String> containerIDToDevice, String vidPid) {
        HashSet<String> deviceFormattedStrings = new HashSet<String>();
        for (String containerID : containerIDToQualifier.keySet()) {
            StringBuilder deviceStr = new StringBuilder();
            deviceStr.append(vidPid);
            deviceStr.append("--");
            String deviceDescRequest = String.format(REQUEST_TO_WINDOWS_REGISTRY_DEVICE_DESCRIPTION, vidPid, containerIDToDevice.get(containerID), DEVICE_DESCRIPTION);
            List<String> deviceDescResult = this.runProcessForOutput(deviceDescRequest);
            String rootDeviceDescription = this.getDeviceDescription(deviceDescResult);
            if (rootDeviceDescription.isEmpty()) continue;
            String serviceRequest = String.format(REQUEST_TO_WINDOWS_REGISTRY, containerIDToQualifier.get(containerID), String.format(PARAMETER_VALUE, SERVICE));
            List<String> serviceResult = this.runProcessForOutput(serviceRequest);
            for (String resultLine : serviceResult) {
                String deviceDescServiceRequest;
                List<String> deviceDescServiceResult;
                String enumeratorDeviceDescription;
                if (!resultLine.contains(SERVICE_USB_RNDIS) && !resultLine.contains(SERVICE_HID_USB) || (enumeratorDeviceDescription = this.getDeviceDescription(deviceDescServiceResult = this.runProcessForOutput(deviceDescServiceRequest = String.format(REQUEST_TO_WINDOWS_REGISTRY, containerIDToQualifier.get(containerID), String.format(PARAMETER_VALUE, DEVICE_DESCRIPTION))))).isEmpty() || !resultLine.contains(SERVICE_USB_RNDIS)) continue;
                deviceStr.append(enumeratorDeviceDescription);
                deviceStr.append("--");
                deviceStr.append(containerIDToDevice.get(containerID));
                deviceStr.append(" - ");
                deviceStr.append(rootDeviceDescription);
                break;
            }
            deviceFormattedStrings.add(deviceStr.toString());
        }
        return deviceFormattedStrings;
    }

    private String getDeviceDescription(List<String> processResult) {
        String deviceDescription = "";
        for (String line : processResult) {
            if (!line.contains(DEVICE_DESCRIPTION)) continue;
            int symbolIndex = line.lastIndexOf(59);
            deviceDescription = line.substring(symbolIndex + 1);
            break;
        }
        return deviceDescription;
    }
}

