/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.core.cli.cmd.ui;

import com.nxp.s32ds.rcp.license.core.cli.cmd.ui.ActivationIdDialog;
import java.awt.HeadlessException;
import java.io.File;
import java.text.ParseException;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class UIUtils {
    public static final String ACTIVATION_ID_LABEL = "Software Activation Code";
    private static String MSG_WRAPPER = "<html><body><p align='center' style='width: 400px;'>%s</p></body></html>";

    public static void showMessageDialog(String title, String message) throws HeadlessException {
        JOptionPane panel = new JOptionPane(UIUtils.wrap(message), 1, -1, null, null, null);
        panel.setInitialValue(0);
        panel.setComponentOrientation(JOptionPane.getRootFrame().getComponentOrientation());
        panel.selectInitialValue();
        JDialog dialog = panel.createDialog(title);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static File chooseFile(String title, String button, File defaultFile) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(title);
        chooser.setApproveButtonText(button);
        chooser.setSelectedFile(defaultFile);
        JFrame frame = new JFrame();
        frame.setAlwaysOnTop(true);
        frame.setDefaultCloseOperation(2);
        if (chooser.showOpenDialog(frame) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static boolean showConfirmDialog(String title, String message) throws HeadlessException {
        JOptionPane panel = new JOptionPane(UIUtils.wrap(message), 2, 2, null, null, null);
        panel.setInitialValue(0);
        panel.setComponentOrientation(JOptionPane.getRootFrame().getComponentOrientation());
        panel.selectInitialValue();
        JDialog dialog = panel.createDialog(title);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        dialog.setAlwaysOnTop(true);
        dialog.dispose();
        return (Integer)panel.getValue() == 0;
    }

    private static String wrap(String message) {
        return String.format(MSG_WRAPPER, message.replace("\n", "<br>"));
    }

    public static int requestType(String text) {
        return JOptionPane.showOptionDialog(null, text, "NXP Software Activation", 0, 1, null, new String[]{"Online", "Offline"}, "Online");
    }

    public static boolean confirmOverwrite() {
        return JOptionPane.showConfirmDialog(null, "File already exists, are you sure you want to overwrite it?", "Warning", 0) == 0;
    }

    public static String showInputDialog(String message, String initial) throws HeadlessException {
        String value = "";
        try {
            ActivationIdDialog dialog = new ActivationIdDialog("NXP Software Activation", message, initial);
            dialog.setVisible(true);
            value = dialog.getValue();
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            value = null;
        }
        return value;
    }

    public static String showInputDialog(String message) {
        return UIUtils.showInputDialog(message, "");
    }

    public static void showWarningDialog(String title, String text) {
        JOptionPane.showMessageDialog(null, text, title, 2);
    }
}

