/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.core.cli.cmd;

import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import com.nxp.s32ds.rcp.license.core.cli.ISettings;
import com.nxp.s32ds.rcp.license.core.cli.cmd.AbstractCommand;

public class VerifyByFeature
extends AbstractCommand {
    public static final String PARAM_FEATURE_NAME = "feature";
    public static final String PARAM_FEATURE_VERSION = "version";
    public static final String PARAM_FEATURE_NAME_ERROR = "Feature name is missing";
    public static final String PARAM_FEATURE_VERSION_ERROR = "Feature version is missing";
    public static final String COMMAND_NAME = "Verify by feature";
    public static final String COMMAND_DESCRIPTION = "Verify if license available by feature";

    public VerifyByFeature(ISettings settings, ICLL cll) {
        super(cll, settings);
        this.getParams().put(PARAM_FEATURE_NAME, PARAM_FEATURE_NAME_ERROR);
        this.getParams().put(PARAM_FEATURE_VERSION, PARAM_FEATURE_VERSION_ERROR);
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public String getOneLineDesc() {
        return COMMAND_DESCRIPTION;
    }

    @Override
    public boolean canExecute() {
        return this.getProblemDescription() == null;
    }

    @Override
    public String getProblemDescription() {
        String rootProblems = super.getProblemDescription();
        if (rootProblems != null) {
            return rootProblems;
        }
        if (this.getSettings().getParam(PARAM_FEATURE_NAME) == null) {
            return PARAM_FEATURE_NAME_ERROR;
        }
        if (this.getSettings().getParam(PARAM_FEATURE_VERSION) == null) {
            return PARAM_FEATURE_VERSION_ERROR;
        }
        return null;
    }

    @Override
    public int execute() {
        super.setupProxy();
        String feature = this.getSettings().getParam(PARAM_FEATURE_NAME);
        String version = this.getSettings().getParam(PARAM_FEATURE_VERSION);
        CLLReason reason = new CLLReason();
        reason = this.getCll().verifyLicenseAvailabilityByFeature(feature, version);
        return reason.getErrorNo();
    }
}

