/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.core.cli.cmd;

import com.nxp.s32ds.ext.rcp.license.cll.CLLFeatureDetail;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import com.nxp.s32ds.rcp.license.core.cli.ISettings;
import com.nxp.s32ds.rcp.license.core.cli.cmd.AbstractCommand;

public class Verify
extends AbstractCommand {
    public static final String PARAM_PROD = "prod";
    public static final String PARAM_FEATURE_NAME = "feature";
    public static final String PARAM_FEATURE_VERSION = "version";
    public static final int EXIT_MAGIC = 42;

    public Verify(ISettings settings, ICLL cll) {
        super(cll, settings);
        this.getParams().put(PARAM_PROD, "Product name");
        this.getParams().put(PARAM_FEATURE_NAME, "Feature name");
        this.getParams().put(PARAM_FEATURE_VERSION, "Feature version");
    }

    @Override
    public String getName() {
        return "verify";
    }

    @Override
    public String getOneLineDesc() {
        return "Check if feature available in product";
    }

    @Override
    public boolean canExecute() {
        return this.getProblemDescription() == null;
    }

    @Override
    public String getProblemDescription() {
        String rootProblems = super.getProblemDescription();
        if (rootProblems != null) {
            return rootProblems;
        }
        if (this.getSettings().getParam(PARAM_PROD) == null) {
            return "Product name missing";
        }
        if (this.getSettings().getParam(PARAM_FEATURE_NAME) == null) {
            return "Feature name missing";
        }
        if (this.getSettings().getParam(PARAM_FEATURE_VERSION) == null) {
            return "Feature version missing";
        }
        return null;
    }

    @Override
    public int execute() {
        super.setupProxy();
        String prod = this.getSettings().getParam(PARAM_PROD);
        String feature = this.getSettings().getParam(PARAM_FEATURE_NAME);
        String version = this.getSettings().getParam(PARAM_FEATURE_VERSION);
        CLLReason reason = new CLLReason();
        CLLFeatureDetail featureDetail = this.getCll().listFeatures(prod, feature, version, reason);
        if (featureDetail == null) {
            System.err.println(reason);
            return 1;
        }
        return 42;
    }
}

