/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.core;

import com.nxp.s32ds.ext.rcp.license.cll.CLLFeatureDetail;
import com.nxp.s32ds.rcp.license.core.Messages;

public class LicenseStatus {
    private LicenseStatusType type;
    private int daysLeft;

    public static LicenseStatus error(final Throwable e) {
        return new LicenseStatus(null){

            @Override
            public String getStatusText() {
                return e.getMessage() != null ? e.getMessage() : "error";
            }

            @Override
            public LicenseStatusType getType() {
                return LicenseStatusType.INITIALIZATION_ERROR;
            }
        };
    }

    public LicenseStatus(CLLFeatureDetail featureDetail) {
        this.type = LicenseStatus.calcType(featureDetail);
        this.daysLeft = this.calcDaysLeft(featureDetail);
    }

    private int calcDaysLeft(CLLFeatureDetail featureDetail) {
        if (featureDetail == null) {
            return -1;
        }
        if ("FOREVER".equals(featureDetail.getDaysToExpire())) {
            return 3650000;
        }
        return Integer.parseInt(featureDetail.getDaysToExpire());
    }

    private static LicenseStatusType calcType(CLLFeatureDetail featureDetail) {
        if (featureDetail == null) {
            return LicenseStatusType.MISSED;
        }
        if ("FOREVER".equals(featureDetail.getDaysToExpire())) {
            return LicenseStatusType.ACTIVATED;
        }
        if (Integer.parseInt(featureDetail.getDaysToExpire()) < 1) {
            return LicenseStatusType.EXPIRED;
        }
        if (featureDetail.getExpirationDate() != null) {
            return LicenseStatusType.EVALUATION;
        }
        return LicenseStatusType.INITIALIZATION_ERROR;
    }

    public boolean isEnabled() {
        return this.type == LicenseStatusType.ACTIVATED || this.type == LicenseStatusType.EVALUATION;
    }

    public LicenseStatusType getType() {
        return this.type;
    }

    public String getStatusText() {
        switch (this.type) {
            case INITIALIZATION_ERROR: {
                return Messages.getString("Extension_initError", new Object[]{"internal error"});
            }
            case ACTIVATED: {
                return Messages.getString("Extension_activated", null);
            }
            case EXPIRED: {
                return Messages.getString("Extension_licenseExpired", null);
            }
            case EVALUATION: {
                int daysLeft = this.getDaysLeft();
                if (daysLeft < 0) {
                    if (this.type == LicenseStatusType.EVALUATION) {
                        return Messages.getString("Extension_initError", new Object[]{"internal error"});
                    }
                    return this.getStatusText();
                }
                return Messages.getString("Extension_licenseExpiring", new Object[]{daysLeft});
            }
            case MISSED: {
                return Messages.getString("Extension_licenseMissing", null);
            }
        }
        return "";
    }

    public String toString() {
        if (LicenseStatusType.EVALUATION.equals((Object)this.type)) {
            return "Evaluation (" + this.daysLeft + " days)";
        }
        return this.type.name();
    }

    public int getDaysLeft() {
        return this.daysLeft;
    }

    public static enum LicenseStatusType {
        ACTIVATED,
        EVALUATION,
        EXPIRED,
        MISSED,
        INITIALIZATION_ERROR;

    }
}

