/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import com.ibm.icu.text.DateFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate2;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class LocalRunLaunchDelegate
extends AbstractCLaunchDelegate2 {
    public LocalRunLaunchDelegate() {
        super(false);
    }

    @Override
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        assert (mode.equals("run"));
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("run")) {
            this.runLocalApplication(config, launch, monitor);
        }
    }

    private void runLocalApplication(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(LaunchMessages.LocalCDILaunchDelegate_0, 10);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        try {
            String args;
            IPath exePath = this.checkBinaryDetails(config);
            File wd = this.verifyWorkingDirectory(config);
            if (wd == null) {
                wd = new File(System.getProperty("user.home", "."));
            }
            if ((args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "")).length() != 0) {
                args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
            }
            String[] arguments = CommandLineUtil.argumentsToArray((String)args);
            ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
            command.add(exePath.toOSString());
            command.addAll(Arrays.asList(arguments));
            monitor.worked(2);
            String[] commandArray = command.toArray(new String[command.size()]);
            String[] environment = this.getLaunchEnvironment(config);
            Process process = this.exec(commandArray, environment, wd);
            monitor.worked(6);
            String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
            String processLabel = String.format("%s (%s)", commandArray[0], timestamp);
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)processLabel, this.createProcessAttributes());
        }
        finally {
            monitor.done();
        }
    }

    protected String[] getLaunchEnvironment(ILaunchConfiguration config) throws CoreException {
        ICProjectDescription projDesc;
        String projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
        IProject project = null;
        if (projectName == null) {
            IResource[] resources = config.getMappedResources();
            if (resources != null && resources.length > 0 && resources[0] instanceof IProject) {
                project = (IProject)resources[0];
            }
        } else {
            if ((projectName = projectName.trim()).length() == 0) {
                return null;
            }
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        HashMap<String, String> envMap = new HashMap<String, String>();
        String[] debugEnv = DebugPlugin.getDefault().getLaunchManager().getEnvironment(config);
        if (debugEnv != null) {
            String[] stringArray = debugEnv;
            int n = debugEnv.length;
            int n2 = 0;
            while (n2 < n) {
                String env = stringArray[n2];
                String[] parts = env.split("=", 2);
                if (parts.length == 2) {
                    envMap.put(parts[0], parts[1]);
                }
                ++n2;
            }
        }
        if (project != null && project.isAccessible() && (projDesc = CoreModel.getDefault().getProjectDescription(project, false)) != null) {
            ICdtVariable[] buildVars;
            IEnvironmentVariable[] vars;
            String buildConfigID = config.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
            ICConfigurationDescription cfg = null;
            if (buildConfigID.length() != 0) {
                cfg = projDesc.getConfigurationById(buildConfigID);
            }
            if (cfg == null) {
                cfg = projDesc.getActiveConfiguration();
            }
            IEnvironmentVariable[] iEnvironmentVariableArray = vars = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(cfg, true);
            int n = vars.length;
            int n3 = 0;
            while (n3 < n) {
                String value;
                IEnvironmentVariable var = iEnvironmentVariableArray[n3];
                switch (var.getOperation()) {
                    case 1: {
                        value = (String)envMap.get(var.getName());
                        break;
                    }
                    case 4: {
                        value = (String)envMap.get(var.getName());
                        if (value != null) {
                            value = String.valueOf(value) + var.getDelimiter() + var.getValue();
                            break;
                        }
                        value = var.getValue();
                        break;
                    }
                    case 3: {
                        value = (String)envMap.get(var.getName());
                        if (value != null) {
                            value = String.valueOf(var.getValue()) + var.getDelimiter() + value;
                            break;
                        }
                        value = var.getValue();
                        break;
                    }
                    case 2: {
                        envMap.remove(var.getName());
                        value = null;
                        break;
                    }
                    default: {
                        value = null;
                    }
                }
                if (value != null) {
                    envMap.put(var.getName(), value);
                }
                ++n3;
            }
            ICdtVariableManager manager = CCorePlugin.getDefault().getCdtVariableManager();
            ICdtVariable[] iCdtVariableArray = buildVars = manager.getVariables(cfg);
            int n4 = buildVars.length;
            int n5 = 0;
            while (n5 < n4) {
                ICdtVariable var = iCdtVariableArray[n5];
                try {
                    if (!"project_classpath".equals(var.getName())) {
                        String value = manager.resolveValue(var.getStringValue(), "", File.pathSeparator, cfg);
                        envMap.put(var.getName(), value);
                    }
                }
                catch (CdtVariableException cdtVariableException) {}
                ++n5;
            }
        }
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        for (Map.Entry entry : envMap.entrySet()) {
            StringBuilder buffer = new StringBuilder((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    protected Map<String, String> createProcessAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("org.eclipse.cdt.dsf.gdb.createProcessType", "org.eclipse.cdt.dsf.gdb.inferiorProcess");
        attributes.put("org.eclipse.cdt.dsf.gdb.inferiorExited", "");
        return attributes;
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        ICProject project = this.verifyCProject(config);
        IPath exePath = this.verifyProgramPath(config, project);
        return exePath;
    }

    protected Process exec(String[] cmdLine, String[] environ, File workingDirectory) throws CoreException {
        try {
            if (PTY.isSupported()) {
                return ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory, new PTY());
            }
            return ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory);
        }
        catch (IOException e) {
            this.abort(LaunchMessages.LocalCDILaunchDelegate_8, e, 150);
            return null;
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        this.setDefaultProcessFactory(config);
        return super.preLaunchCheck(config, mode, monitor);
    }

    protected void setDefaultProcessFactory(ILaunchConfiguration config) throws CoreException {
        if (!config.hasAttribute("process_factory_id")) {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("process_factory_id", "org.eclipse.cdt.dsf.gdb.GdbProcessFactory");
            wc.doSave();
        }
    }

    @Override
    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }
}

