/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.vision.isp;

import com.nxp.s32ds.ext.rcp.runtime.Log;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedOptionValueHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ISPTargetOptionsValueHandler
extends ManagedOptionValueHandler {
    static final String OPTION = ".option";
    static final String ASSEMBLER = ".assembler";
    static final String DISASSEMBLER = ".disassembler";

    public boolean handleValue(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument, int event) {
        if (event == 4 || event == 1) {
            IOption srcOption;
            String optionBaseId;
            ITool[] tools;
            IConfiguration config;
            block19: {
                config = null;
                tools = null;
                if (configuration instanceof IConfiguration) {
                    config = (IConfiguration)configuration;
                    tools = config.getTools();
                } else if (configuration instanceof IFolderInfo) {
                    IFolderInfo oFolderInfo = (IFolderInfo)configuration;
                    config = oFolderInfo.getParent();
                    tools = oFolderInfo.getTools();
                }
                if (config == null) {
                    return false;
                }
                IToolChain toolChain = config.getToolChain();
                optionBaseId = option.getBaseId();
                srcOption = toolChain.getOptionBySuperClassId(optionBaseId);
                if (srcOption != null) break block19;
                return false;
            }
            Object objValue = null;
            switch (srcOption.getBasicValueType()) {
                case 0: {
                    objValue = new Boolean(srcOption.getBooleanValue());
                    break;
                }
                case 2: {
                    objValue = srcOption.getStringValue();
                    break;
                }
                case 1: {
                    objValue = srcOption.getStringValue();
                    break;
                }
                default: {
                    return false;
                }
            }
            try {
                String optionName = optionBaseId.substring(optionBaseId.indexOf(OPTION) + OPTION.length(), optionBaseId.length());
                if (objValue instanceof String) {
                    String strValue = (String)objValue;
                    if (!strValue.isEmpty() && srcOption.getBasicValueType() == 1) {
                        objValue = strValue.substring(optionBaseId.length(), strValue.length());
                    }
                } else if (objValue instanceof Boolean) {
                    objValue = (Boolean)objValue;
                }
                ITool[] iToolArray = tools;
                int n = tools.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool tool = iToolArray[n2];
                    ISPTargetOptionsValueHandler.setOption(config, objValue, tool, tool.getBaseId(), optionName);
                    ++n2;
                }
                return true;
            }
            catch (BuildException e) {
                String message = e.getMessage();
                Log.log((IStatus)new Status(2, "com.nxp.s32ds.cle.isp", message));
            }
        }
        return false;
    }

    public static void setOption(IConfiguration config, Object objValue, ITool tool, String dstOptionId, String optionName) throws BuildException {
        String toolId = tool.getId();
        if (toolId == null) {
            return;
        }
        if (toolId.contains(ASSEMBLER) || toolId.contains(DISASSEMBLER)) {
            ITool toolBase = tool.getSuperClass();
            if (toolBase == null) {
                return;
            }
            toolBase = toolBase.getSuperClass();
            String toolBaseId = toolBase.getId();
            StringBuilder dstOptionValueId = new StringBuilder(toolBaseId.toString());
            dstOptionValueId.append(OPTION + optionName);
            IOption dstOption = tool.getOptionBySuperClassId(dstOptionValueId.toString());
            if (dstOption == null) {
                return;
            }
            String sourceValue = "";
            switch (dstOption.getBasicValueType()) {
                case 0: {
                    boolean boolValue = (Boolean)objValue;
                    config.setOption((IHoldsOptions)tool, dstOption, boolValue);
                    break;
                }
                case 2: {
                    sourceValue = (String)objValue;
                    config.setOption((IHoldsOptions)tool, dstOption, sourceValue);
                    break;
                }
                case 1: {
                    sourceValue = (String)objValue;
                    config.setOption((IHoldsOptions)tool, dstOption, dstOptionValueId.append(sourceValue).toString());
                }
            }
        }
    }
}

