/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.ui;

import com.nxp.s32ds.rcp.license.core.FNOId;
import com.nxp.s32ds.rcp.license.core.LicenseCoreActivator;
import com.nxp.s32ds.rcp.license.core.LicenseException;
import com.nxp.s32ds.rcp.license.core.LicenseService;
import com.nxp.s32ds.rcp.license.core.LicenseStatus;
import com.nxp.s32ds.rcp.license.ui.ActivateWindow;
import com.nxp.s32ds.rcp.license.ui.DetailsWindow;
import com.nxp.s32ds.rcp.license.ui.ExpectedFeature;
import com.nxp.s32ds.rcp.license.ui.LicenseUIActivator;
import com.nxp.s32ds.rcp.license.ui.Messages;
import com.nxp.s32ds.rcp.license.ui.internal.ExpectedLicenses;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class LicenseWindow
extends TitleAreaDialog {
    private Table m_table;
    private Button btnActivate;
    private Button btnDetails;

    private LicenseWindow() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : null);
        this.setShellStyle(0x10CF0 | LicenseWindow.getDefaultOrientation());
        this.setHelpAvailable(false);
        this.setBlockOnOpen(true);
    }

    public static void block() {
        LicenseWindow window = new LicenseWindow();
        window.open();
        LicenseService service = LicenseUIActivator.getService();
        ExpectedFeature[] expectedFeatureArray = ExpectedLicenses.list();
        int n = expectedFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpectedFeature f = expectedFeatureArray[n2];
            try {
                LicenseStatus status = service.fetchLicenseFeature((FNOId)f).getStatus();
                if (f.isRequired() && !status.isEnabled()) {
                    PlatformUI.getWorkbench().close();
                }
            }
            catch (LicenseException e) {
                LicenseCoreActivator.log((int)4, (String)e.getMessage(), (Throwable)e);
                PlatformUI.getWorkbench().close();
            }
            ++n2;
        }
    }

    private boolean hasActivatableLicenses() {
        ExpectedFeature[] features;
        ExpectedFeature[] expectedFeatureArray = features = ExpectedLicenses.list();
        if (features.length != 0) {
            ExpectedFeature feature = expectedFeatureArray[0];
            return this.getStatus(feature).getType() != LicenseStatus.LicenseStatusType.ACTIVATED;
        }
        return false;
    }

    private LicenseStatus getStatus(ExpectedFeature feature) {
        try {
            return LicenseUIActivator.getService().fetchLicenseFeature((FNOId)feature).getStatus();
        }
        catch (LicenseException e) {
            return LicenseStatus.error((Throwable)e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.hasActivatableLicenses()) {
            this.btnActivate = this.createButton(parent, 1029, Messages.getString("LicenseWindow_activate", null), false);
            this.btnActivate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LicenseWindow.this.activate();
                    LicenseWindow.this.updateTable();
                }
            });
        }
        this.btnDetails = this.createButton(parent, 1028, Messages.getString("LicenseWindow_details", null), false);
        this.btnDetails.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseWindow.this.details();
            }
        });
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        this.updateTable();
        this.updateSelection(this.m_table.getSelectionIndex());
        Button closeButton = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseWindow.this.close();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.m_table = new Table(composite, 65540);
        this.m_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = LicenseWindow.this.m_table.getSelectionIndex();
                LicenseWindow.this.updateSelection(index);
                LicenseWindow.this.m_table.showSelection();
            }
        });
        GridData data = new GridData(1808);
        data.heightHint = this.m_table.getItemHeight() * 3;
        data.horizontalSpan = 5;
        this.m_table.setLayoutData((Object)data);
        this.m_table.setLinesVisible(true);
        TableColumn column = new TableColumn(this.m_table, 16384);
        column.setText(Messages.getString("LicenseWindow_product", null));
        column.setWidth(260);
        column = new TableColumn(this.m_table, 16384);
        column.setText(Messages.getString("LicenseWindow_version", null));
        column.setWidth(80);
        column = new TableColumn(this.m_table, 16384);
        column.setText(Messages.getString("LicenseWindow_status", null));
        column.setWidth(160);
        ((GridData)this.m_table.getLayoutData()).horizontalSpan = 3;
        this.m_table.setHeaderVisible(true);
        this.setTitle(Messages.getString("LicenseWindow_fslLicense", null));
        this.setMessage(Messages.getString("LicenseWindow_viewLicense", null));
        return composite;
    }

    private void updateTable() {
        ExpectedFeature[] features;
        this.m_table.removeAll();
        ExpectedFeature[] expectedFeatureArray = features = ExpectedLicenses.list();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            ExpectedFeature feature = expectedFeatureArray[n2];
            TableItem item = new TableItem(this.m_table, 0);
            item.setText(0, feature.getLabel());
            item.setText(1, feature.getVersion());
            item.setText(2, this.getStatus(feature).getStatusText());
            ++n2;
        }
        if (this.m_table.getItemCount() > 0 && this.m_table.getSelectionCount() == 0) {
            this.m_table.select(0);
        }
        this.updateButtonFor(this.m_table.getSelectionIndex());
    }

    private void updateSelection(int index) {
        if (index == -1) {
            if (this.btnActivate != null) {
                this.btnActivate.setEnabled(false);
            }
        } else {
            this.updateButtonFor(index);
        }
    }

    private void updateButtonFor(int index) {
        ExpectedFeature feature = ExpectedLicenses.list()[index];
        if (this.btnActivate != null) {
            LicenseStatus status = this.getStatus(feature);
            if (LicenseStatus.LicenseStatusType.INITIALIZATION_ERROR.equals((Object)status.getType())) {
                this.btnActivate.setEnabled(false);
            } else if (!status.isEnabled()) {
                this.btnActivate.setText(Messages.getString("LicenseWindow_activate", null));
            } else {
                this.btnActivate.setText(Messages.getString("LicenseWindow_open", null));
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("LicenseWindow_prodLicenses", null));
    }

    private ExpectedFeature getSelectedFeature() {
        int index = this.m_table.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        ExpectedFeature[] features = ExpectedLicenses.list();
        return features[index];
    }

    private void activate() {
        ExpectedFeature selectedFeature = this.getSelectedFeature();
        if (selectedFeature != null) {
            new ActivateWindow(this.getParentShell(), selectedFeature, !this.getStatus(selectedFeature).isEnabled()).open();
        }
        this.updateTable();
    }

    private void details() {
        new DetailsWindow(this.getShell(), this.getDetails()).open();
    }

    private String getDetails() {
        StringBuilder sb = new StringBuilder();
        ExpectedFeature feature = this.getSelectedFeature();
        if (feature != null) {
            sb.append(feature.getLabel());
            sb.append("\n\n");
            LicenseStatus status = this.getStatus(feature);
            if (LicenseStatus.LicenseStatusType.INITIALIZATION_ERROR.equals((Object)status.getType())) {
                sb.append(status.getStatusText());
            }
            if (LicenseStatus.LicenseStatusType.EXPIRED.equals((Object)status.getType())) {
                sb.append(feature.getHowToProlonge());
            }
            if (LicenseStatus.LicenseStatusType.MISSED.equals((Object)status.getType())) {
                if (!feature.getHowToActivate().isEmpty()) {
                    sb.append(feature.getHowToActivate());
                } else {
                    sb.append(status.getStatusText());
                }
            }
            if (LicenseStatus.LicenseStatusType.ACTIVATED.equals((Object)status.getType()) || LicenseStatus.LicenseStatusType.EVALUATION.equals((Object)status.getType())) {
                String actId;
                try {
                    actId = LicenseUIActivator.getService().fetchLicenseFeature((FNOId)feature).getActivationId();
                }
                catch (LicenseException e) {
                    LicenseCoreActivator.log((int)4, (String)e.getMessage(), (Throwable)e);
                    actId = "error";
                }
                sb.append("ActivationId: ");
                sb.append(actId);
                sb.append("\nEvaluation Days: ");
                sb.append(status.getDaysLeft());
                sb.append("\nFeature Version: ");
                sb.append(feature.getVersion());
                sb.append("\nFeature Status: ");
                sb.append(status);
            }
        }
        return sb.toString();
    }
}

