/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.ui;

import com.nxp.s32ds.rcp.license.core.FNOId;
import com.nxp.s32ds.rcp.license.core.LicenseException;
import com.nxp.s32ds.rcp.license.core.LicenseFeature;
import com.nxp.s32ds.rcp.license.core.LicenseService;
import com.nxp.s32ds.rcp.license.ui.ActivateWindow;
import com.nxp.s32ds.rcp.license.ui.ExpectedFeature;
import com.nxp.s32ds.rcp.license.ui.LicenseUIActivator;
import com.nxp.s32ds.rcp.license.ui.StartupVerification;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.FrameworkUtil;

public class LicenseUiUtils {
    public static final String PLUGIN_ID = "com.nxp.s32ds.rcp.license.ui";

    public static IPreferenceStore getStore() {
        return new ScopedPreferenceStore(ConfigurationScope.INSTANCE, LicenseUiUtils.getPluginId());
    }

    private static String getPluginId() {
        return FrameworkUtil.getBundle(StartupVerification.class).getSymbolicName();
    }

    public static void requireLicense(FNOId id) throws LicenseException {
        LicenseService service = LicenseUIActivator.getService();
        LicenseFeature feature = service.fetchLicenseFeature(id);
        ExpectedFeature reqFeature = new ExpectedFeature(id.getProductName(), id.getFeatureId(), id.getVersion(), true, id.getFeatureId(), "", "");
        while (!feature.getStatus().isEnabled()) {
            if (new ActivateWindow(Display.getDefault().getActiveShell(), reqFeature, true).open() == 1) {
                throw new LicenseException("License not activated");
            }
            feature = service.fetchLicenseFeature(id);
        }
    }
}

