/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.browser.typeinfo;

import org.eclipse.cdt.core.browser.IFunctionInfo;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.IndexTypeInfo;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TypeInfoLabelProvider
extends LabelProvider {
    public static final int SHOW_NAME_ONLY = 1;
    public static final int SHOW_ENCLOSING_TYPE_ONLY = 2;
    public static final int SHOW_FULLY_QUALIFIED = 4;
    public static final int SHOW_PATH = 8;
    public static final int SHOW_PARAMETERS = 16;
    public static final int SHOW_RETURN_TYPE = 32;
    private static final Image HEADER_ICON = CDTSharedImages.getImage("icons/obj16/h_file_obj.gif");
    private static final Image SOURCE_ICON = CDTSharedImages.getImage("icons/obj16/c_file_obj.gif");
    private static final Image NAMESPACE_ICON = CDTSharedImages.getImage("icons/obj16/namespace_obj.gif");
    private static final Image TEMPLATE_ICON = CDTSharedImages.getImage("icons/obj16/template_obj.gif");
    private static final Image CLASS_ICON = CDTSharedImages.getImage("icons/obj16/class_obj.gif");
    private static final Image STRUCT_ICON = CDTSharedImages.getImage("icons/obj16/struct_obj.gif");
    private static final Image TYPEDEF_ICON = CDTSharedImages.getImage("icons/obj16/typedef_obj.gif");
    private static final Image UNION_ICON = CDTSharedImages.getImage("icons/obj16/union_obj.gif");
    private static final Image ENUM_ICON = CDTSharedImages.getImage("icons/obj16/enum_obj.gif");
    private static final Image FUNCTION_ICON = CDTSharedImages.getImage("icons/obj16/function_obj.gif");
    private static final Image VARIABLE_ICON = CDTSharedImages.getImage("icons/obj16/variable_obj.gif");
    private static final Image VARIABLE_LOCAL_ICON = CDTSharedImages.getImage("icons/obj16/variable_local_obj.gif");
    private static final Image ENUMERATOR_ICON = CDTSharedImages.getImage("icons/obj16/enumerator_obj.gif");
    private static final Image MACRO_ICON = CDTSharedImages.getImage("icons/obj16/define_obj.gif");
    private static final Image UNKNOWN_TYPE_ICON = CDTSharedImages.getImage("icons/obj16/unknown_type_obj.gif");
    private int fFlags;

    public TypeInfoLabelProvider(int flags) {
        this.fFlags = flags;
    }

    private boolean isSet(int flag) {
        return (this.fFlags & flag) != 0;
    }

    public String getText(Object element) {
        IFunctionInfo functionInfo;
        String[] params;
        int elementType;
        if (!(element instanceof ITypeInfo)) {
            return super.getText(element);
        }
        ITypeInfo typeInfo = (ITypeInfo)element;
        IQualifiedTypeName qualifiedName = typeInfo.getQualifiedTypeName();
        StringBuilder buf = new StringBuilder();
        if (this.isSet(1)) {
            String name = typeInfo.getName();
            if (name != null && name.length() > 0) {
                buf.append(name);
            }
        } else if (this.isSet(2)) {
            IQualifiedTypeName parentName = qualifiedName.getEnclosingTypeName();
            if (parentName != null) {
                buf.append(parentName.getFullyQualifiedName());
            } else {
                buf.append(TypeInfoMessages.TypeInfoLabelProvider_globalScope);
            }
        } else if (this.isSet(4)) {
            int elemType = typeInfo.getCElementType();
            if (elemType != 78 && qualifiedName.isGlobal() && (elemType != 74 && elemType != 76 || !(typeInfo instanceof IndexTypeInfo) || !((IndexTypeInfo)typeInfo).isFileLocal())) {
                buf.append(TypeInfoMessages.TypeInfoLabelProvider_globalScope);
                buf.append(' ');
            }
            buf.append(qualifiedName.getFullyQualifiedName());
        }
        if (this.isSet(16) && ((elementType = typeInfo.getCElementType()) == 74 || elementType == 79) && typeInfo instanceof IFunctionInfo && (params = (functionInfo = (IFunctionInfo)typeInfo).getParameters()) != null) {
            buf.append(FunctionDeclaration.getParameterClause((String[])params));
        }
        if (this.isSet(32)) {
            switch (typeInfo.getCElementType()) {
                case 74: {
                    IFunctionInfo functionInfo2;
                    String returnType;
                    if (!(typeInfo instanceof IFunctionInfo) || (returnType = (functionInfo2 = (IFunctionInfo)typeInfo).getReturnType()) == null || returnType.length() <= 0) break;
                    buf.append(TypeInfoMessages.TypeInfoLabelProvider_colon);
                    buf.append(returnType);
                    break;
                }
                case 76: {
                    ICElement[] cElements;
                    ITypeReference ref = typeInfo.getResolvedReference();
                    if (ref == null || (cElements = ref.getCElements()) == null || cElements.length <= 0) break;
                    String returnType = null;
                    if (cElements[0] instanceof IVariableDeclaration) {
                        try {
                            returnType = ((IVariableDeclaration)cElements[0]).getTypeName();
                        }
                        catch (CModelException cModelException) {}
                    }
                    if (returnType == null || returnType.length() <= 0) break;
                    buf.append(TypeInfoMessages.TypeInfoLabelProvider_colon);
                    buf.append(returnType);
                }
            }
        }
        if (this.isSet(8)) {
            IPath path = null;
            ITypeReference ref = typeInfo.getResolvedReference();
            if (ref != null) {
                path = ref.getPath();
            } else {
                ICProject project = typeInfo.getEnclosingProject();
                if (project != null) {
                    path = project.getProject().getFullPath();
                }
            }
            if (path != null) {
                buf.append(TypeInfoMessages.TypeInfoLabelProvider_dash);
                buf.append(path.toString());
            }
        }
        return buf.toString();
    }

    public Image getImage(Object element) {
        if (!(element instanceof ITypeInfo)) {
            return super.getImage(element);
        }
        ITypeInfo typeRef = (ITypeInfo)element;
        if (this.isSet(2)) {
            IPath path = null;
            ITypeReference ref = typeRef.getResolvedReference();
            if (ref != null) {
                IProject project;
                path = ref.getPath();
                ICProject cproject = typeRef.getEnclosingProject();
                IProject iProject = project = cproject == null ? null : cproject.getProject();
                if (CoreModel.isValidHeaderUnitName((IProject)project, (String)path.lastSegment())) {
                    return HEADER_ICON;
                }
            }
            return SOURCE_ICON;
        }
        return TypeInfoLabelProvider.getTypeIcon(typeRef.getCElementType());
    }

    public static Image getTypeIcon(int type) {
        switch (type) {
            case 61: {
                return NAMESPACE_ICON;
            }
            case 83: {
                return TEMPLATE_ICON;
            }
            case 65: {
                return CLASS_ICON;
            }
            case 67: {
                return STRUCT_ICON;
            }
            case 69: {
                return UNION_ICON;
            }
            case 63: {
                return ENUM_ICON;
            }
            case 80: {
                return TYPEDEF_ICON;
            }
            case 74: {
                return FUNCTION_ICON;
            }
            case 76: {
                return VARIABLE_ICON;
            }
            case 81: {
                return ENUMERATOR_ICON;
            }
            case 79: {
                return MACRO_ICON;
            }
            case 78: {
                return VARIABLE_LOCAL_ICON;
            }
        }
        return UNKNOWN_TYPE_ICON;
    }
}

