/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class ExcludedFileDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IFile || element instanceof IFolder) {
            IResource resource = (IResource)element;
            ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
            ICProjectDescription desc = mngr.getProjectDescription(resource.getProject(), 8);
            if (desc == null) {
                return;
            }
            ICConfigurationDescription conf = desc.getActiveConfiguration();
            ICSourceEntry[] entries = conf.getSourceEntries();
            IPath fullPath = resource.getFullPath();
            boolean isGeneratedResource = false;
            IResource curResource = resource;
            while (!(curResource.getParent() instanceof IProject)) {
                curResource = curResource.getParent();
            }
            if (curResource.getName().equals(conf.getName())) {
                isGeneratedResource = true;
            }
            if (!isGeneratedResource && CDataUtil.isExcluded((IPath)fullPath, (ICSourceEntry[])entries)) {
                decoration.addOverlay(CPluginImages.DESC_OVR_INACTIVE);
                decoration.setForegroundColor(JFaceResources.getColorRegistry().get("QUALIFIER_COLOR"));
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

