/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.text.HTMLPrinter;
import org.eclipse.cdt.internal.ui.text.c.hover.AbstractCEditorTextHover;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.cdt.ui.text.IHoverHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;

public class CDocHover
extends AbstractCEditorTextHover {
    @Override
    public String getHoverInfo(ITextViewer viewer, IRegion region) {
        String expression;
        block13: {
            IDocument document;
            block12: {
                expression = null;
                if (this.getEditor() == null) {
                    return null;
                }
                document = viewer.getDocument();
                if (document != null) break block12;
                return null;
            }
            expression = document.get(region.getOffset(), region.getLength());
            expression = expression.trim();
            if (!expression.isEmpty()) break block13;
            return null;
        }
        try {
            StringBuilder buffer = new StringBuilder();
            final IRegion hoverRegion = region;
            IHoverHelpInvocationContext context = new IHoverHelpInvocationContext(){

                @Override
                public IProject getProject() {
                    ITranslationUnit unit = this.getTranslationUnit();
                    if (unit != null) {
                        return unit.getCProject().getProject();
                    }
                    return null;
                }

                @Override
                public ITranslationUnit getTranslationUnit() {
                    IEditorInput editorInput = CDocHover.this.getEditor().getEditorInput();
                    return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
                }

                @Override
                public IRegion getHoverRegion() {
                    return hoverRegion;
                }
            };
            IFunctionSummary fs = CHelpProviderManager.getDefault().getFunctionInfo(context, expression);
            if (fs != null) {
                IRequiredInclude[] incs;
                buffer.append(CEditorMessages.DefaultCEditorTextHover_html_name);
                buffer.append(HTMLPrinter.convertToHTMLContent(fs.getName()));
                IFunctionSummary.IFunctionPrototypeSummary prototype = fs.getPrototype();
                if (prototype != null) {
                    buffer.append(CEditorMessages.DefaultCEditorTextHover_html_prototype);
                    buffer.append(HTMLPrinter.convertToHTMLContent(prototype.getPrototypeString(false)));
                }
                if (fs.getDescription() != null) {
                    buffer.append(CEditorMessages.DefaultCEditorTextHover_html_description);
                    buffer.append(fs.getDescription());
                }
                if ((incs = fs.getIncludes()) != null && incs.length > 0) {
                    buffer.append(CEditorMessages.DefaultCEditorTextHover_html_includes);
                    int count = 0;
                    IRequiredInclude[] iRequiredIncludeArray = incs;
                    int n = incs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRequiredInclude inc = iRequiredIncludeArray[n2];
                        buffer.append(inc.getIncludeName());
                        buffer.append("<br>");
                        if (count++ > 4) {
                            buffer.append("...<br>");
                            break;
                        }
                        ++n2;
                    }
                }
            }
            if (buffer.length() > 0) {
                HTMLPrinter.insertPageProlog(buffer, 0);
                HTMLPrinter.addPageEpilog(buffer);
                return buffer.toString();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    @Override
    public IRegion getHoverRegion(ITextViewer viewer, int offset) {
        if (viewer != null) {
            Point selectedRange = viewer.getSelectedRange();
            if (selectedRange.x >= 0 && selectedRange.y > 0 && offset >= selectedRange.x && offset <= selectedRange.x + selectedRange.y) {
                return new Region(selectedRange.x, selectedRange.y);
            }
            return CWordFinder.findWord(viewer.getDocument(), offset);
        }
        return null;
    }
}

