/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringSavePreferences;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.dialogs.ListDialog;

public class RefactoringSaveHelper {
    private boolean fFilesSaved;
    private final int fSaveMode;
    public static final int SAVE_ALL_ALWAYS_ASK = 1;
    public static final int SAVE_ALL = 2;
    public static final int SAVE_NOTHING = 3;
    public static final int SAVE_REFACTORING = 4;

    public RefactoringSaveHelper(int saveMode) {
        Assert.isLegal((saveMode == 1 || saveMode == 2 || saveMode == 3 || saveMode == 4 ? 1 : 0) != 0);
        this.fSaveMode = saveMode;
    }

    public boolean saveEditors(Shell shell) {
        IEditorPart[] dirtyEditors;
        switch (this.fSaveMode) {
            case 1: 
            case 2: {
                dirtyEditors = EditorUtility.getDirtyEditors(true);
                break;
            }
            case 4: {
                dirtyEditors = EditorUtility.getDirtyEditorsToSave(false);
                break;
            }
            case 3: {
                return true;
            }
            default: {
                throw new IllegalStateException(Integer.toString(this.fSaveMode));
            }
        }
        if (dirtyEditors.length == 0) {
            return true;
        }
        if (!this.askSaveAllDirtyEditors(shell, dirtyEditors)) {
            return false;
        }
        if (this.fSaveMode == 1 || this.fSaveMode == 2 || RefactoringSavePreferences.getSaveAllEditors()) {
            if (!CUIPlugin.getActiveWorkbenchWindow().getWorkbench().saveAllEditors(false)) {
                return false;
            }
        } else {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    int count = dirtyEditors.length;
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (String)"", (int)count);
                    try {
                        try {
                            int i = 0;
                            while (i < count) {
                                IEditorPart editor = dirtyEditors[i];
                                editor.doSave((IProgressMonitor)progress.split(1));
                                ++i;
                            }
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                    finally {
                        progress.done();
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)CUIPlugin.getActiveWorkbenchWindow(), runnable, null);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, shell, Messages.RefactoringSaveHelper_saving, Messages.RefactoringSaveHelper_unexpected_exception);
                return false;
            }
        }
        this.fFilesSaved = true;
        return true;
    }

    public void triggerIncrementalBuild() {
        if (this.fFilesSaved && ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(CUIPlugin.getActiveWorkbenchWindow(), 10).run();
        }
    }

    public boolean didSaveFiles() {
        return this.fFilesSaved;
    }

    private boolean askSaveAllDirtyEditors(Shell shell, IEditorPart[] dirtyEditors) {
        boolean canSaveAutomatically;
        boolean bl = canSaveAutomatically = this.fSaveMode != 1;
        if (canSaveAutomatically && RefactoringSavePreferences.getSaveAllEditors()) {
            return true;
        }
        ListDialog dialog = new ListDialog(shell){
            {
                super($anonymous0);
                this.setShellStyle(this.getShellStyle() | 0x10000);
            }

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                if (canSaveAutomatically) {
                    final Button check = new Button(result, 32);
                    check.setText(Messages.RefactoringSaveHelper_always_save);
                    check.setSelection(RefactoringSavePreferences.getSaveAllEditors());
                    check.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RefactoringSavePreferences.setSaveAllEditors(check.getSelection());
                        }
                    });
                    2.applyDialogFont((Control)result);
                }
                return result;
            }
        };
        dialog.setTitle(Messages.RefactoringSaveHelper_save_all_resources);
        dialog.setLabelProvider(this.createDialogLabelProvider());
        dialog.setMessage(Messages.RefactoringSaveHelper_must_save);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setInput(Arrays.asList(dirtyEditors));
        return dialog.open() == 0;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }
}

