/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.BufferChangedEvent;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.IBufferChangedListener;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Display;

public class DocumentAdapter
implements IBuffer,
IAdaptable,
IDocumentListener {
    private static final boolean DEBUG_LINE_DELIMITERS = true;
    public static final IBuffer NULL_BUFFER = new IBuffer(){

        public void addBufferChangedListener(IBufferChangedListener listener) {
        }

        public void append(char[] text) {
        }

        public void append(String text) {
        }

        public void close() {
        }

        public char getChar(int position) {
            return '\u0000';
        }

        public char[] getCharacters() {
            return new char[0];
        }

        public String getContents() {
            return "";
        }

        public int getLength() {
            return 0;
        }

        public IOpenable getOwner() {
            return null;
        }

        public String getText(int offset, int length) {
            return "";
        }

        public IResource getUnderlyingResource() {
            return null;
        }

        public boolean hasUnsavedChanges() {
            return false;
        }

        public boolean isClosed() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public void removeBufferChangedListener(IBufferChangedListener listener) {
        }

        public void replace(int position, int length, char[] text) {
        }

        public void replace(int position, int length, String text) {
        }

        public void save(IProgressMonitor progress, boolean force) throws CModelException {
        }

        public void setContents(char[] contents) {
        }

        public void setContents(String contents) {
        }
    };
    public static IBufferFactory FACTORY = new IBufferFactory(){

        public IBuffer createBuffer(IOpenable owner) {
            IResource r;
            IWorkingCopy wc;
            ITranslationUnit tu;
            if (owner instanceof IWorkingCopy && (tu = (wc = (IWorkingCopy)owner).getOriginalElement()) != null && (r = tu.getResource()) instanceof IFile) {
                return new DocumentAdapter(wc, (IFile)r);
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return NULL_BUFFER;
        }
    };
    private ITranslationUnit fTranslationUnit;
    private IWorkingCopy fOwner;
    private IFile fFile;
    private ITextFileBuffer fTextFileBuffer;
    IDocument fDocument;
    private DocumentSetCommand fSetCmd = new DocumentSetCommand();
    private DocumentReplaceCommand fReplaceCmd = new DocumentReplaceCommand();
    private Set<String> fLegalLineDelimiters;
    private List<IBufferChangedListener> fBufferListeners = new ArrayList<IBufferChangedListener>(3);
    private IStatus fStatus;

    public DocumentAdapter(IWorkingCopy owner, IFile file) {
        this.fOwner = owner;
        this.fFile = file;
        this.fTranslationUnit = owner.getOriginalElement();
        if (this.fTranslationUnit != null) {
            this.addBufferChangedListener((IBufferChangedListener)this.fTranslationUnit);
        }
        this.initialize();
    }

    private void initialize() {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath location = this.fFile.getFullPath();
        try {
            manager.connect(location, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            this.fTextFileBuffer = manager.getTextFileBuffer(location, LocationKind.IFILE);
            this.fDocument = this.fTextFileBuffer.getDocument();
        }
        catch (CoreException x) {
            this.fStatus = x.getStatus();
            this.fDocument = manager.createEmptyDocument(location, LocationKind.IFILE);
        }
        this.fDocument.addPrenotifiedDocumentListener((IDocumentListener)this);
    }

    public IStatus getStatus() {
        if (this.fStatus != null) {
            return this.fStatus;
        }
        if (this.fTextFileBuffer != null) {
            return this.fTextFileBuffer.getStatus();
        }
        return null;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void addBufferChangedListener(IBufferChangedListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.fBufferListeners.contains(listener)) {
            this.fBufferListeners.add(listener);
        }
    }

    public void removeBufferChangedListener(IBufferChangedListener listener) {
        Assert.isNotNull((Object)listener);
        this.fBufferListeners.remove(listener);
    }

    public void append(char[] text) {
        this.append(new String(text));
    }

    public void append(String text) {
        this.validateLineDelimiters(text);
        this.fReplaceCmd.replace(this.fDocument.getLength(), 0, text);
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        IDocument d = this.fDocument;
        this.fDocument = null;
        d.removePrenotifiedDocumentListener((IDocumentListener)this);
        if (this.fTextFileBuffer != null) {
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            try {
                manager.disconnect(this.fTextFileBuffer.getLocation(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
            this.fTextFileBuffer = null;
        }
        this.fireBufferChanged(new BufferChangedEvent((IBuffer)this, 0, 0, null));
        this.fBufferListeners.clear();
    }

    public char getChar(int position) {
        try {
            return this.fDocument.getChar(position);
        }
        catch (BadLocationException badLocationException) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public char[] getCharacters() {
        String content = this.getContents();
        return content == null ? null : content.toCharArray();
    }

    public String getContents() {
        return this.fDocument.get();
    }

    public int getLength() {
        return this.fDocument.getLength();
    }

    public IOpenable getOwner() {
        return this.fOwner;
    }

    public String getText(int offset, int length) {
        try {
            return this.fDocument.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public IResource getUnderlyingResource() {
        return this.fFile;
    }

    public boolean hasUnsavedChanges() {
        return this.fTextFileBuffer != null ? this.fTextFileBuffer.isDirty() : false;
    }

    public boolean isClosed() {
        return this.fDocument == null;
    }

    public boolean isReadOnly() {
        ResourceAttributes attributes;
        IResource resource = this.getUnderlyingResource();
        if (resource != null && (attributes = resource.getResourceAttributes()) != null) {
            return attributes.isReadOnly();
        }
        return false;
    }

    public void replace(int position, int length, char[] text) {
        this.replace(position, length, new String(text));
    }

    public void replace(int position, int length, String text) {
        this.validateLineDelimiters(text);
        this.fReplaceCmd.replace(position, length, text);
    }

    public void save(IProgressMonitor progress, boolean force) throws CModelException {
        try {
            if (this.fTextFileBuffer != null) {
                this.fTextFileBuffer.commit(progress, force);
            }
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    public void setContents(char[] contents) {
        this.setContents(new String(contents));
    }

    public void setContents(String contents) {
        int oldLength = this.fDocument.getLength();
        if (contents == null) {
            if (oldLength != 0) {
                this.fSetCmd.set("");
            }
        } else {
            this.validateLineDelimiters(contents);
            int newLength = contents.length();
            if (oldLength != newLength || !contents.equals(this.fDocument.get())) {
                this.fSetCmd.set(contents);
            }
        }
    }

    private void validateLineDelimiters(String contents) {
        if (this.fLegalLineDelimiters == null) {
            HashSet<String> existingDelimiters = new HashSet<String>();
            int i = this.fDocument.getNumberOfLines() - 1;
            while (i >= 0) {
                try {
                    String curr = this.fDocument.getLineDelimiter(i);
                    if (curr != null) {
                        existingDelimiters.add(curr);
                    }
                }
                catch (BadLocationException e) {
                    CUIPlugin.log(e);
                }
                --i;
            }
            if (existingDelimiters.isEmpty()) {
                return;
            }
            this.fLegalLineDelimiters = existingDelimiters;
        }
        DefaultLineTracker tracker = new DefaultLineTracker();
        tracker.set(contents);
        int lines = tracker.getNumberOfLines();
        if (lines <= 1) {
            return;
        }
        int i = 0;
        while (i < lines) {
            try {
                String curr = tracker.getLineDelimiter(i);
                if (curr != null && !this.fLegalLineDelimiters.contains(curr)) {
                    StringBuilder buf = new StringBuilder("New line delimiter added to new code: ");
                    int k = 0;
                    while (k < curr.length()) {
                        buf.append(String.valueOf((int)curr.charAt(k)));
                        ++k;
                    }
                    CUIPlugin.log(new Exception(buf.toString()));
                }
            }
            catch (BadLocationException e) {
                CUIPlugin.log(e);
            }
            ++i;
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.fireBufferChanged(new BufferChangedEvent((IBuffer)this, event.getOffset(), event.getLength(), event.getText()));
    }

    private void fireBufferChanged(BufferChangedEvent event) {
        if (this.fBufferListeners != null && this.fBufferListeners.size() > 0) {
            Iterator<IBufferChangedListener> e = new ArrayList<IBufferChangedListener>(this.fBufferListeners).iterator();
            while (e.hasNext()) {
                e.next().bufferChanged(event);
            }
        }
    }

    public ITextFileBuffer getTextFileBuffer() {
        return this.fTextFileBuffer;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ITextFileBuffer.class)) {
            return this.fTextFileBuffer;
        }
        if (adapter.isAssignableFrom(IDocument.class)) {
            return this.fDocument;
        }
        return null;
    }

    protected class DocumentReplaceCommand
    implements Runnable {
        private int fOffset;
        private int fLength;
        private String fText;

        protected DocumentReplaceCommand() {
        }

        @Override
        public void run() {
            try {
                DocumentAdapter.this.fDocument.replace(this.fOffset, this.fLength, this.fText);
            }
            catch (BadLocationException badLocationException) {}
        }

        public void replace(int offset, int length, String text) {
            this.fOffset = offset;
            this.fLength = length;
            this.fText = text;
            Display.getDefault().syncExec((Runnable)this);
        }
    }

    protected class DocumentSetCommand
    implements Runnable {
        private String fContents;

        protected DocumentSetCommand() {
        }

        @Override
        public void run() {
            DocumentAdapter.this.fDocument.set(this.fContents);
        }

        public void set(String contents) {
            this.fContents = contents;
            Display.getDefault().syncExec((Runnable)this);
        }
    }
}

