/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.cdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.cdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.osgi.util.TextProcessor;
import org.osgi.service.prefs.BackingStoreException;

public abstract class ProfileManager
extends Observable {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private static final String ID_PREFIX = "_";
    public static final int SELECTION_CHANGED_EVENT = 1;
    public static final int PROFILE_DELETED_EVENT = 2;
    public static final int PROFILE_RENAMED_EVENT = 3;
    public static final int PROFILE_CREATED_EVENT = 4;
    public static final int SETTINGS_CHANGED_EVENT = 5;
    private final String fProfileKey;
    private final String fProfileVersionKey;
    public static final String SHARED_PROFILE = "org.eclipse.cdt.ui.default.shared";
    private final Map<String, Profile> fProfiles;
    private final List<Profile> fProfilesByName;
    private Profile fSelected;
    private final KeySet[] fKeySets;
    private final PreferencesAccess fPreferencesAccess;
    private final IProfileVersioner fProfileVersioner;

    /*
     * WARNING - void declaration
     */
    public ProfileManager(List<Profile> profiles, IScopeContext context, PreferencesAccess preferencesAccess, IProfileVersioner profileVersioner, KeySet[] keySets, String profileKey, String profileVersionKey) {
        block8: {
            String projProfileId;
            Profile matching;
            Map<String, String> map;
            block10: {
                ArrayList<String> allKeys;
                block9: {
                    this.fPreferencesAccess = preferencesAccess;
                    this.fProfileVersioner = profileVersioner;
                    this.fKeySets = keySets;
                    this.fProfileKey = profileKey;
                    this.fProfileVersionKey = profileVersionKey;
                    this.fProfiles = new HashMap<String, Profile>();
                    this.fProfilesByName = new ArrayList<Profile>();
                    for (Profile element : profiles) {
                        Profile profile = element;
                        if (profile instanceof CustomProfile) {
                            ((CustomProfile)profile).setManager(this);
                        }
                        this.fProfiles.put(profile.getID(), profile);
                        this.fProfilesByName.add(profile);
                    }
                    Collections.sort(this.fProfilesByName);
                    String profileId = this.getSelectedProfileId(this.fPreferencesAccess.getInstanceScope());
                    Profile profile = this.fProfiles.get(profileId);
                    if (profile == null) {
                        profile = this.getDefaultProfile();
                    }
                    this.fSelected = profile;
                    if (context.getName() != "project" || !this.hasProjectSpecificSettings(context) || (map = this.readFromPreferenceStore(context, profile)) == null) break block8;
                    allKeys = new ArrayList<String>();
                    KeySet[] keySetArray = this.fKeySets;
                    int n = this.fKeySets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        KeySet keySet = keySetArray[n2];
                        allKeys.addAll(keySet.getKeys());
                        ++n2;
                    }
                    Collections.sort(allKeys);
                    matching = null;
                    projProfileId = context.getNode("org.eclipse.cdt.ui").get(this.fProfileKey, null);
                    if (projProfileId == null) break block9;
                    Profile profile2 = this.fProfiles.get(projProfileId);
                    if (profile2 == null || !profile2.isBuiltInProfile() && !profile2.hasEqualSettings(map, allKeys)) break block10;
                    matching = profile2;
                    break block10;
                }
                for (Object e : this.fProfilesByName) {
                    Profile curr = (Profile)e;
                    if (!curr.hasEqualSettings(map, allKeys)) continue;
                    matching = curr;
                    break;
                }
            }
            if (matching == null) {
                void var14_18;
                if (projProfileId != null && !this.fProfiles.containsKey(projProfileId)) {
                    String string = Messages.format(FormatterMessages.ProfileManager_unmanaged_profile_with_name, projProfileId.substring(ID_PREFIX.length()));
                } else {
                    String string = FormatterMessages.ProfileManager_unmanaged_profile;
                }
                SharedProfile shared = new SharedProfile((String)var14_18, map, this.fProfileVersioner.getCurrentVersion(), this.fProfileVersioner.getProfileKind());
                shared.setManager(this);
                this.fProfiles.put(shared.getID(), shared);
                this.fProfilesByName.add(shared);
                matching = shared;
            }
            this.fSelected = matching;
        }
    }

    protected String getSelectedProfileId(IScopeContext instanceScope) {
        String profileId = instanceScope.getNode("org.eclipse.cdt.ui").get(this.fProfileKey, null);
        if (profileId == null) {
            profileId = DefaultScope.INSTANCE.getNode("org.eclipse.cdt.ui").get(this.fProfileKey, null);
        }
        return profileId;
    }

    protected void notifyObservers(int message) {
        this.setChanged();
        this.notifyObservers((Object)message);
    }

    public static boolean hasProjectSpecificSettings(IScopeContext context, KeySet[] keySets) {
        KeySet[] keySetArray = keySets;
        int n = keySets.length;
        int n2 = 0;
        while (n2 < n) {
            KeySet keySet = keySetArray[n2];
            IEclipsePreferences preferences = context.getNode(keySet.getNodeName());
            for (String element : keySet.getKeys()) {
                String key = element;
                String val = preferences.get(key, null);
                if (val == null) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasProjectSpecificSettings(IScopeContext context) {
        return ProfileManager.hasProjectSpecificSettings(context, this.fKeySets);
    }

    public Map<String, String> readFromPreferenceStore(IScopeContext context, Profile workspaceProfile) {
        HashMap<String, String> profileOptions = new HashMap<String, String>();
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.cdt.ui");
        int version = uiPrefs.getInt(this.fProfileVersionKey, this.fProfileVersioner.getFirstVersion());
        if (version != this.fProfileVersioner.getCurrentVersion()) {
            HashMap<String, String> allOptions = new HashMap<String, String>();
            KeySet[] keySetArray = this.fKeySets;
            int n = this.fKeySets.length;
            int n2 = 0;
            while (n2 < n) {
                KeySet keySet = keySetArray[n2];
                this.addAll(context.getNode(keySet.getNodeName()), allOptions);
                ++n2;
            }
            CustomProfile profile = new CustomProfile("tmp", allOptions, version, this.fProfileVersioner.getProfileKind());
            this.fProfileVersioner.update(profile);
            return profile.getSettings();
        }
        boolean hasValues = false;
        KeySet[] keySetArray = this.fKeySets;
        int n = this.fKeySets.length;
        int n3 = 0;
        while (n3 < n) {
            KeySet keySet = keySetArray[n3];
            IEclipsePreferences preferences = context.getNode(keySet.getNodeName());
            for (String element : keySet.getKeys()) {
                String key = element;
                String val = preferences.get(key, null);
                if (val != null) {
                    hasValues = true;
                } else {
                    val = workspaceProfile.getSettings().get(key);
                }
                profileOptions.put(key, val);
            }
            ++n3;
        }
        if (!hasValues) {
            return null;
        }
        return profileOptions;
    }

    private void addAll(IEclipsePreferences uiPrefs, Map<String, String> allOptions) {
        try {
            String[] keys;
            String[] stringArray = keys = uiPrefs.keys();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String val = uiPrefs.get(key, null);
                if (val != null) {
                    allOptions.put(key, val);
                }
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private boolean updatePreferences(IEclipsePreferences prefs, List<String> keys, Map<String, String> profileOptions) {
        boolean hasChanges = false;
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String element;
            String key = element = iterator.next();
            String oldVal = prefs.get(key, null);
            String val = profileOptions.get(key);
            if (val == null) {
                if (oldVal == null) continue;
                prefs.remove(key);
                hasChanges = true;
                continue;
            }
            if (val.equals(oldVal)) continue;
            prefs.put(key, val);
            hasChanges = true;
        }
        return hasChanges;
    }

    private void writeToPreferenceStore(Profile profile, IScopeContext context) {
        Map<String, String> profileOptions = profile.getSettings();
        KeySet[] keySetArray = this.fKeySets;
        int n = this.fKeySets.length;
        int n2 = 0;
        while (n2 < n) {
            KeySet keySet = keySetArray[n2];
            this.updatePreferences(context.getNode(keySet.getNodeName()), keySet.getKeys(), profileOptions);
            ++n2;
        }
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.cdt.ui");
        if (uiPrefs.getInt(this.fProfileVersionKey, 0) != this.fProfileVersioner.getCurrentVersion()) {
            uiPrefs.putInt(this.fProfileVersionKey, this.fProfileVersioner.getCurrentVersion());
        }
        if (context.getName() == "instance") {
            uiPrefs.put(this.fProfileKey, profile.getID());
        } else if (context.getName() == "project" && !profile.isSharedProfile()) {
            uiPrefs.put(this.fProfileKey, profile.getID());
        }
    }

    public List<Profile> getSortedProfiles() {
        return Collections.unmodifiableList(this.fProfilesByName);
    }

    public String[] getSortedDisplayNames() {
        String[] sortedNames = new String[this.fProfilesByName.size()];
        int i = 0;
        Iterator<Profile> iterator = this.fProfilesByName.iterator();
        while (iterator.hasNext()) {
            Profile element;
            Profile curr = element = iterator.next();
            sortedNames[i++] = curr.getName();
        }
        return sortedNames;
    }

    public Profile getProfile(String ID) {
        return this.fProfiles.get(ID);
    }

    public void commitChanges(IScopeContext scopeContext) {
        if (this.fSelected != null) {
            this.writeToPreferenceStore(this.fSelected, scopeContext);
        }
    }

    public void clearAllSettings(IScopeContext context) {
        KeySet[] keySetArray = this.fKeySets;
        int n = this.fKeySets.length;
        int n2 = 0;
        while (n2 < n) {
            KeySet keySet = keySetArray[n2];
            this.updatePreferences(context.getNode(keySet.getNodeName()), keySet.getKeys(), EMPTY_MAP);
            ++n2;
        }
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.cdt.ui");
        uiPrefs.remove(this.fProfileKey);
    }

    public Profile getSelected() {
        return this.fSelected;
    }

    public void setSelected(Profile profile) {
        Profile newSelected = this.fProfiles.get(profile.getID());
        if (newSelected != null && !newSelected.equals(this.fSelected)) {
            this.fSelected = newSelected;
            this.notifyObservers(1);
        }
    }

    public boolean containsName(String name) {
        for (Profile element : this.fProfilesByName) {
            Profile curr = element;
            if (!name.equals(curr.getName())) continue;
            return true;
        }
        return false;
    }

    public void addProfile(CustomProfile profile) {
        profile.setManager(this);
        CustomProfile oldProfile = (CustomProfile)this.fProfiles.get(profile.getID());
        if (oldProfile != null) {
            this.fProfiles.remove(oldProfile.getID());
            this.fProfilesByName.remove(oldProfile);
            oldProfile.setManager(null);
        }
        this.fProfiles.put(profile.getID(), profile);
        this.fProfilesByName.add(profile);
        Collections.sort(this.fProfilesByName);
        this.fSelected = profile;
        this.notifyObservers(4);
    }

    public boolean deleteSelected() {
        if (!(this.fSelected instanceof CustomProfile)) {
            return false;
        }
        return this.deleteProfile((CustomProfile)this.fSelected);
    }

    public boolean deleteProfile(CustomProfile profile) {
        int index = this.fProfilesByName.indexOf(profile);
        this.fProfiles.remove(profile.getID());
        this.fProfilesByName.remove(profile);
        profile.setManager(null);
        if (index >= this.fProfilesByName.size()) {
            --index;
        }
        this.fSelected = this.fProfilesByName.get(index);
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(profile.getID(), null, false);
        }
        this.notifyObservers(2);
        return true;
    }

    public void profileRenamed(CustomProfile profile, String oldID) {
        this.fProfiles.remove(oldID);
        this.fProfiles.put(profile.getID(), profile);
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(oldID, profile, false);
        }
        Collections.sort(this.fProfilesByName);
        this.notifyObservers(3);
    }

    public void profileReplaced(CustomProfile oldProfile, CustomProfile newProfile) {
        this.fProfiles.remove(oldProfile.getID());
        this.fProfiles.put(newProfile.getID(), newProfile);
        this.fProfilesByName.remove(oldProfile);
        this.fProfilesByName.add(newProfile);
        Collections.sort(this.fProfilesByName);
        if (!oldProfile.isSharedProfile()) {
            this.updateProfilesWithName(oldProfile.getID(), null, false);
        }
        this.setSelected(newProfile);
        this.notifyObservers(4);
        this.notifyObservers(1);
    }

    public void profileChanged(CustomProfile profile) {
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(profile.getID(), profile, true);
        }
        this.notifyObservers(5);
    }

    private void updateProfilesWithName(String oldName, Profile newProfile, boolean applySettings) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IScopeContext projectScope = this.fPreferencesAccess.getProjectScope(project);
            IEclipsePreferences node = projectScope.getNode("org.eclipse.cdt.ui");
            String profileId = node.get(this.fProfileKey, null);
            if (oldName.equals(profileId)) {
                if (newProfile == null) {
                    node.remove(this.fProfileKey);
                } else if (applySettings) {
                    this.writeToPreferenceStore(newProfile, projectScope);
                } else {
                    node.put(this.fProfileKey, newProfile.getID());
                }
            }
            ++n2;
        }
        IScopeContext instanceScope = this.fPreferencesAccess.getInstanceScope();
        IEclipsePreferences uiPrefs = instanceScope.getNode("org.eclipse.cdt.ui");
        if (newProfile != null && oldName.equals(uiPrefs.get(this.fProfileKey, null))) {
            this.writeToPreferenceStore(newProfile, instanceScope);
        }
    }

    public Profile getDefaultProfile() {
        return this.getProfile(this.fPreferencesAccess.getDefaultScope().getNode("org.eclipse.cdt.ui").get(this.fProfileKey, ""));
    }

    public IProfileVersioner getProfileVersioner() {
        return this.fProfileVersioner;
    }

    public static final class BuiltInProfile
    extends Profile {
        private final String fName;
        private final String fID;
        private final Map<String, String> fSettings;
        private final int fOrder;
        private final int fCurrentVersion;
        private final String fProfileKind;

        protected BuiltInProfile(String ID, String name, Map<String, String> settings, int order, int currentVersion, String profileKind) {
            this.fName = TextProcessor.process((String)name);
            this.fID = ID;
            this.fSettings = settings;
            this.fOrder = order;
            this.fCurrentVersion = currentVersion;
            this.fProfileKind = profileKind;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public Profile rename(String name, ProfileManager manager) {
            String trimmed = name.trim();
            CustomProfile newProfile = new CustomProfile(trimmed, this.fSettings, this.fCurrentVersion, this.fProfileKind);
            manager.addProfile(newProfile);
            return newProfile;
        }

        @Override
        public Map<String, String> getSettings() {
            return this.fSettings;
        }

        @Override
        public void setSettings(Map<String, String> settings) {
        }

        @Override
        public String getID() {
            return this.fID;
        }

        @Override
        public final int compareTo(Profile o) {
            if (o instanceof BuiltInProfile) {
                return this.fOrder - ((BuiltInProfile)o).fOrder;
            }
            return -1;
        }

        @Override
        public boolean isProfileToSave() {
            return false;
        }

        @Override
        public boolean isBuiltInProfile() {
            return true;
        }

        @Override
        public int getVersion() {
            return this.fCurrentVersion;
        }
    }

    public static class CustomProfile
    extends Profile {
        private String fName;
        private Map<String, String> fSettings;
        protected ProfileManager fManager;
        private int fVersion;
        private final String fKind;

        public CustomProfile(String name, Map<String, String> settings, int version, String kind) {
            this.fName = name;
            this.fSettings = settings;
            this.fVersion = version;
            this.fKind = kind;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public Profile rename(String name, ProfileManager manager) {
            String trimmed = name.trim();
            if (trimmed.equals(this.getName())) {
                return this;
            }
            String oldID = this.getID();
            this.fName = trimmed;
            manager.profileRenamed(this, oldID);
            return this;
        }

        @Override
        public Map<String, String> getSettings() {
            return this.fSettings;
        }

        @Override
        public void setSettings(Map<String, String> settings) {
            if (settings == null) {
                throw new IllegalArgumentException();
            }
            this.fSettings = settings;
            if (this.fManager != null) {
                this.fManager.profileChanged(this);
            }
        }

        @Override
        public String getID() {
            return ProfileManager.ID_PREFIX + this.fName;
        }

        public void setManager(ProfileManager profileManager) {
            this.fManager = profileManager;
        }

        public ProfileManager getManager() {
            return this.fManager;
        }

        @Override
        public int getVersion() {
            return this.fVersion;
        }

        public void setVersion(int version) {
            this.fVersion = version;
        }

        @Override
        public int compareTo(Profile o) {
            if (o instanceof SharedProfile) {
                return -1;
            }
            if (o instanceof CustomProfile) {
                return this.getName().compareToIgnoreCase(o.getName());
            }
            return 1;
        }

        @Override
        public boolean isProfileToSave() {
            return true;
        }

        public String getKind() {
            return this.fKind;
        }
    }

    public static final class KeySet {
        private final List<String> fKeys;
        private final String fNodeName;

        public KeySet(String nodeName, List<String> keys) {
            this.fNodeName = nodeName;
            this.fKeys = keys;
        }

        public String getNodeName() {
            return this.fNodeName;
        }

        public List<String> getKeys() {
            return this.fKeys;
        }
    }

    public static abstract class Profile
    implements Comparable<Profile> {
        public abstract String getName();

        public abstract Profile rename(String var1, ProfileManager var2);

        public abstract Map<String, String> getSettings();

        public abstract void setSettings(Map<String, String> var1);

        public abstract int getVersion();

        public boolean hasEqualSettings(Map<String, String> otherMap, Collection<String> allKeys) {
            Map<String, String> settings = this.getSettings();
            Iterator<String> iterator = allKeys.iterator();
            while (iterator.hasNext()) {
                String element;
                String key = element = iterator.next();
                String other = otherMap.get(key);
                String curr = settings.get(key);
                if (!(other == null ? curr != null : !other.equals(curr))) continue;
                return false;
            }
            return true;
        }

        public abstract boolean isProfileToSave();

        public abstract String getID();

        public boolean isSharedProfile() {
            return false;
        }

        public boolean isBuiltInProfile() {
            return false;
        }
    }

    public static final class SharedProfile
    extends CustomProfile {
        public SharedProfile(String oldName, Map<String, String> options, int version, String profileKind) {
            super(oldName, options, version, profileKind);
        }

        @Override
        public Profile rename(String name, ProfileManager manager) {
            CustomProfile profile = new CustomProfile(name.trim(), this.getSettings(), this.getVersion(), this.getKind());
            manager.profileReplaced(this, profile);
            return profile;
        }

        @Override
        public String getID() {
            return ProfileManager.SHARED_PROFILE;
        }

        @Override
        public final int compareTo(Profile o) {
            return 1;
        }

        @Override
        public boolean isProfileToSave() {
            return false;
        }

        @Override
        public boolean isSharedProfile() {
            return true;
        }
    }
}

