/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Combo;

public class ProposalFilterPreferencesUtil {
    private ProposalFilterPreferencesUtil() {
    }

    public static String[] getProposalFilterNames() {
        ArrayList<String> names = new ArrayList<String>();
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", "ProposalFilter");
            if (point != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = point.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        String filterName;
                        IConfigurationElement element = elements[j];
                        if ("ProposalFilter".equals(element.getName()) && (filterName = element.getAttribute("name")) != null) {
                            names.add(filterName);
                        }
                        ++j;
                    }
                    ++n2;
                }
            }
        }
        catch (InvalidRegistryObjectException e) {
            CUIPlugin.log(e);
        }
        String[] filterNames = names.toArray(new String[names.size()]);
        return filterNames;
    }

    public static String getProposalFilternamesAsString() {
        String[] names;
        StringBuilder filterNames = new StringBuilder("0;");
        filterNames.append(PreferencesMessages.ProposalFilterPreferencesUtil_defaultFilterName);
        String[] stringArray = names = ProposalFilterPreferencesUtil.getProposalFilterNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            filterNames.append(";");
            filterNames.append(name);
            ++n2;
        }
        return filterNames.toString();
    }

    public static IConfigurationElement getElementForName(String filterName) {
        IConfigurationElement element;
        block7: {
            element = null;
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", "ProposalFilter");
            if (point != null) {
                try {
                    IExtension[] extensions = point.getExtensions();
                    if (extensions.length < 1) break block7;
                    IExtension[] iExtensionArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] elements = extension.getConfigurationElements();
                        int j = 0;
                        while (j < elements.length) {
                            String testName;
                            IConfigurationElement testElement = elements[j];
                            if ("ProposalFilter".equals(testElement.getName()) && (testName = testElement.getAttribute("name")) != null && filterName.equals(testName)) {
                                element = testElement;
                                break;
                            }
                            ++j;
                        }
                        if (element == null) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
            }
        }
        return element;
    }

    public static String comboStateAsString(Combo combo) {
        String[] entries;
        StringBuilder text = new StringBuilder();
        int selectionIndex = combo.getSelectionIndex();
        text.append(selectionIndex);
        String[] stringArray = entries = combo.getItems();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entrie = stringArray[n2];
            text.append(";");
            String entry = entrie.replaceAll(";", ",");
            text.append(entry);
            ++n2;
        }
        return text.toString();
    }

    public static void restoreComboFromString(Combo combo, String text) {
        try {
            int endFirstEntry = text.indexOf(";");
            if (endFirstEntry > 0) {
                String selectedString = text.substring(0, endFirstEntry);
                int selectedIndex = Integer.parseInt(selectedString);
                String[] entryList = text.substring(endFirstEntry + 1, text.length()).split(";");
                combo.setItems(entryList);
                combo.select(selectedIndex);
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public static ComboState getComboState(String comboPreference) {
        ComboState state = new ComboState();
        try {
            int endFirstEntry = comboPreference.indexOf(";");
            if (endFirstEntry > 0) {
                String selectedString = comboPreference.substring(0, endFirstEntry);
                state.selectedIndex = Integer.parseInt(selectedString);
                state.items = comboPreference.substring(endFirstEntry + 1, comboPreference.length()).split(";");
            }
        }
        catch (NumberFormatException numberFormatException) {
            state.items = new String[0];
        }
        return state;
    }

    public static IConfigurationElement getPreferredFilterElement() {
        IConfigurationElement preferredElement = null;
        try {
            IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
            String filterComboStateString = store.getString("content_assist_proposal_filter");
            ComboState state = ProposalFilterPreferencesUtil.getComboState(filterComboStateString);
            preferredElement = ProposalFilterPreferencesUtil.getElementForName(state.items[state.selectedIndex]);
        }
        catch (Exception exception) {}
        return preferredElement;
    }

    public static class ComboState {
        public int selectedIndex;
        public String[] items;
    }
}

