/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.core.model.ext.CElementHandleFactory;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionToDeclarationJob
extends Job
implements ASTCache.ASTRunnable {
    private final ITranslationUnit fTranslationUnit;
    private IIndex fIndex;
    private final ITextSelection fTextSelection;
    private IFunctionDeclaration[] fResolvedFunctions;

    public SelectionToDeclarationJob(ITextEditor editor, ITextSelection textSelection) throws CoreException {
        super(CEditorMessages.OpenDeclarations_dialog_title);
        if (!(editor instanceof CEditor)) {
            Status status = new Status(4, "org.eclipse.cdt.ui", 10001, "Action not supportted outside the context of the C Editor", null);
            throw new CoreException((IStatus)status);
        }
        this.fTranslationUnit = ((CEditor)editor).getInputCElement();
        this.fTextSelection = textSelection;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            return this.resolve(monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    IStatus resolve(IProgressMonitor monitor) throws CoreException {
        assert (this.fIndex == null);
        if (this.fIndex != null) {
            return Status.CANCEL_STATUS;
        }
        this.fIndex = CCorePlugin.getIndexManager().getIndex(this.fTranslationUnit.getCProject(), 11);
        try {
            this.fIndex.acquireReadLock();
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        try {
            IStatus iStatus = ASTProvider.getASTProvider().runOnAST((ICElement)this.fTranslationUnit, ASTProvider.WAIT_NO, monitor, this);
            return iStatus;
        }
        finally {
            this.fIndex.releaseReadLock();
        }
    }

    public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
        this.fResolvedFunctions = new IFunctionDeclaration[0];
        if (ast == null) {
            return Status.OK_STATUS;
        }
        int selectionStart = this.fTextSelection.getOffset();
        int selectionLength = this.fTextSelection.getLength();
        IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
        IASTName sourceName = nodeSelector.findEnclosingName(selectionStart, selectionLength);
        if (sourceName == null) {
            Status status = new Status(4, "org.eclipse.cdt.ui", CEditorMessages.StepIntoSelection_unable_to_resolve_name);
            throw new CoreException((IStatus)status);
        }
        Object[] implicitTargets = this.findImplicitTargets(ast, nodeSelector, selectionStart, selectionLength);
        NameKind kind = SelectionToDeclarationJob.getNameKind((IName)sourceName);
        IBinding b = sourceName.resolveBinding();
        IBinding[] bindings = new IBinding[]{b};
        if (b instanceof IProblemBinding) {
            IBinding[] candidateBindings = ((IProblemBinding)b).getCandidateBindings();
            if (candidateBindings.length != 0) {
                bindings = candidateBindings;
            }
        } else if (kind == NameKind.DEFINITION && b instanceof IType) {
            return Status.OK_STATUS;
        }
        Object[] targets = IName.EMPTY_ARRAY;
        String filename = ast.getFilePath();
        IBinding[] iBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            if (binding != null && !(binding instanceof IProblemBinding)) {
                IName[] names;
                IName[] iNameArray = names = this.findDeclNames(ast, kind, binding);
                int n3 = names.length;
                int n4 = 0;
                while (n4 < n3) {
                    IName name = iNameArray[n4];
                    if (!(name == null || name instanceof IIndexName && filename.equals(((IIndexName)name).getFileLocation().getFileName()) || this.areOverlappingNames(name, (IName)sourceName))) {
                        if (binding instanceof IParameter) {
                            if (SelectionToDeclarationJob.isInSameFunction(sourceName, name)) {
                                targets = (IName[])ArrayUtil.append((Object[])targets, (Object)name);
                            }
                        } else if (binding instanceof ICPPTemplateParameter) {
                            if (SelectionToDeclarationJob.isInSameTemplate(sourceName, name)) {
                                targets = (IName[])ArrayUtil.append((Object[])targets, (Object)name);
                            }
                        } else {
                            targets = (IName[])ArrayUtil.append((Object[])targets, (Object)name);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        targets = (IName[])ArrayUtil.trim((Object[])((IName[])ArrayUtil.addAll((Object[])targets, (Object[])implicitTargets)));
        ArrayList<IFunctionDeclaration> functionElements = new ArrayList<IFunctionDeclaration>();
        this.filterToFunctions(this.fTranslationUnit.getCProject(), this.fIndex, (IName[])targets, functionElements);
        this.fResolvedFunctions = functionElements.toArray(new IFunctionDeclaration[functionElements.size()]);
        return Status.OK_STATUS;
    }

    public IFunctionDeclaration[] getSelectedFunctions() {
        return this.fResolvedFunctions;
    }

    private IName[] findDeclNames(IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        ICPPClassType clsBinding;
        ICPPMethod method;
        IName[] declNames = this.findNames(this.fIndex, ast, kind, binding);
        while (declNames.length == 0 && binding instanceof ICPPSpecialization) {
            if ((binding = ((ICPPSpecialization)binding).getSpecializedBinding()) == null || binding instanceof IProblemBinding) continue;
            declNames = this.findNames(this.fIndex, ast, NameKind.DEFINITION, binding);
        }
        if (declNames.length == 0 && binding instanceof ICPPMethod && (method = (ICPPMethod)binding).isImplicit() && (clsBinding = method.getClassOwner()) != null && !(clsBinding instanceof IProblemBinding)) {
            declNames = this.findNames(this.fIndex, ast, NameKind.REFERENCE, (IBinding)clsBinding);
        }
        return declNames;
    }

    private IName[] findNames(IIndex index, IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        IName[] declNames = kind == NameKind.DEFINITION ? this.findDeclarations(index, ast, binding) : this.findDefinitions(index, ast, kind, binding);
        if (declNames.length == 0) {
            declNames = kind == NameKind.DEFINITION ? this.findDefinitions(index, ast, kind, binding) : this.findDeclarations(index, ast, binding);
        }
        return declNames;
    }

    private IName[] findDefinitions(IIndex index, IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        ArrayList<IASTName> declNames = new ArrayList<IASTName>();
        declNames.addAll(Arrays.asList(ast.getDefinitionsInAST(binding)));
        Iterator i = declNames.iterator();
        while (i.hasNext()) {
            IASTName name = (IASTName)i.next();
            IBinding b2 = name.resolveBinding();
            if (b2 instanceof ICPPUsingDeclaration) {
                i.remove();
            }
            if (binding == b2 || !(binding instanceof ICPPSpecialization)) continue;
            IBinding spec = binding;
            while (spec instanceof ICPPSpecialization) {
                if ((spec = ((ICPPSpecialization)spec).getSpecializedBinding()) == b2) break;
            }
            if (spec instanceof ICPPSpecialization) continue;
            i.remove();
        }
        if (!declNames.isEmpty()) {
            return (IName[])declNames.toArray(new IASTName[declNames.size()]);
        }
        return index.findNames(binding, 10);
    }

    private IName[] findDeclarations(IIndex index, IASTTranslationUnit ast, IBinding binding) throws CoreException {
        Object[] astNames = ast.getDeclarationsInAST(binding);
        ArrayList<Object> usingDeclarations = null;
        int i = 0;
        while (i < astNames.length) {
            Object name = astNames[i];
            if (name.isDefinition()) {
                astNames[i] = null;
            } else if (ASTQueries.findAncestorWithType((IASTNode)name, ICPPASTUsingDeclaration.class) != null) {
                if (usingDeclarations == null) {
                    usingDeclarations = new ArrayList<Object>(1);
                }
                usingDeclarations.add(name);
                astNames[i] = null;
            }
            ++i;
        }
        IName[] declNames = (IName[])ArrayUtil.removeNulls((Object[])astNames);
        if (declNames.length == 0) {
            declNames = index.findNames(binding, 9);
        }
        if (declNames.length == 0 && usingDeclarations != null) {
            declNames = usingDeclarations.toArray(new IName[usingDeclarations.size()]);
        }
        return declNames;
    }

    private IName[] findImplicitTargets(IASTTranslationUnit ast, IASTNodeSelector nodeSelector, int offset, int length) throws CoreException {
        Object[] definitions = IName.EMPTY_ARRAY;
        IASTImplicitName firstName = nodeSelector.findEnclosingImplicitName(offset, length);
        if (firstName != null) {
            IASTImplicitNameOwner owner = (IASTImplicitNameOwner)firstName.getParent();
            IASTImplicitName[] iASTImplicitNameArray = owner.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (((ASTNode)name).getOffset() == ((ASTNode)firstName).getOffset()) {
                    IBinding binding = name.resolveBinding();
                    Object[] declNames = this.findDeclNames(ast, NameKind.REFERENCE, binding);
                    definitions = (IName[])ArrayUtil.addAll((Object[])definitions, (Object[])declNames);
                }
                ++n2;
            }
        }
        return (IName[])ArrayUtil.trim((Object[])definitions);
    }

    private static NameKind getNameKind(IName name) {
        if (name.isDefinition()) {
            if (SelectionToDeclarationJob.getBinding(name) instanceof ICPPUsingDeclaration) {
                return NameKind.USING_DECL;
            }
            return NameKind.DEFINITION;
        }
        if (name.isDeclaration()) {
            return NameKind.DECLARATION;
        }
        return NameKind.REFERENCE;
    }

    private static IBinding getBinding(IName name) {
        if (name instanceof IASTName) {
            return ((IASTName)name).resolveBinding();
        }
        if (name instanceof IIndexFragmentName) {
            try {
                return ((IIndexFragmentName)name).getBinding();
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private boolean areOverlappingNames(IName n1, IName n2) {
        if (n1 == n2) {
            return true;
        }
        IASTFileLocation loc1 = n1.getFileLocation();
        IASTFileLocation loc2 = n2.getFileLocation();
        if (loc1 == null || loc2 == null) {
            return false;
        }
        return loc1.getFileName().equals(loc2.getFileName()) && Math.max(loc1.getNodeOffset(), loc2.getNodeOffset()) < Math.min(loc1.getNodeOffset() + loc1.getNodeLength(), loc2.getNodeOffset() + loc2.getNodeLength());
    }

    private static boolean isInSameFunction(IASTName refName, IName funcDeclName) {
        if (funcDeclName instanceof IASTName) {
            IASTDeclaration fdef = SelectionToDeclarationJob.getEnclosingFunctionDefinition((IASTNode)funcDeclName);
            return fdef != null && fdef.contains((IASTNode)refName);
        }
        return false;
    }

    private static IASTDeclaration getEnclosingFunctionDefinition(IASTNode node) {
        while (node != null && !(node instanceof IASTFunctionDefinition)) {
            node = node.getParent();
        }
        return (IASTDeclaration)node;
    }

    private static boolean isInSameTemplate(IASTName refName, IName templateDeclName) {
        if (templateDeclName instanceof IASTName) {
            IASTDeclaration template = SelectionToDeclarationJob.getEnclosingTemplateDeclaration((IASTNode)refName);
            return template != null && template.contains((IASTNode)refName);
        }
        return false;
    }

    private static IASTDeclaration getEnclosingTemplateDeclaration(IASTNode node) {
        while (node != null && !(node instanceof ICPPASTTemplateDeclaration)) {
            node = node.getParent();
        }
        return (IASTDeclaration)node;
    }

    private void filterToFunctions(ICProject project, IIndex index, IName[] declNames, List<IFunctionDeclaration> functionElements) {
        IName[] iNameArray = declNames;
        int n = declNames.length;
        int n2 = 0;
        while (n2 < n) {
            IName declName = iNameArray[n2];
            try {
                ICElementHandle elem = this.getCElementForName(project, index, declName);
                if (elem instanceof IFunctionDeclaration) {
                    functionElements.add((IFunctionDeclaration)elem);
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
            ++n2;
        }
    }

    private ICElementHandle getCElementForName(ICProject project, IIndex index, IName declName) throws CoreException {
        if (declName instanceof IIndexName) {
            return IndexUI.getCElementForName(project, index, (IIndexName)declName);
        }
        if (declName instanceof IASTName) {
            ITranslationUnit tu;
            IASTName astName = (IASTName)declName;
            IBinding binding = astName.resolveBinding();
            if (binding != null && (tu = IndexUI.getTranslationUnit(astName)) != null) {
                if (tu instanceof IWorkingCopy) {
                    tu = ((IWorkingCopy)tu).getOriginalElement();
                }
                IASTFileLocation loc = astName.getFileLocation();
                Region region = new Region(loc.getNodeOffset(), loc.getNodeLength());
                return CElementHandleFactory.create((ITranslationUnit)tu, (IBinding)binding, (boolean)astName.isDefinition(), (IRegion)region, (long)0L);
            }
            return null;
        }
        return null;
    }

    private static enum NameKind {
        REFERENCE,
        DECLARATION,
        USING_DECL,
        DEFINITION;

    }
}

