/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.AbstractToggleLinkingAction;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.actions.CollapseAllAction;
import org.eclipse.cdt.internal.ui.cview.SelectionTransferDragAdapter;
import org.eclipse.cdt.internal.ui.cview.SelectionTransferDropAdapter;
import org.eclipse.cdt.internal.ui.dnd.CDTViewerDragAdapter;
import org.eclipse.cdt.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.cdt.internal.ui.dnd.TransferDragSourceListener;
import org.eclipse.cdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinerProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.LexicalSortingAction;
import org.eclipse.cdt.internal.ui.editor.OpenIncludeAction;
import org.eclipse.cdt.internal.ui.editor.TogglePresentationAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.cdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.DecoratingCLabelProvider;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IncludesGrouping;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.cdt.ui.actions.OpenViewActionGroup;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractCModelOutlinePage
extends Page
implements IContentOutlinePage,
ISelectionChangedListener,
IAdaptable {
    private static final long TEXT_FLAGS = 1073742345L;
    private static final int IMAGE_FLAGS = 1;
    protected ITextEditor fEditor;
    protected ITranslationUnit fInput;
    private ProblemTreeViewer fTreeViewer;
    private ListenerList fSelectionChangedListeners = new ListenerList(1);
    protected TogglePresentationAction fTogglePresentation;
    protected String fContextMenuId;
    private Menu fMenu;
    protected OpenIncludeAction fOpenIncludeAction;
    private ToggleLinkingAction fToggleLinkingAction;
    private ActionGroup fMemberFilterActionGroup;
    private ActionGroup fSelectionSearchGroup;
    private ActionGroup fRefactoringActionGroup;
    private ActionGroup fSourceActionGroup;
    private ActionGroup fOpenViewActionGroup;
    private ActionGroup fCustomFiltersActionGroup;
    private CollapseAllAction fCollapseAllAction;

    public AbstractCModelOutlinePage(String contextMenuId, ITextEditor editor) {
        this.fEditor = editor;
        this.fInput = null;
        this.fContextMenuId = contextMenuId;
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setEditor(editor);
        this.fOpenIncludeAction = new OpenIncludeAction((ISelectionProvider)this);
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == IShowInSource.class) {
            return (T)this.getShowInSource();
        }
        if (key == IShowInTargetList.class) {
            return (T)new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
                }
            };
        }
        if (key == IShowInTarget.class) {
            return (T)this.getShowInTarget();
        }
        return null;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, AbstractCModelOutlinePage.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    protected IShowInTarget getShowInTarget() {
        return new IShowInTarget(){

            public boolean show(ShowInContext context) {
                ISelection sel = context.getSelection();
                if (sel instanceof ITextSelection) {
                    ITextSelection tsel = (ITextSelection)sel;
                    int offset = tsel.getOffset();
                    ICElement element = null;
                    if (AbstractCModelOutlinePage.this.fEditor instanceof CEditor) {
                        element = ((CEditor)AbstractCModelOutlinePage.this.fEditor).getElementAt(offset, false);
                    } else if (AbstractCModelOutlinePage.this.fInput != null) {
                        try {
                            element = AbstractCModelOutlinePage.this.fInput.getElementAtOffset(offset);
                        }
                        catch (CModelException e) {
                            CUIPlugin.log(e);
                        }
                    }
                    if (element != null) {
                        AbstractCModelOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)element));
                        return true;
                    }
                } else if (sel instanceof IStructuredSelection) {
                    AbstractCModelOutlinePage.this.setSelection(sel);
                    return true;
                }
                return false;
            }
        };
    }

    public boolean isLinkingEnabled() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.outline.linktoeditor");
    }

    public ICElement getRoot() {
        return this.fInput;
    }

    public void synchronizeSelectionWithEditor() {
        if (this.fInput == null || this.fEditor == null || this.fTreeViewer == null) {
            return;
        }
        ITextSelection editorSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        if (editorSelection == null) {
            return;
        }
        int offset = editorSelection.getOffset();
        ICElement editorElement = null;
        try {
            if (this.fInput.isStructureKnown() && this.fInput.isConsistent()) {
                editorElement = this.fInput.getElementAtOffset(offset);
            }
        }
        catch (CModelException cModelException) {
            return;
        }
        if (editorElement != null) {
            StructuredSelection selection = new StructuredSelection(editorElement);
            this.fTreeViewer.setSelection((ISelection)selection, true);
        }
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        CUIPlugin.createStandardGroups(menu);
        ISelection selection = this.getSelection();
        if (this.fOpenViewActionGroup != null && OpenViewActionGroup.canActionBeAdded(selection)) {
            this.fOpenViewActionGroup.fillContextMenu(menu);
        }
        if (OpenIncludeAction.canActionBeAdded(selection)) {
            menu.appendToGroup("group.open", (IAction)this.fOpenIncludeAction);
        }
        if (this.fSelectionSearchGroup != null && SelectionSearchGroup.canActionBeAdded(selection)) {
            this.fSelectionSearchGroup.fillContextMenu(menu);
            menu.add((IContributionItem)new Separator("additions"));
        }
        if (this.fSourceActionGroup != null) {
            this.fSourceActionGroup.fillContextMenu(menu);
        }
        if (this.fRefactoringActionGroup != null) {
            this.fRefactoringActionGroup.fillContextMenu(menu);
        }
    }

    protected CContentOutlinerProvider createContentProvider(TreeViewer viewer) {
        IWorkbenchPart part = this.getSite().getPage().getActivePart();
        if (part == null) {
            return new CContentOutlinerProvider(viewer);
        }
        return new CContentOutlinerProvider(viewer, part.getSite());
    }

    protected ProblemTreeViewer createTreeViewer(Composite parent) {
        OutlineTreeViewer treeViewer = new OutlineTreeViewer(parent, 770);
        treeViewer.setContentProvider((IContentProvider)this.createContentProvider(treeViewer));
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingCLabelProvider(this.createLabelProvider(), true));
        treeViewer.setAutoExpandLevel(3);
        treeViewer.setUseHashlookup(true);
        treeViewer.addSelectionChangedListener(this);
        return treeViewer;
    }

    private CUILabelProvider createLabelProvider() {
        return new COutlineLabelProvider(1073742345L, 1);
    }

    public void createControl(Composite parent) {
        this.fTreeViewer = this.createTreeViewer(parent);
        this.initDragAndDrop();
        MenuManager manager = new MenuManager(this.fContextMenuId);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractCModelOutlinePage.this.contextMenuAboutToShow(manager);
            }
        });
        Control control = this.fTreeViewer.getControl();
        this.fMenu = manager.createContextMenu(control);
        control.setMenu(this.fMenu);
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (AbstractCModelOutlinePage.this.fOpenIncludeAction != null) {
                    AbstractCModelOutlinePage.this.fOpenIncludeAction.run();
                }
            }
        });
        IPageSite site = this.getSite();
        site.registerContextMenu(this.fContextMenuId, manager, (ISelectionProvider)this.fTreeViewer);
        site.setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        IActionBars bars = site.getActionBars();
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
        this.fSelectionSearchGroup = this.createSearchActionGroup();
        this.fOpenViewActionGroup = this.createOpenViewActionGroup();
        this.fSourceActionGroup = this.createSourceActionGroup();
        this.fRefactoringActionGroup = this.createRefactoringActionGroup();
        this.fCustomFiltersActionGroup = this.createCustomFiltersActionGroup();
        this.registerActionBars(bars);
        bars.updateActionBars();
        this.fTreeViewer.setInput(this.fInput);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.cdt.ui.outline_view");
        IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new ActionHandler((IAction)this.fCollapseAllAction));
    }

    public void dispose() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.removeSelectionChangedListener(this);
            this.fTreeViewer = null;
        }
        if (this.fTogglePresentation != null) {
            this.fTogglePresentation.setEditor(null);
            this.fTogglePresentation = null;
        }
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        if (this.fOpenViewActionGroup != null) {
            this.fOpenViewActionGroup.dispose();
            this.fOpenViewActionGroup = null;
        }
        if (this.fRefactoringActionGroup != null) {
            this.fRefactoringActionGroup.dispose();
            this.fRefactoringActionGroup = null;
        }
        if (this.fSelectionSearchGroup != null) {
            this.fSelectionSearchGroup.dispose();
            this.fSelectionSearchGroup = null;
        }
        if (this.fCustomFiltersActionGroup != null) {
            this.fCustomFiltersActionGroup.dispose();
            this.fCustomFiltersActionGroup = null;
        }
        if (this.fSelectionChangedListeners != null) {
            this.fSelectionChangedListeners.clear();
        }
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        this.fInput = null;
        super.dispose();
    }

    protected void registerActionBars(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        this.fCollapseAllAction = new CollapseAllAction(this.fTreeViewer);
        toolBarManager.add((IAction)this.fCollapseAllAction);
        LexicalSortingAction action = new LexicalSortingAction(this.getTreeViewer());
        toolBarManager.add((IAction)action);
        this.fMemberFilterActionGroup = this.createMemberFilterActionGroup();
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.fillActionBars(actionBars);
        }
        if (this.fCustomFiltersActionGroup != null) {
            this.fCustomFiltersActionGroup.fillActionBars(actionBars);
        }
        if (this.fOpenViewActionGroup != null) {
            this.fOpenViewActionGroup.fillActionBars(actionBars);
        }
        if (this.fRefactoringActionGroup != null) {
            this.fRefactoringActionGroup.fillActionBars(actionBars);
        }
        if (this.fSelectionSearchGroup != null) {
            this.fSelectionSearchGroup.fillActionBars(actionBars);
        }
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IContributionItem)new Separator("EndFilterGroup"));
        this.fToggleLinkingAction = new ToggleLinkingAction();
        menu.add((IAction)this.fToggleLinkingAction);
        menu.add((IContributionItem)new Separator("group.layout"));
        menu.add((IAction)new IncludeGroupingAction(this));
        menu.add((IAction)new MacroGroupingAction(this));
    }

    protected ActionGroup createSearchActionGroup() {
        return null;
    }

    protected ActionGroup createOpenViewActionGroup() {
        return null;
    }

    protected ActionGroup createRefactoringActionGroup() {
        return null;
    }

    protected ActionGroup createSourceActionGroup() {
        return null;
    }

    protected ActionGroup createCustomFiltersActionGroup() {
        return null;
    }

    protected ActionGroup createMemberFilterActionGroup() {
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
    }

    protected void fireSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
            ++i;
        }
        if (this.fRefactoringActionGroup != null) {
            this.fRefactoringActionGroup.setContext(new ActionContext(selection));
            this.fRefactoringActionGroup.updateActionBars();
        }
        if (this.fSourceActionGroup != null) {
            this.fSourceActionGroup.setContext(new ActionContext(selection));
            this.fSourceActionGroup.updateActionBars();
        }
    }

    public Control getControl() {
        if (this.fTreeViewer == null) {
            return null;
        }
        return this.fTreeViewer.getControl();
    }

    public ISelection getSelection() {
        if (this.fTreeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fTreeViewer.getSelection();
    }

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    public void setFocus() {
        this.fTreeViewer.getControl().setFocus();
    }

    public void setSelection(ISelection selection) {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setSelection(selection);
        }
    }

    public void setInput(ITranslationUnit unit) {
        this.fInput = unit;
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setInput(this.fInput);
        }
    }

    private void initDragAndDrop() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        TransferDropTargetListener[] dropListeners = new TransferDropTargetListener[]{new SelectionTransferDropAdapter((StructuredViewer)this.fTreeViewer)};
        this.fTreeViewer.addDropSupport(ops | 0x10, transfers, new DelegatingDropAdapter(dropListeners));
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)this.fTreeViewer)};
        this.fTreeViewer.addDragSupport(ops, transfers, new CDTViewerDragAdapter((StructuredViewer)this.fTreeViewer, dragListeners));
    }

    public static class COutlineLabelProvider
    extends AppearanceAwareLabelProvider {
        private boolean fSimpleName;

        public COutlineLabelProvider(long textFlags, int imageFlags) {
            super(textFlags, imageFlags);
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            this.fSimpleName = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.outline.groupmembers");
        }

        @Override
        public void dispose() {
            PreferenceConstants.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            super.dispose();
        }

        @Override
        protected long evaluateTextFlags(Object element) {
            if (this.fSimpleName) {
                return super.evaluateTextFlags(element) | 2L | 0x100L;
            }
            return super.evaluateTextFlags(element);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.cdt.ui.outline.groupmembers".equals(event.getProperty())) {
                Object newValue = event.getNewValue();
                this.fSimpleName = newValue instanceof Boolean ? ((Boolean)newValue).booleanValue() : PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.outline.groupmembers");
            }
        }
    }

    protected static class IncludeGroupingAction
    extends Action {
        AbstractCModelOutlinePage fOutLinePage;

        public IncludeGroupingAction(AbstractCModelOutlinePage outlinePage) {
            super(ActionMessages.IncludesGroupingAction_label);
            this.setDescription(ActionMessages.IncludesGroupingAction_description);
            this.setToolTipText(ActionMessages.IncludesGroupingAction_tooltip);
            CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.group_include.gif");
            boolean enabled = this.isIncludesGroupingEnabled();
            this.setChecked(enabled);
            this.fOutLinePage = outlinePage;
        }

        public void run() {
            PreferenceConstants.getPreferenceStore().setValue("org.eclipse.cdt.ui.outline.groupincludes", this.isChecked());
        }

        public boolean isIncludesGroupingEnabled() {
            return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.outline.groupincludes");
        }
    }

    protected static class MacroGroupingAction
    extends Action {
        public MacroGroupingAction(AbstractCModelOutlinePage outlinePage) {
            super(ActionMessages.MacroGroupingAction_label);
            this.setDescription(ActionMessages.MacroGroupingAction_description);
            this.setToolTipText(ActionMessages.MacroGroupingAction_tooltip);
            CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.filterDefines.gif");
            this.setImageDescriptor(CDTSharedImages.getImageDescriptor("icons/obj16/define_obj.gif"));
            this.setDisabledImageDescriptor(CDTSharedImages.getImageDescriptor("icons/obj16/define_obj.gif"));
            boolean enabled = this.isMacroGroupingEnabled();
            this.setChecked(enabled);
        }

        public void run() {
            PreferenceConstants.getPreferenceStore().setValue("org.eclipse.cdt.ui.outline.groupmacros", this.isChecked());
        }

        public boolean isMacroGroupingEnabled() {
            return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.outline.groupmacros");
        }
    }

    private static class OutlineTreeViewer
    extends ProblemTreeViewer {
        public OutlineTreeViewer(Composite parent, int flags) {
            super(parent, flags);
        }

        protected void internalExpandToLevel(Widget node, int level) {
            if (node instanceof Item) {
                Item i = (Item)node;
                Object data = i.getData();
                if (data instanceof IncludesGrouping) {
                    return;
                }
                if (data instanceof ICElement && !this.shouldExpandElement((ICElement)data)) {
                    return;
                }
            }
            super.internalExpandToLevel(node, level);
        }

        private boolean shouldExpandElement(ICElement cElement) {
            ICElement parent = cElement.getParent();
            if (parent == null) {
                return false;
            }
            int elementType = cElement.getElementType();
            int parentType = parent.getElementType();
            switch (elementType) {
                case 65: 
                case 83: {
                    return parentType == 60 || parentType == 61;
                }
                case 61: {
                    return parentType == 60;
                }
            }
            return false;
        }
    }

    public class ToggleLinkingAction
    extends AbstractToggleLinkingAction {
        public ToggleLinkingAction() {
            this.setChecked(AbstractCModelOutlinePage.this.isLinkingEnabled());
        }

        @Override
        public void run() {
            boolean checked = this.isChecked();
            PreferenceConstants.getPreferenceStore().setValue("org.eclipse.cdt.ui.outline.linktoeditor", checked);
            if (checked && AbstractCModelOutlinePage.this.fEditor != null) {
                AbstractCModelOutlinePage.this.synchronizeSelectionWithEditor();
            }
        }
    }
}

