/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.resources.ResourcesUtil;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleDocument;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartition;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleStreamDecorator;
import org.eclipse.cdt.internal.ui.buildconsole.BuildOutputStream;
import org.eclipse.cdt.internal.ui.buildconsole.DocumentMarkerManager;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;

public class BuildConsolePartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IConsole,
IPropertyChangeListener {
    private IProject fProject;
    private int openStreamCount = 0;
    List<ITypedRegion> fPartitions = new ArrayList<ITypedRegion>(5);
    private int fMaxLines;
    BuildConsoleStreamDecorator fLastStream;
    BuildConsoleDocument fDocument;
    DocumentMarkerManager fDocumentMarkerManager;
    boolean killed;
    BuildConsoleManager fManager;
    private final Deque<StreamEntry> fQueue = new SynchronizedDeque<StreamEntry>(new ArrayDeque());
    private URI fLogURI;
    private OutputStream fLogStream;

    public BuildConsolePartitioner(BuildConsoleManager manager) {
        this(null, manager);
    }

    public BuildConsolePartitioner(IProject project, BuildConsoleManager manager) {
        this.fProject = project;
        this.fManager = manager;
        this.fMaxLines = BuildConsolePreferencePage.buildConsoleLines();
        this.fDocument = new BuildConsoleDocument();
        this.fDocument.setDocumentPartitioner(this);
        this.fDocumentMarkerManager = new DocumentMarkerManager(this.fDocument, this);
        this.connect((IDocument)this.fDocument);
        this.fLogURI = null;
        this.fLogStream = null;
    }

    public void setStreamOpened() {
        this.fQueue.add(new StreamEntry(1));
        this.asyncProcessQueue();
    }

    public void setStreamAppend() {
        this.fQueue.add(new StreamEntry(3));
        this.asyncProcessQueue();
    }

    public void setStreamClosed() {
        this.fQueue.add(new StreamEntry(2));
        this.asyncProcessQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToDocument(String text, BuildConsoleStreamDecorator stream, ProblemMarkerInfo marker) {
        boolean addToQueue = true;
        Deque<StreamEntry> deque = this.fQueue;
        synchronized (deque) {
            StreamEntry entry = this.fQueue.peekLast();
            if (entry != null && entry.getStream() == stream && entry.getEventType() == 0 && entry.getMarker() == marker && entry.size() < 2000 * this.fQueue.size()) {
                entry.appendText(text);
                addToQueue = false;
            }
            if (addToQueue) {
                this.fQueue.add(new StreamEntry(text, stream, marker));
            }
        }
        if (addToQueue) {
            this.asyncProcessQueue();
        }
    }

    private void asyncProcessQueue() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                StreamEntry entry = (StreamEntry)BuildConsolePartitioner.this.fQueue.pollFirst();
                if (entry == null) {
                    return;
                }
                switch (entry.getEventType()) {
                    case 1: {
                        BuildConsolePartitioner buildConsolePartitioner = BuildConsolePartitioner.this;
                        buildConsolePartitioner.openStreamCount = buildConsolePartitioner.openStreamCount + 1;
                    }
                    case 3: {
                        this.logOpen(entry.getEventType() == 3);
                        break;
                    }
                    case 0: {
                        BuildConsolePartitioner.this.fLastStream = entry.getStream();
                        try {
                            String text;
                            BuildConsolePartitioner.this.warnOfContentChange(BuildConsolePartitioner.this.fLastStream);
                            if (BuildConsolePartitioner.this.fLastStream == null) {
                                BuildConsolePartitioner.this.fPartitions.clear();
                                BuildConsolePartitioner.this.fDocumentMarkerManager.clear();
                                BuildConsolePartitioner.this.fDocument.set("");
                            }
                            if ((text = entry.getText()).length() <= 0) break;
                            BuildConsolePartitioner.this.addStreamEntryToDocument(entry);
                            this.log(text);
                            boolean allowSlack = false;
                            entry = (StreamEntry)BuildConsolePartitioner.this.fQueue.peekFirst();
                            if (entry != null && entry.getEventType() == 0) {
                                allowSlack = true;
                            }
                            BuildConsolePartitioner.this.checkOverflow(allowSlack);
                        }
                        catch (BadLocationException badLocationException) {}
                        break;
                    }
                    case 2: {
                        BuildConsolePartitioner buildConsolePartitioner = BuildConsolePartitioner.this;
                        buildConsolePartitioner.openStreamCount = buildConsolePartitioner.openStreamCount - 1;
                        if (BuildConsolePartitioner.this.openStreamCount > 0) break;
                        BuildConsolePartitioner.this.openStreamCount = 0;
                        this.logClose();
                    }
                }
            }

            private void logOpen(boolean append) {
                BuildConsolePartitioner.this.fLogURI = BuildConsolePartitioner.this.fManager.getLogURI(BuildConsolePartitioner.this.fProject);
                if (BuildConsolePartitioner.this.fLogURI != null) {
                    try {
                        try {
                            IFileStore logStore = EFS.getStore((URI)BuildConsolePartitioner.this.fLogURI);
                            IFileStore dir = logStore.getParent();
                            if (dir != null) {
                                dir.mkdir(0, null);
                            }
                            int opts = append ? 1 : 0;
                            BuildConsolePartitioner.this.fLogStream = logStore.openOutputStream(opts, null);
                        }
                        catch (CoreException e) {
                            CUIPlugin.log(e);
                            ResourcesUtil.refreshWorkspaceFiles((URI)BuildConsolePartitioner.this.fLogURI);
                        }
                    }
                    finally {
                        ResourcesUtil.refreshWorkspaceFiles((URI)BuildConsolePartitioner.this.fLogURI);
                    }
                }
            }

            private void log(String text) {
                if (BuildConsolePartitioner.this.fLogStream != null) {
                    try {
                        try {
                            BuildConsolePartitioner.this.fLogStream.write(text.getBytes());
                            if (BuildConsolePartitioner.this.fQueue.isEmpty()) {
                                BuildConsolePartitioner.this.fLogStream.flush();
                            }
                        }
                        catch (IOException e) {
                            CUIPlugin.log(e);
                            ResourcesUtil.refreshWorkspaceFiles((URI)BuildConsolePartitioner.this.fLogURI);
                        }
                    }
                    finally {
                        ResourcesUtil.refreshWorkspaceFiles((URI)BuildConsolePartitioner.this.fLogURI);
                    }
                }
            }

            private void logClose() {
                if (BuildConsolePartitioner.this.fLogStream != null) {
                    block6: {
                        try {
                            try {
                                BuildConsolePartitioner.this.fLogStream.close();
                            }
                            catch (IOException e) {
                                CUIPlugin.log(e);
                                ResourcesUtil.refreshWorkspaceFiles((URI)BuildConsolePartitioner.this.fLogURI);
                                break block6;
                            }
                        }
                        catch (Throwable throwable) {
                            ResourcesUtil.refreshWorkspaceFiles((URI)BuildConsolePartitioner.this.fLogURI);
                            throw throwable;
                        }
                        ResourcesUtil.refreshWorkspaceFiles((URI)BuildConsolePartitioner.this.fLogURI);
                    }
                    BuildConsolePartitioner.this.fLogStream = null;
                }
            }
        };
        Display display = CUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(r);
        }
    }

    private void addStreamEntryToDocument(StreamEntry entry) throws BadLocationException {
        ProblemMarkerInfo marker = entry.getMarker();
        if (marker == null) {
            this.addPartition(new BuildConsolePartition(this.fLastStream, this.fDocument.getLength(), entry.getText().length(), BuildConsolePartition.CONSOLE_PARTITION_TYPE));
        } else {
            String errorPartitionType = marker.severity == 0 ? BuildConsolePartition.INFO_PARTITION_TYPE : (marker.severity == 1 ? BuildConsolePartition.WARNING_PARTITION_TYPE : BuildConsolePartition.ERROR_PARTITION_TYPE);
            this.addPartition(new BuildConsolePartition(this.fLastStream, this.fDocument.getLength(), entry.getText().length(), errorPartitionType, marker));
        }
        this.fDocument.replace(this.fDocument.getLength(), 0, entry.getText());
    }

    void warnOfContentChange(BuildConsoleStreamDecorator stream) {
        if (stream != null) {
            ConsolePlugin.getDefault().getConsoleManager().warnOfContentChange((org.eclipse.ui.console.IConsole)stream.getConsole());
        }
        this.fManager.showConsole();
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setDocumentSize(int nLines) {
        this.fMaxLines = nLines;
        this.checkOverflow(false);
    }

    public void connect(IDocument document) {
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void disconnect() {
        this.fDocument.setDocumentPartitioner(null);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.killed = true;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{BuildConsolePartition.CONSOLE_PARTITION_TYPE};
    }

    public String getContentType(int offset) {
        ITypedRegion partition = this.getPartition(offset);
        if (partition != null) {
            return partition.getType();
        }
        return null;
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        if (offset == 0 && length == this.fDocument.getLength()) {
            return this.fPartitions.toArray(new ITypedRegion[this.fPartitions.size()]);
        }
        int end = offset + length;
        ArrayList<ITypedRegion> list = new ArrayList<ITypedRegion>();
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = this.fPartitions.get(i);
            int partitionStart = partition.getOffset();
            int partitionEnd = partitionStart + partition.getLength();
            if (offset >= partitionStart && offset <= partitionEnd || offset < partitionStart && end >= partitionStart) {
                list.add(partition);
            }
            ++i;
        }
        return list.toArray(new ITypedRegion[list.size()]);
    }

    public ITypedRegion getPartition(int offset) {
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = this.fPartitions.get(i);
            int start = partition.getOffset();
            int end = start + partition.getLength();
            if (offset >= start && offset < end) {
                return partition;
            }
            ++i;
        }
        return null;
    }

    public IRegion documentChanged2(DocumentEvent event) {
        String text = event.getText();
        if (this.getDocument().getLength() == 0) {
            this.fPartitions.clear();
            return new Region(0, 0);
        }
        ITypedRegion[] affectedRegions = this.computePartitioning(event.getOffset(), text.length());
        if (affectedRegions.length == 0) {
            return null;
        }
        if (affectedRegions.length == 1) {
            return affectedRegions[0];
        }
        int affectedLength = affectedRegions[0].getLength();
        int i = 1;
        while (i < affectedRegions.length) {
            ITypedRegion region = affectedRegions[i];
            affectedLength += region.getLength();
            ++i;
        }
        return new Region(affectedRegions[0].getOffset(), affectedLength);
    }

    protected void checkOverflow(boolean allowSlack) {
        if (this.fMaxLines <= 0) {
            return;
        }
        int nLines = this.fDocument.getNumberOfLines();
        if (nLines <= (allowSlack ? this.fMaxLines * 2 : this.fMaxLines) + 1) {
            return;
        }
        int overflow = 0;
        try {
            overflow = this.fDocument.getLineOffset(nLines - this.fMaxLines);
        }
        catch (BadLocationException badLocationException) {}
        ArrayList<ITypedRegion> newParitions = new ArrayList<ITypedRegion>(this.fPartitions.size());
        for (ITypedRegion region : this.fPartitions) {
            if (!(region instanceof BuildConsolePartition)) continue;
            BuildConsolePartition messageConsolePartition = (BuildConsolePartition)region;
            BuildConsolePartition newPartition = null;
            int offset = region.getOffset();
            String type = messageConsolePartition.getType();
            if (offset < overflow) {
                int endOffset = offset + region.getLength();
                if (endOffset >= overflow && !BuildConsolePartition.isProblemPartitionType(type)) {
                    int length = endOffset - overflow;
                    newPartition = messageConsolePartition.createNewPartition(0, length, type);
                }
            } else {
                offset = messageConsolePartition.getOffset() - overflow;
                newPartition = messageConsolePartition.createNewPartition(offset, messageConsolePartition.getLength(), type);
            }
            if (newPartition == null) continue;
            newParitions.add((ITypedRegion)newPartition);
        }
        this.fPartitions = newParitions;
        this.fDocumentMarkerManager.moveToFirstError();
        try {
            this.fDocument.replace(0, overflow, "");
        }
        catch (BadLocationException badLocationException) {}
    }

    private BuildConsolePartition addPartition(BuildConsolePartition partition) {
        if (this.fPartitions.isEmpty()) {
            this.fPartitions.add((ITypedRegion)partition);
        } else {
            int index = this.fPartitions.size() - 1;
            BuildConsolePartition last = (BuildConsolePartition)this.fPartitions.get(index);
            if (last.canBeCombinedWith(partition)) {
                partition = last.combineWith(partition);
                this.fPartitions.set(index, (ITypedRegion)partition);
            } else {
                this.fPartitions.add((ITypedRegion)partition);
            }
        }
        return partition;
    }

    public IConsole getConsole() {
        return this;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "buildConsoleLines") {
            this.setDocumentSize(BuildConsolePreferencePage.buildConsoleLines());
        }
    }

    public void start(final IProject project) {
        Display display = CUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    BuildConsolePartitioner.this.fLogStream = null;
                    BuildConsolePartitioner.this.fLogURI = null;
                    BuildConsolePartitioner.this.fManager.startConsoleActivity(project);
                }
            });
        }
        if (BuildConsolePreferencePage.isClearBuildConsole()) {
            this.appendToDocument("", null, null);
        }
    }

    public ConsoleOutputStream getOutputStream() throws CoreException {
        return new BuildOutputStream(this, this.fManager.getStreamDecorator(1));
    }

    public ConsoleOutputStream getInfoStream() throws CoreException {
        return new BuildOutputStream(this, this.fManager.getStreamDecorator(0));
    }

    public ConsoleOutputStream getErrorStream() throws CoreException {
        return new BuildOutputStream(this, this.fManager.getStreamDecorator(2));
    }

    private void printDocumentPartitioning() {
        System.out.println("Document partitioning: ");
        for (ITypedRegion tr : this.fPartitions) {
            String text;
            BuildConsolePartition p = (BuildConsolePartition)tr;
            int start = p.getOffset();
            int end = p.getOffset() + p.getLength();
            String isError = "U";
            String type = p.getType();
            if (type == BuildConsolePartition.ERROR_PARTITION_TYPE) {
                isError = "E";
            } else if (type == BuildConsolePartition.WARNING_PARTITION_TYPE) {
                isError = "W";
            } else if (type == BuildConsolePartition.INFO_PARTITION_TYPE) {
                isError = "I";
            } else if (type == BuildConsolePartition.CONSOLE_PARTITION_TYPE) {
                isError = "C";
            }
            try {
                text = this.fDocument.get(p.getOffset(), p.getLength());
            }
            catch (BadLocationException badLocationException) {
                text = "N/A";
            }
            if (text.endsWith("\n")) {
                text = text.substring(0, text.length() - 1);
            }
            System.out.println("    " + isError + " " + start + "-" + end + ":[" + text + "]");
        }
    }

    public URI getLogURI() {
        return this.fLogURI;
    }

    IProject getProject() {
        return this.fProject;
    }

    private class StreamEntry {
        public static final int EVENT_APPEND = 0;
        public static final int EVENT_OPEN_LOG = 1;
        public static final int EVENT_CLOSE_LOG = 2;
        public static final int EVENT_OPEN_APPEND_LOG = 3;
        private BuildConsoleStreamDecorator fStream;
        private StringBuilder fText = null;
        private ProblemMarkerInfo fMarker;
        private int eventType;

        public StreamEntry(String text, BuildConsoleStreamDecorator stream, ProblemMarkerInfo marker) {
            this.fText = new StringBuilder(text);
            this.fStream = stream;
            this.fMarker = marker;
            this.eventType = 0;
        }

        public StreamEntry(int event) {
            this.fText = null;
            this.fStream = null;
            this.fMarker = null;
            this.eventType = event;
        }

        public BuildConsoleStreamDecorator getStream() {
            return this.fStream;
        }

        public void appendText(String text) {
            this.fText.append(text);
        }

        public int size() {
            return this.fText.length();
        }

        public String getText() {
            return this.fText.toString();
        }

        public ProblemMarkerInfo getMarker() {
            return this.fMarker;
        }

        public int getEventType() {
            return this.eventType;
        }
    }

    private static class SynchronizedDeque<E>
    implements Deque<E> {
        private final Deque<E> deque;

        public SynchronizedDeque(Deque<E> deque) {
            this.deque = deque;
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.deque.isEmpty();
        }

        @Override
        public synchronized void addFirst(E e) {
            this.deque.addFirst(e);
        }

        @Override
        public synchronized void addLast(E e) {
            this.deque.addLast(e);
        }

        @Override
        public synchronized Object[] toArray() {
            return this.deque.toArray();
        }

        @Override
        public synchronized <T> T[] toArray(T[] a) {
            return this.deque.toArray(a);
        }

        @Override
        public synchronized boolean offerFirst(E e) {
            return this.deque.offerFirst(e);
        }

        @Override
        public synchronized boolean offerLast(E e) {
            return this.deque.offerLast(e);
        }

        @Override
        public synchronized E removeFirst() {
            return this.deque.removeFirst();
        }

        @Override
        public synchronized E removeLast() {
            return this.deque.removeLast();
        }

        @Override
        public synchronized E pollFirst() {
            return this.deque.pollFirst();
        }

        @Override
        public synchronized E pollLast() {
            return this.deque.pollLast();
        }

        @Override
        public synchronized E getFirst() {
            return this.deque.getFirst();
        }

        @Override
        public synchronized E getLast() {
            return this.deque.getLast();
        }

        @Override
        public synchronized E peekFirst() {
            return this.deque.peekFirst();
        }

        @Override
        public synchronized E peekLast() {
            return this.deque.peekLast();
        }

        @Override
        public synchronized boolean removeFirstOccurrence(Object o) {
            return this.deque.removeFirstOccurrence(o);
        }

        @Override
        public synchronized boolean containsAll(Collection<?> c) {
            return this.deque.containsAll(c);
        }

        @Override
        public synchronized boolean removeLastOccurrence(Object o) {
            return this.deque.removeLastOccurrence(o);
        }

        @Override
        public synchronized boolean addAll(Collection<? extends E> c) {
            return this.deque.addAll(c);
        }

        @Override
        public synchronized boolean add(E e) {
            return this.deque.add(e);
        }

        @Override
        public synchronized boolean removeAll(Collection<?> c) {
            return this.deque.removeAll(c);
        }

        @Override
        public synchronized boolean offer(E e) {
            return this.deque.offer(e);
        }

        @Override
        public synchronized boolean retainAll(Collection<?> c) {
            return this.deque.retainAll(c);
        }

        @Override
        public synchronized E remove() {
            return this.deque.remove();
        }

        @Override
        public synchronized E poll() {
            return this.deque.poll();
        }

        @Override
        public synchronized E element() {
            return this.deque.element();
        }

        @Override
        public synchronized void clear() {
            this.deque.clear();
        }

        @Override
        public synchronized boolean equals(Object o) {
            return this.deque.equals(o);
        }

        @Override
        public synchronized E peek() {
            return this.deque.peek();
        }

        @Override
        public synchronized void push(E e) {
            this.deque.push(e);
        }

        @Override
        public synchronized E pop() {
            return this.deque.pop();
        }

        @Override
        public synchronized int hashCode() {
            return this.deque.hashCode();
        }

        @Override
        public synchronized boolean remove(Object o) {
            return this.deque.remove(o);
        }

        @Override
        public synchronized boolean contains(Object o) {
            return this.deque.contains(o);
        }

        @Override
        public synchronized int size() {
            return this.deque.size();
        }

        @Override
        public synchronized Iterator<E> iterator() {
            return this.deque.iterator();
        }

        @Override
        public synchronized Iterator<E> descendingIterator() {
            return this.deque.descendingIterator();
        }
    }
}

