/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.util;

import org.eclipse.cdt.core.formatter.IndentManipulation;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.TextProcessor;

public class Strings {
    public static final boolean USE_TEXT_PROCESSOR;
    private static final String C_ELEMENT_DELIMITERS;

    static {
        String testString = "args : String[]";
        USE_TEXT_PROCESSOR = testString != TextProcessor.process((String)testString);
        C_ELEMENT_DELIMITERS = String.valueOf(TextProcessor.getDefaultDelimiters()) + "<>(),?{} ";
    }

    private Strings() {
    }

    public static boolean startsWithIgnoreCase(CharSequence text, CharSequence prefix) {
        int prefixLength;
        int textLength = text.length();
        if (textLength < (prefixLength = prefix.length())) {
            return false;
        }
        int i = prefixLength - 1;
        while (i >= 0) {
            if (Character.toLowerCase(prefix.charAt(i)) != Character.toLowerCase(text.charAt(i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean endsWith(CharSequence containing, CharSequence contained) {
        int start = containing.length() - contained.length();
        if (start < 0) {
            return false;
        }
        int i = start;
        int j = 0;
        while (i < containing.length()) {
            if (containing.charAt(i) != contained.charAt(j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static String removeNewLine(String message) {
        StringBuilder result = new StringBuilder();
        int current = 0;
        int index = message.indexOf(10, 0);
        while (index != -1) {
            result.append(message.substring(current, index));
            if (current < index && index != 0) {
                result.append(' ');
            }
            current = index + 1;
            index = message.indexOf(10, current);
        }
        result.append(message.substring(current));
        return result.toString();
    }

    public static String[] convertIntoLines(String input) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(input);
            int size = tracker.getNumberOfLines();
            String[] result = new String[size];
            int i = 0;
            while (i < size) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                result[i] = input.substring(offset, offset + region.getLength());
                ++i;
            }
            return result;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static boolean containsOnlyWhitespaces(String s) {
        int size = s.length();
        int i = 0;
        while (i < size) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String trimLeadingTabsAndSpaces(String line) {
        int size;
        int start = size = line.length();
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (!IndentManipulation.isIndentChar((char)c)) {
                start = i;
                break;
            }
            ++i;
        }
        if (start == 0) {
            return line;
        }
        if (start == size) {
            return "";
        }
        return line.substring(start);
    }

    public static String trimTrailingTabsAndSpaces(String line) {
        int size;
        int end = size = line.length();
        int i = size - 1;
        while (i >= 0) {
            char c = line.charAt(i);
            if (!IndentManipulation.isIndentChar((char)c)) break;
            end = i--;
        }
        if (end == size) {
            return line;
        }
        if (end == 0) {
            return "";
        }
        return line.substring(0, end);
    }

    public static int computeIndentUnits(String line, ICProject project) {
        return IndentManipulation.measureIndentUnits((CharSequence)line, (int)CodeFormatterUtil.getTabWidth(project), (int)CodeFormatterUtil.getIndentWidth(project));
    }

    public static int computeIndentUnits(String line, int tabWidth, int indentWidth) {
        return IndentManipulation.measureIndentUnits((CharSequence)line, (int)tabWidth, (int)indentWidth);
    }

    public static int measureIndentLength(CharSequence line, int tabSize) {
        return IndentManipulation.measureIndentInSpaces((CharSequence)line, (int)tabSize);
    }

    public static String trimIndent(String line, int indentsToRemove, ICProject project) {
        return IndentManipulation.trimIndent((String)line, (int)indentsToRemove, (int)CodeFormatterUtil.getTabWidth(project), (int)CodeFormatterUtil.getIndentWidth(project));
    }

    public static String trimIndent(String line, int indentsToRemove, int tabWidth, int indentWidth) {
        return IndentManipulation.trimIndent((String)line, (int)indentsToRemove, (int)tabWidth, (int)indentWidth);
    }

    public static void trimIndentation(String[] lines, ICProject project) {
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project), true);
    }

    public static void trimIndentation(String[] lines, int tabWidth, int indentWidth) {
        Strings.trimIndentation(lines, tabWidth, indentWidth, true);
    }

    public static void trimIndentation(String[] lines, ICProject project, boolean considerFirstLine) {
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project), considerFirstLine);
    }

    public static void trimIndentation(String[] lines, int tabWidth, int indentWidth, boolean considerFirstLine) {
        String[] toDo = new String[lines.length];
        int minIndent = Integer.MAX_VALUE;
        int i = considerFirstLine ? 0 : 1;
        while (i < lines.length) {
            String line = lines[i];
            if (!Strings.containsOnlyWhitespaces(line)) {
                toDo[i] = line;
                int indent = Strings.computeIndentUnits(line, tabWidth, indentWidth);
                if (indent < minIndent) {
                    minIndent = indent;
                }
            }
            ++i;
        }
        if (minIndent > 0) {
            i = considerFirstLine ? 0 : 1;
            while (i < toDo.length) {
                String line;
                int indent;
                String s = toDo[i];
                lines[i] = s != null ? Strings.trimIndent(s, minIndent, tabWidth, indentWidth) : ((indent = Strings.computeIndentUnits(line = lines[i], tabWidth, indentWidth)) > minIndent ? Strings.trimIndent(line, minIndent, tabWidth, indentWidth) : Strings.trimLeadingTabsAndSpaces(line));
                ++i;
            }
        }
    }

    public static String getIndentString(String line, ICProject project) {
        return IndentManipulation.extractIndentString((String)line, (int)CodeFormatterUtil.getTabWidth(project), (int)CodeFormatterUtil.getIndentWidth(project));
    }

    public static String getIndentString(String line, int tabWidth, int indentWidth) {
        return IndentManipulation.extractIndentString((String)line, (int)tabWidth, (int)indentWidth);
    }

    public static String[] removeTrailingEmptyLines(String[] sourceLines) {
        int lastNonEmpty = Strings.findLastNonEmptyLineIndex(sourceLines);
        String[] result = new String[lastNonEmpty + 1];
        int i = 0;
        while (i < result.length) {
            result[i] = sourceLines[i];
            ++i;
        }
        return result;
    }

    private static int findLastNonEmptyLineIndex(String[] sourceLines) {
        int i = sourceLines.length - 1;
        while (i >= 0) {
            if (!sourceLines[i].trim().isEmpty()) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static String changeIndent(String code, int codeIndentLevel, ICProject project, String newIndent, String lineDelim) {
        return IndentManipulation.changeIndent((String)code, (int)codeIndentLevel, (int)CodeFormatterUtil.getTabWidth(project), (int)CodeFormatterUtil.getIndentWidth(project), (String)newIndent, (String)lineDelim);
    }

    public static String changeIndent(String code, int codeIndentLevel, int tabWidth, int indentWidth, String newIndent, String lineDelim) {
        return IndentManipulation.changeIndent((String)code, (int)codeIndentLevel, (int)tabWidth, (int)indentWidth, (String)newIndent, (String)lineDelim);
    }

    public static String trimIndentation(String source, ICProject project, boolean considerFirstLine) {
        return Strings.trimIndentation(source, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project), considerFirstLine);
    }

    public static String trimIndentation(String source, int tabWidth, int indentWidth, boolean considerFirstLine) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(source);
            int size = tracker.getNumberOfLines();
            if (size == 1) {
                return source;
            }
            String[] lines = new String[size];
            int i = 0;
            while (i < size) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                lines[i] = source.substring(offset, offset + region.getLength());
                ++i;
            }
            Strings.trimIndentation(lines, tabWidth, indentWidth, considerFirstLine);
            StringBuilder result = new StringBuilder();
            int last = size - 1;
            int i2 = 0;
            while (i2 < size) {
                result.append(lines[i2]);
                if (i2 < last) {
                    result.append(tracker.getLineDelimiter(i2));
                }
                ++i2;
            }
            return result.toString();
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false, (String)"Can not happend");
            return null;
        }
    }

    public static String concatenate(String[] lines, String delimiter) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                buffer.append(delimiter);
            }
            buffer.append(lines[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static boolean equals(String s, char[] c) {
        if (s.length() != c.length) {
            return false;
        }
        int i = c.length;
        while (--i >= 0) {
            if (s.charAt(i) == c[i]) continue;
            return false;
        }
        return true;
    }

    public static String removeTrailingCharacters(String text, char toRemove) {
        int size;
        int end = size = text.length();
        int i = size - 1;
        while (i >= 0) {
            char c = text.charAt(i);
            if (c != toRemove) break;
            end = i--;
        }
        if (end == size) {
            return text;
        }
        if (end == 0) {
            return "";
        }
        return text.substring(0, end);
    }

    public static String convertTabsToSpaces(String line, int tabWidth) {
        StringBuilder buf = null;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == '\t') {
                if (buf == null) {
                    buf = new StringBuilder(line.length() * tabWidth);
                    buf.append(line.subSequence(0, i));
                }
                int k = tabWidth - i % tabWidth;
                while (--k >= 0) {
                    buf.append(' ');
                }
            } else if (buf != null) {
                buf.append(c);
            }
            ++i;
        }
        return buf != null ? buf.toString() : line;
    }

    public static String removeMnemonicIndicator(String string) {
        return LegacyActionTools.removeMnemonics((String)string);
    }

    public static StyledString markLTR(StyledString styledString) {
        if (!USE_TEXT_PROCESSOR) {
            return styledString;
        }
        String inputString = styledString.getString();
        String string = TextProcessor.process((String)inputString);
        if (string != inputString) {
            Strings.insertMarks(styledString, inputString, string);
        }
        return styledString;
    }

    public static StyledString markLTR(StyledString styledString, String delimiters) {
        if (!USE_TEXT_PROCESSOR) {
            return styledString;
        }
        String inputString = styledString.getString();
        String string = TextProcessor.process((String)inputString, (String)delimiters);
        if (string != inputString) {
            Strings.insertMarks(styledString, inputString, string);
        }
        return styledString;
    }

    public static String markLTR(String string) {
        if (!USE_TEXT_PROCESSOR) {
            return string;
        }
        return TextProcessor.process((String)string);
    }

    public static String markLTR(String string, String delimiters) {
        if (!USE_TEXT_PROCESSOR) {
            return string;
        }
        return TextProcessor.process((String)string, (String)delimiters);
    }

    public static String markCElementLabelLTR(String string) {
        if (!USE_TEXT_PROCESSOR) {
            return string;
        }
        return TextProcessor.process((String)string, (String)C_ELEMENT_DELIMITERS);
    }

    public static StyledString markCElementLabelLTR(StyledString styledString) {
        if (!USE_TEXT_PROCESSOR) {
            return styledString;
        }
        String inputString = styledString.getString();
        String string = TextProcessor.process((String)inputString, (String)C_ELEMENT_DELIMITERS);
        if (string != inputString) {
            Strings.insertMarks(styledString, inputString, string);
        }
        return styledString;
    }

    private static void insertMarks(StyledString styledString, String originalString, String processedString) {
        int originalLength = originalString.length();
        int processedStringLength = processedString.length();
        char orig = originalLength > 0 ? originalString.charAt(0) : (char)'\u0000';
        int o = 0;
        int p = 0;
        while (p < processedStringLength) {
            char processed = processedString.charAt(p);
            if (o < originalLength && orig == processed) {
                if (++o < originalLength) {
                    orig = originalString.charAt(o);
                }
            } else {
                styledString.insert(processed, p);
            }
            ++p;
        }
    }
}

