/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template.c;

import java.util.Iterator;
import org.eclipse.cdt.internal.corext.template.c.FileTemplateContextType;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class FileTemplateContext
extends TemplateContext {
    private String fLineDelimiter;

    public FileTemplateContext(String contextTypeId, String lineDelimiter) {
        super(CUIPlugin.getDefault().getCodeTemplateContextRegistry().getContextType(contextTypeId));
        this.fLineDelimiter = lineDelimiter;
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        Iterator iterator = this.getContextType().resolvers();
        while (iterator.hasNext()) {
            TemplateVariableResolver var = (TemplateVariableResolver)iterator.next();
            if (var.getClass() != FileTemplateContextType.FileTemplateVariableResolver.class) continue;
            Assert.isNotNull((Object)this.getVariable(var.getType()), (String)("Variable " + var.getType() + " not defined"));
        }
        if (!this.canEvaluate(template)) {
            return null;
        }
        String pattern = FileTemplateContext.changeLineDelimiter(template.getPattern(), this.fLineDelimiter);
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(pattern);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    private static String changeLineDelimiter(String code, String lineDelim) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(code);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return code;
            }
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < nLines) {
                if (i != 0) {
                    buf.append(lineDelim);
                }
                IRegion region = tracker.getLineInformation(i);
                String line = code.substring(region.getOffset(), region.getOffset() + region.getLength());
                buf.append(line);
                ++i;
            }
            return buf.toString();
        }
        catch (BadLocationException badLocationException) {
            return code;
        }
    }

    public boolean canEvaluate(Template template) {
        return true;
    }

    public void setResourceVariables(IFile file) {
        this.setVariable("file_name", file.getName());
        this.setVariable("file_base", new Path(file.getName()).removeFileExtension().lastSegment());
        IPath location = file.getLocation();
        this.setVariable("file_loc", location != null ? location.toOSString() : "");
        this.setVariable("file_path", file.getFullPath().toString());
        this.setVariable("project_name", file.getProject().getName());
    }
}

