/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.codemanipulation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.dom.parser.AbstractCLikeLanguage;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.template.c.CodeTemplateContext;
import org.eclipse.cdt.internal.corext.template.c.FileTemplateContext;
import org.eclipse.cdt.internal.corext.template.c.FileTemplateContextType;
import org.eclipse.cdt.internal.corext.util.Strings;
import org.eclipse.cdt.internal.ui.text.CBreakIterator;
import org.eclipse.cdt.internal.ui.util.NameComposer;
import org.eclipse.cdt.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StubUtility {
    private static final String[] EMPTY = new String[0];

    private StubUtility() {
    }

    public static String getHeaderFileContent(ITranslationUnit tu, String declarations, String fileComment, String includes, String namespaceBegin, String namespaceEnd, String namespaceName, String typeComment, String typeName, String lineDelimiter) throws CoreException {
        return StubUtility.getHeaderFileContent(StubUtility.getDefaultFileTemplate(tu), tu, declarations, fileComment, includes, namespaceBegin, namespaceEnd, namespaceName, typeComment, typeName, lineDelimiter);
    }

    public static String getHeaderFileContent(Template template, ITranslationUnit tu, String declarations, String fileComment, String includes, String namespaceBegin, String namespaceEnd, String namespaceName, String typeComment, String typeName, String lineDelimiter) throws CoreException {
        if (template == null) {
            return null;
        }
        ICProject project = tu.getCProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setTranslationUnitVariables(tu);
        String includeGuardSymbol = StubUtility.generateIncludeGuardSymbol(tu.getResource(), project);
        context.setVariable("declarations", declarations != null ? declarations : "");
        context.setVariable("filecomment", fileComment != null ? fileComment : "");
        context.setVariable("include_guard_symbol", includeGuardSymbol != null ? includeGuardSymbol : "");
        context.setVariable("includes", includes != null ? includes : "");
        context.setVariable("namespace_begin", namespaceBegin != null ? namespaceBegin : "");
        context.setVariable("namespace_end", namespaceEnd != null ? namespaceEnd : "");
        context.setVariable("namespace_name", namespaceName != null ? namespaceName : "");
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("type_name", typeName != null ? typeName : "");
        String[] fullLine = new String[]{"declarations", "filecomment", "includes", "namespace_begin", "namespace_end", "typecomment"};
        String text = StubUtility.evaluateTemplate(context, template, fullLine);
        if (text != null && !text.endsWith(lineDelimiter)) {
            text = String.valueOf(text) + lineDelimiter;
        }
        return text;
    }

    public static String getBodyFileContent(ITranslationUnit tu, String declarations, String fileComment, String includes, String namespaceBegin, String namespaceEnd, String namespaceName, String typeComment, String typeName, String lineDelimiter) throws CoreException {
        return StubUtility.getBodyFileContent(StubUtility.getDefaultFileTemplate(tu), tu, declarations, fileComment, includes, namespaceBegin, namespaceEnd, namespaceName, typeComment, typeName, lineDelimiter);
    }

    public static String getBodyFileContent(Template template, ITranslationUnit tu, String declarations, String fileComment, String includes, String namespaceBegin, String namespaceEnd, String namespaceName, String typeComment, String typeName, String lineDelimiter) throws CoreException {
        if (template == null) {
            return null;
        }
        ICProject project = tu.getCProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setTranslationUnitVariables(tu);
        context.setVariable("declarations", declarations != null ? declarations : "");
        context.setVariable("filecomment", fileComment != null ? fileComment : "");
        context.setVariable("includes", includes != null ? includes : "");
        context.setVariable("namespace_begin", namespaceBegin != null ? namespaceBegin : "");
        context.setVariable("namespace_end", namespaceEnd != null ? namespaceEnd : "");
        context.setVariable("namespace_name", namespaceName != null ? namespaceName : "");
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("type_name", typeName != null ? typeName : "");
        String[] fullLine = new String[]{"declarations", "filecomment", "includes", "namespace_begin", "namespace_end", "typecomment"};
        String text = StubUtility.evaluateTemplate(context, template, fullLine);
        if (text != null && !text.endsWith(lineDelimiter)) {
            text = String.valueOf(text) + lineDelimiter;
        }
        return text;
    }

    public static String getTestFileContent(ITranslationUnit tu, String declarations, String fileComment, String includes, String namespaceBegin, String namespaceEnd, String namespaceName, String typeName, String lineDelimiter) throws CoreException {
        return StubUtility.getBodyFileContent(StubUtility.getTestFileTemplate(tu), tu, declarations, fileComment, includes, namespaceBegin, namespaceEnd, namespaceName, null, typeName, lineDelimiter);
    }

    public static String getFileContent(Template template, IFile file, String lineDelimiter) throws CoreException {
        ICProject cproject = null;
        IProject project = file.getProject();
        if (CoreModel.hasCNature((IProject)project)) {
            cproject = CoreModel.getDefault().create(project);
        }
        FileTemplateContext context = cproject != null ? new CodeTemplateContext(template.getContextTypeId(), cproject, lineDelimiter) : new FileTemplateContext(template.getContextTypeId(), lineDelimiter);
        String fileComment = StubUtility.getFileComment(file, lineDelimiter);
        context.setVariable("filecomment", fileComment != null ? fileComment : "");
        String includeGuardSymbol = StubUtility.generateIncludeGuardSymbol((IResource)file, cproject);
        context.setVariable("include_guard_symbol", includeGuardSymbol != null ? includeGuardSymbol : "");
        context.setResourceVariables(file);
        String[] fullLine = new String[]{"filecomment"};
        String text = StubUtility.evaluateTemplate(context, template, fullLine);
        if (text != null) {
            int offset;
            int len = text.length();
            while (text.startsWith(lineDelimiter, offset = len - lineDelimiter.length())) {
                len = offset;
            }
            if ((len += lineDelimiter.length()) < text.length()) {
                text = text.substring(0, len);
            } else if (!text.endsWith(lineDelimiter)) {
                text = String.valueOf(text) + lineDelimiter;
            }
        }
        return text;
    }

    public static String getClassBodyContent(ICProject project, String className, String classMemberDeclarations, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.cdt.ui.text.codetemplates.class_body", project);
        if (template == null) {
            return classMemberDeclarations;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_type", className);
        context.setVariable("declarations", classMemberDeclarations != null ? classMemberDeclarations : "");
        String str = StubUtility.evaluateTemplate(context, template, new String[]{"declarations"});
        if (str == null && classMemberDeclarations != null && !Strings.containsOnlyWhitespaces(classMemberDeclarations)) {
            return classMemberDeclarations;
        }
        return str;
    }

    public static String getMethodBodyContent(ICProject project, String typeName, String methodName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateId = "org.eclipse.cdt.ui.text.codetemplates.methodbody";
        return StubUtility.getMethodBodyContent(templateId, project, typeName, methodName, bodyStatement, lineDelimiter);
    }

    public static String getMethodBodyContent(String templateId, ICProject project, String typeName, String methodName, String bodyStatement, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate(templateId, project);
        if (template == null) {
            return bodyStatement;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("body_statement", bodyStatement != null ? bodyStatement : "");
        String str = StubUtility.evaluateTemplate(context, template, new String[]{"body_statement"});
        if (str == null && bodyStatement != null && !Strings.containsOnlyWhitespaces(bodyStatement)) {
            return bodyStatement;
        }
        return str;
    }

    public static String getConstructorBodyContent(ICProject project, String typeName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateId = "org.eclipse.cdt.ui.text.codetemplates.constructorbody";
        return StubUtility.getMethodBodyContent(templateId, project, typeName, typeName, bodyStatement, lineDelimiter);
    }

    public static String getDestructorBodyContent(ICProject project, String typeName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateId = "org.eclipse.cdt.ui.text.codetemplates.destructorbody";
        return StubUtility.getMethodBodyContent(templateId, project, typeName, "~" + typeName, bodyStatement, lineDelimiter);
    }

    public static String getNamespaceBeginContent(ICProject project, String namespaceName, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.cdt.ui.text.codetemplates.namespace_begin", project);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("namespace_name", namespaceName);
        return StubUtility.evaluateTemplate(context, template, EMPTY);
    }

    public static String getNamespaceEndContent(ICProject project, String namespaceName, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.cdt.ui.text.codetemplates.namespace_end", project);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("namespace_name", namespaceName);
        return StubUtility.evaluateTemplate(context, template, EMPTY);
    }

    public static String getFileComment(ITranslationUnit tu, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.cdt.ui.text.codetemplates.filecomment", tu.getCProject());
        if (template == null) {
            return null;
        }
        ICProject project = tu.getCProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setTranslationUnitVariables(tu);
        return StubUtility.evaluateTemplate(context, template);
    }

    private static String getFileComment(IFile file, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.cdt.ui.text.codetemplates.filecomment", file.getProject());
        if (template == null) {
            return null;
        }
        FileTemplateContext context = new FileTemplateContext(template.getContextTypeId(), lineDelimiter);
        context.setResourceVariables(file);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getClassComment(ITranslationUnit tu, String typeQualifiedName, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.cdt.ui.text.codetemplates.typecomment", tu.getCProject());
        if (template == null) {
            return null;
        }
        ICProject project = tu.getCProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setTranslationUnitVariables(tu);
        context.setVariable("type_name", typeQualifiedName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getMethodComment(ITranslationUnit tu, String typeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, String lineDelimiter) throws CoreException {
        String templateId = "org.eclipse.cdt.ui.text.codetemplates.methodcomment";
        return StubUtility.getMethodComment(templateId, tu, typeName, methodName, paramNames, excTypeSig, retTypeSig, lineDelimiter);
    }

    public static String getConstructorComment(ITranslationUnit tu, String typeName, String[] paramNames, String[] excTypeSig, String lineDelimiter) throws CoreException {
        String templateId = "org.eclipse.cdt.ui.text.codetemplates.constructorcomment";
        return StubUtility.getMethodComment(templateId, tu, typeName, typeName, paramNames, excTypeSig, null, lineDelimiter);
    }

    public static String getDestructorComment(ITranslationUnit tu, String typeName, String[] excTypeSig, String lineDelimiter) throws CoreException {
        String templateId = "org.eclipse.cdt.ui.text.codetemplates.destructorcomment";
        return StubUtility.getMethodComment(templateId, tu, typeName, "~" + typeName, EMPTY, excTypeSig, null, lineDelimiter);
    }

    public static String getMethodComment(String templateId, ITranslationUnit tu, String typeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        Template template = StubUtility.getCodeTemplate(templateId, tu.getCProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), tu.getCProject(), lineDelimiter);
        context.setTranslationUnitVariables(tu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        if (retTypeSig != null) {
            context.setVariable("return_type", retTypeSig);
        }
        context.setTranslationUnitVariables(tu);
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        return str;
    }

    private static String fixFullLineVariables(TemplateBuffer buffer, String[] variables) throws MalformedTreeException, BadLocationException {
        Document doc = new Document(buffer.getString());
        int nLines = doc.getNumberOfLines();
        MultiTextEdit edit = new MultiTextEdit();
        HashSet<Integer> removedLines = new HashSet<Integer>();
        int i = 0;
        while (i < variables.length) {
            TemplateVariable position = StubUtility.findVariable(buffer, variables[i]);
            if (position != null) {
                int[] offsets;
                if (position.getLength() > 0) {
                    offsets = position.getOffsets();
                    int j = 0;
                    while (j < offsets.length) {
                        block10: {
                            int offset = offsets[j];
                            try {
                                int startLine = doc.getLineOfOffset(offset);
                                int startOffset = doc.getLineOffset(startLine);
                                int endLine = doc.getLineOfOffset(offset + position.getLength());
                                String prefix = doc.get(startOffset, offset - startOffset);
                                if (prefix.length() <= 0 || startLine >= endLine) break block10;
                                int line = startLine + 1;
                                while (line <= endLine) {
                                    int lineOffset = doc.getLineOffset(line);
                                    edit.addChild((TextEdit)new InsertEdit(lineOffset, prefix));
                                    ++line;
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                break;
                            }
                        }
                        ++j;
                    }
                } else {
                    offsets = position.getOffsets();
                    int k = 0;
                    while (k < offsets.length) {
                        int line = doc.getLineOfOffset(offsets[k]);
                        IRegion lineInfo = doc.getLineInformation(line);
                        int offset = lineInfo.getOffset();
                        String str = doc.get(offset, lineInfo.getLength());
                        if (Strings.containsOnlyWhitespaces(str) && nLines > line + 1 && removedLines.add(line)) {
                            int nextStart = doc.getLineOffset(line + 1);
                            int length = nextStart - offset;
                            edit.addChild((TextEdit)new DeleteEdit(offset, length));
                        }
                        ++k;
                    }
                }
            }
            ++i;
        }
        edit.apply((IDocument)doc, 0);
        return doc.get();
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static String evaluateTemplate(TemplateContext context, Template template) throws CoreException {
        TemplateBuffer buffer;
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        return str;
    }

    private static String evaluateTemplate(TemplateContext context, Template template, String[] fullLineVariables) throws CoreException {
        String str;
        block6: {
            TemplateBuffer buffer;
            block5: {
                buffer = context.evaluate(template);
                if (buffer != null) break block5;
                return null;
            }
            str = StubUtility.fixFullLineVariables(buffer, fullLineVariables);
            if (!Strings.containsOnlyWhitespaces(str)) break block6;
            return null;
        }
        try {
            return str;
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public static String getLineDelimiterUsed(ICProject project) {
        return StubUtility.getProjectLineDelimiter(project);
    }

    private static String getProjectLineDelimiter(ICProject cProject) {
        String lineDelimiter;
        IProject project = null;
        if (cProject != null) {
            project = cProject.getProject();
        }
        if ((lineDelimiter = StubUtility.getLineDelimiterPreference(project)) != null) {
            return lineDelimiter;
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterPreference(IProject project) {
        IScopeContext[] scopeContext;
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project)};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }

    public static String getLineDelimiterUsed(ICElement elem) throws CModelException {
        if (elem == null) {
            return "";
        }
        ITranslationUnit cu = (ITranslationUnit)elem.getAncestor(60);
        if (cu != null && cu.exists()) {
            IBuffer buf = cu.getBuffer();
            int length = buf.getLength();
            int i = 0;
            while (i < length) {
                char ch = buf.getChar(i);
                if (ch == '\r') {
                    if (i + 1 < length && buf.getChar(i + 1) == '\n') {
                        return "\r\n";
                    }
                    return "\r";
                }
                if (ch == '\n') {
                    return "\n";
                }
                ++i;
            }
        }
        return StubUtility.getProjectLineDelimiter(elem.getCProject());
    }

    public static String getTodoTaskTag(ICProject project) {
        String markers = null;
        markers = project == null ? CCorePlugin.getOption((String)"org.eclipse.cdt.core.taskTags") : project.getOption("org.eclipse.cdt.core.taskTags", true);
        if (markers != null && markers.length() > 0) {
            int idx = markers.indexOf(44);
            if (idx == -1) {
                return markers;
            }
            return markers.substring(0, idx);
        }
        return "TODO";
    }

    public static boolean doAddComments(ICProject project) {
        return PreferenceConstants.getPreference("org.eclipse.cdt.ui.add_comments", project, false);
    }

    private static Template getDefaultFileTemplate(ITranslationUnit tu) {
        String templateId = null;
        if (tu.isASMLanguage()) {
            templateId = "org.eclipse.cdt.ui.text.codetemplates.asmsourcefile";
        } else if (tu.isCXXLanguage()) {
            templateId = tu.isHeaderUnit() ? "org.eclipse.cdt.ui.text.codetemplates.cppheaderfile" : "org.eclipse.cdt.ui.text.codetemplates.cppsourcefile";
        } else if (tu.isCLanguage()) {
            templateId = tu.isHeaderUnit() ? "org.eclipse.cdt.ui.text.codetemplates.cheaderfile" : "org.eclipse.cdt.ui.text.codetemplates.csourcefile";
        }
        return StubUtility.getCodeTemplate(templateId, tu.getCProject());
    }

    private static Template getTestFileTemplate(ITranslationUnit tu) {
        String templateId = null;
        if (tu.isCXXLanguage() && !tu.isHeaderUnit()) {
            templateId = "org.eclipse.cdt.ui.text.codetemplates.cpptestfile";
        }
        return StubUtility.getCodeTemplate(templateId, tu.getCProject());
    }

    private static Template getCodeTemplate(String id, ICProject cProject) {
        return StubUtility.getCodeTemplate(id, cProject != null ? cProject.getProject() : null);
    }

    private static Template getCodeTemplate(String id, IProject project) {
        if (project == null) {
            return CUIPlugin.getDefault().getCodeTemplateStore().findTemplateById(id);
        }
        ProjectTemplateStore projectStore = new ProjectTemplateStore(project);
        try {
            projectStore.load();
        }
        catch (IOException e) {
            CUIPlugin.log(e);
        }
        return projectStore.findTemplateById(id);
    }

    public static String generateIncludeGuardSymbol(IResource file, ICProject cproject) {
        int scheme = PreferenceConstants.getPreference("codetemplates.includeGuardGenerationScheme", cproject, 0);
        switch (scheme) {
            case 2: {
                if (file == null) {
                    return null;
                }
                IPath path = file.getFullPath();
                ISourceRoot root = cproject.findSourceRoot(file);
                IPath basePath = root == null ? cproject.getPath() : root.getPath();
                path = PathUtil.makeRelativePath((IPath)path, (IPath)basePath);
                return StubUtility.generateIncludeGuardSymbolFromFilePath(path.toString());
            }
            default: {
                CUIPlugin.log("Unknown preference value " + scheme + " for include guard scheme.", null);
            }
            case 0: {
                if (file == null) {
                    return null;
                }
                return StubUtility.generateIncludeGuardSymbolFromFilePath(file.getName());
            }
            case 1: 
        }
        return StubUtility.generateIncludeGuardSymbolFromUUID();
    }

    public static String generateIncludeGuardSymbolFromFilePath(String filename) {
        StringBuilder buf = new StringBuilder(filename.length() + 1);
        int i = 0;
        while (i < filename.length()) {
            char ch = filename.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                buf.append(Character.toUpperCase(ch));
            } else if (buf.length() > 0) {
                buf.append('_');
            }
            ++i;
        }
        buf.append('_');
        return buf.toString();
    }

    private static String generateIncludeGuardSymbolFromUUID() {
        String uuid = UUID.randomUUID().toString();
        StringBuilder buf = new StringBuilder();
        buf.append('H');
        int i = 0;
        while (i < uuid.length()) {
            char ch = uuid.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                buf.append(Character.toUpperCase(ch));
            } else {
                buf.append('_');
            }
            ++i;
        }
        return buf.toString();
    }

    public static Template[] getFileTemplatesForContentTypes(String[] contentTypes, IProject project) {
        TemplatePersistenceData[] templateDatas;
        if (contentTypes == null || contentTypes.length == 0) {
            return new Template[0];
        }
        if (project == null) {
            templateDatas = CUIPlugin.getDefault().getCodeTemplateStore().getTemplateData(true);
        } else {
            ProjectTemplateStore projectStore = new ProjectTemplateStore(project.getProject());
            try {
                projectStore.load();
            }
            catch (IOException e) {
                CUIPlugin.log(e);
            }
            templateDatas = projectStore.getTemplateData();
        }
        ArrayList<Template> result = new ArrayList<Template>();
        int j = 0;
        while (j < contentTypes.length) {
            int i = 0;
            while (i < templateDatas.length) {
                Template template = templateDatas[i].getTemplate();
                String contextTypeId = template.getContextTypeId();
                if (FileTemplateContextType.isContextTypeForContentType(contextTypeId, contentTypes[j])) {
                    result.add(template);
                }
                ++i;
            }
            ++j;
        }
        return result.toArray(new Template[result.size()]);
    }

    public static String suggestGetterName(String baseName, boolean bool, Set<String> excluded, ITranslationUnit context) {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.getter.capitalization", 3, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.getter.wordDelimiter", "", null);
        String prefix = bool ? preferences.getString("org.eclipse.cdt.ui", "nameStyle.getter.prefixForBoolean", "is", null) : preferences.getString("org.eclipse.cdt.ui", "nameStyle.getter.prefix", "get", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.getter.suffix", "", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        return StubUtility.adjustName(composer.compose(baseName), excluded, context);
    }

    public static String suggestSetterName(String baseName, Set<String> excluded, ITranslationUnit context) {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.setter.capitalization", 3, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.setter.wordDelimiter", "", null);
        String prefix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.setter.prefix", "set", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.setter.suffix", "", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        return StubUtility.adjustName(composer.compose(baseName), excluded, context);
    }

    public static String suggestParameterName(String baseName, Set<String> excluded, ITranslationUnit context) {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.variable.capitalization", 0, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.variable.wordDelimiter", "", null);
        String prefix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.variable.prefix", "", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.variable.suffix", "", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        return StubUtility.adjustName(composer.compose(baseName), excluded, context);
    }

    public static String suggestMethodName(String baseName, Set<String> excluded, ITranslationUnit context) {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.method.capitalization", 0, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.method.wordDelimiter", "", null);
        String prefix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.method.prefix", "", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.method.suffix", "", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        return StubUtility.adjustName(composer.compose(baseName), excluded, context);
    }

    private static String adjustName(String name, Set<String> namesToAvoid, ITranslationUnit context) {
        ILanguage language = null;
        try {
            if (context != null) {
                language = context.getLanguage();
            }
        }
        catch (CoreException coreException) {}
        return StubUtility.adjustName(name, namesToAvoid, language);
    }

    private static String adjustName(String name, Set<String> namesToAvoid, ILanguage language) {
        if (language == null) {
            language = GPPLanguage.getDefault();
        }
        String originalName = name;
        if (!StubUtility.isValidIdentifier(name, language)) {
            name = "class".equals(name) ? "clazz" : String.valueOf('_') + name;
        }
        int numTries = namesToAvoid != null ? namesToAvoid.size() + 1 : 1;
        int i = 1;
        while (i <= numTries) {
            if ((namesToAvoid == null || !namesToAvoid.contains(name)) && StubUtility.isValidIdentifier(name, language)) {
                return name;
            }
            name = String.valueOf(originalName) + i;
            ++i;
        }
        return null;
    }

    private static boolean isValidIdentifier(String name, ILanguage language) {
        if (language instanceof AbstractCLikeLanguage) {
            return CConventions.validateIdentifier((String)name, (AbstractCLikeLanguage)((AbstractCLikeLanguage)language)).isOK();
        }
        return true;
    }

    public static String trimFieldName(String fieldName) {
        int end;
        CBreakIterator iterator = new CBreakIterator();
        iterator.setText(fieldName);
        int firstWordStart = -1;
        int firstWordEnd = -1;
        int secondWordStart = -1;
        int lastWordEnd = -1;
        int start = iterator.first();
        while ((end = iterator.next()) != -1) {
            if (Character.isLetterOrDigit(fieldName.charAt(start))) {
                int pos = end;
                while (--pos >= start && !Character.isLetterOrDigit(fieldName.charAt(pos))) {
                }
                lastWordEnd = pos + 1;
                if (firstWordStart < 0) {
                    firstWordStart = start;
                    firstWordEnd = lastWordEnd;
                } else if (secondWordStart < 0) {
                    secondWordStart = start;
                }
            }
            start = end;
        }
        if (firstWordStart >= 0 && firstWordStart + 1 == firstWordEnd && secondWordStart >= 0) {
            firstWordStart = secondWordStart;
        }
        if (firstWordStart < 0) {
            return fieldName;
        }
        return fieldName.substring(firstWordStart, lastWordEnd);
    }
}

