/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.scripting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.periphs.controller.scripting.PeripheralsScriptFunctionalGroup;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.ActiveComponents;
import com.nxp.swtools.periphs.model.data.Code;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.FragmentDefs;
import com.nxp.swtools.periphs.model.data.Mode;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.yaml.PeripheralsYamlConverter;
import com.nxp.swtools.periphs.model.yaml.PeriphsProfileInfo;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.utils.scripting.ProfileInfo;
import com.nxp.swtools.utils.scripting.ScriptDependencyHelper;
import com.nxp.swtools.utils.scripting.api.IMcuInfo;
import com.nxp.swtools.utils.scripting.api.IProfile;
import com.nxp.swtools.utils.scripting.api.IScriptDependencyHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PeripheralsScriptProfile
implements IProfile {
    private final ActiveComponents activeComponents;
    private final PeriphsProfile profile;
    private final List<PeripheralsScriptFunctionalGroup> peripheralsScriptFunctionalGroups;
    private final IMcu mcu;
    private final ScriptDependencyHelper dependencyHelper;

    public PeripheralsScriptProfile(IMcu mcu, PeriphsProfile profile) {
        this.mcu = mcu;
        this.activeComponents = profile.getActiveComponents();
        this.profile = profile;
        this.peripheralsScriptFunctionalGroups = new ArrayList<PeripheralsScriptFunctionalGroup>();
        ArrayList<StoragePeriphsFuncGroup> functionalGroupsStorages = new ArrayList<StoragePeriphsFuncGroup>();
        for (FunctionalGroup functionalGroup : profile.getFunctionalGroups()) {
            this.peripheralsScriptFunctionalGroups.add(new PeripheralsScriptFunctionalGroup(functionalGroup));
            functionalGroupsStorages.add(functionalGroup.getStorageFuncGroup());
        }
        this.dependencyHelper = new ScriptDependencyHelper(functionalGroupsStorages, false);
    }

    public @Nullable String getYaml() {
        if (this.profile.isYamlEnabled()) {
            return new PeripheralsYamlConverter().createYamlProfile((ProfileInfo)new PeriphsProfileInfo(this.profile));
        }
        return null;
    }

    public String getToolVersion() {
        SwToolsProduct periphTool = SwToolsProductConfiguration.getRegisteredProduct((String)"Peripherals");
        assert (periphTool != null);
        return periphTool.getVersion();
    }

    public String getToolName() {
        return "Peripherals";
    }

    public Collection<ConfigurationComponent> getComponents() {
        return this.activeComponents.getConfigComps();
    }

    public @Nullable ConfigurationComponent getComponent(String id) {
        return this.activeComponents.getConfigComp(id);
    }

    public @Nullable ConfigSet getConfigSet(String componentId, String id) {
        ConfigurationComponent configComp = this.activeComponents.getConfigComp(componentId);
        return configComp == null ? null : configComp.getConfigSet(id);
    }

    public @Nullable ISetting getSetting(String componentId, String configSetId, String id) {
        ConfigurationComponent component = this.getComponent(componentId);
        if (component != null) {
            Triplet setting = this.activeComponents.findSetting(component, configSetId, id, false);
            return setting == null ? null : (ISetting)setting.getFirst();
        }
        return null;
    }

    public @Nullable Mode getMode(String componentId, String id) {
        ConfigurationComponent configComp = this.activeComponents.getConfigComp(componentId);
        return configComp == null ? null : configComp.getMode(id);
    }

    public @Nullable Code getCode(String componentId, String configSetId) {
        ConfigSet configSet = this.getConfigSet(componentId, configSetId);
        if (configSet != null) {
            return configSet.getCode();
        }
        return null;
    }

    public @Nullable FragmentDefs getFragmentDefs(String componentId, String configSetId) {
        ConfigSet configSet = this.getConfigSet(componentId, configSetId);
        if (configSet != null) {
            return configSet.getFragmentDefs();
        }
        return null;
    }

    public IMcuInfo getMcuInfo() {
        return this.mcu;
    }

    public IScriptDependencyHelper getDependencyHelper() {
        return this.dependencyHelper;
    }

    public PeripheralsScriptFunctionalGroup[] getFunctionalGroups() {
        return this.peripheralsScriptFunctionalGroups.toArray(new PeripheralsScriptFunctionalGroup[this.peripheralsScriptFunctionalGroups.size()]);
    }

    public @Nullable PeripheralsScriptFunctionalGroup getFunctionalGroup(String name) {
        return (PeripheralsScriptFunctionalGroup)CollectionsUtils.nullableOptionalGet(this.peripheralsScriptFunctionalGroups.stream().filter(x -> x.getName().equals(name)).findFirst());
    }

    public Collection<ComponentConfig> getComponentConfigurations() {
        Collection<ComponentConfig> result = this.profile.getConfiguredComponents().values();
        assert (result != null);
        return result;
    }

    public @Nullable ComponentConfig getComponentConfiguration(String id) {
        return this.profile.getComponent(id);
    }

    public void applyDependencies() {
        this.dependencyHelper.applyScriptDependencies();
    }
}

