/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.scripting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class PeripheralsScriptFunctionalGroup {
    private static final Logger LOGGER = LogManager.getLogger(PeripheralsScriptFunctionalGroup.class);
    private final FunctionalGroup functionalGroup;

    public PeripheralsScriptFunctionalGroup(FunctionalGroup functionalGroup) {
        this.functionalGroup = functionalGroup;
    }

    public String getName() {
        return this.functionalGroup.getName();
    }

    private ArrayList<ComponentInstanceConfig> getComponentInstancesList() {
        ArrayList<ComponentInstanceConfig> result = new ArrayList<ComponentInstanceConfig>();
        Collection componentInstanceConfigs = this.functionalGroup.getInstances().values();
        for (ComponentInstanceConfig componentInstanceConfig : componentInstanceConfigs) {
            if (componentInstanceConfig == null || !componentInstanceConfig.isEnabled()) continue;
            result.add(componentInstanceConfig);
        }
        return result;
    }

    public ComponentInstanceConfig[] getComponentInstances() {
        ArrayList<ComponentInstanceConfig> componentInstanceConfigs = this.getComponentInstancesList();
        return componentInstanceConfigs.toArray(new ComponentInstanceConfig[componentInstanceConfigs.size()]);
    }

    public ComponentInstanceConfig[] getComponentInstances(String type) {
        ArrayList<ComponentInstanceConfig> componentInstanceConfigs = this.getComponentInstancesList();
        componentInstanceConfigs.removeIf(x -> !x.getComponent().getId().equals(type));
        return componentInstanceConfigs.toArray(new ComponentInstanceConfig[componentInstanceConfigs.size()]);
    }

    public String[] getComponentInstancesNames() {
        ArrayList<ComponentInstanceConfig> componentInstanceConfigs = this.getComponentInstancesList();
        List<String> names = componentInstanceConfigs.stream().map(x -> x.getName()).collect(Collectors.toList());
        return names.toArray(new String[names.size()]);
    }

    public String[] getComponentInstancesNames(String type) {
        ArrayList<ComponentInstanceConfig> componentInstanceConfigs = this.getComponentInstancesList();
        List<String> names = componentInstanceConfigs.stream().filter(y -> y.getComponent().getId().equals(type)).map(x -> x.getName()).collect(Collectors.toList());
        return names.toArray(new String[names.size()]);
    }

    public @Nullable ComponentInstanceConfig getComponentInstanceConfig(String type, String instanceName) {
        ComponentInstanceConfig componentInstance = this.functionalGroup.getComponentInstance(type, instanceName);
        if (componentInstance != null) {
            return componentInstance.isEnabled() ? componentInstance : null;
        }
        return null;
    }

    public @Nullable ISettingConfig getSetting(ComponentInstanceConfig componentInstanceConfig, String setting) {
        IChild child = componentInstanceConfig.getChildById(setting);
        if (child instanceof ISettingConfig) {
            return (ISettingConfig)child;
        }
        return null;
    }

    public @Nullable ISettingConfig getSetting(ComponentInstanceConfig componentInstanceConfig, String configSet, String setting) {
        return this.getSetting(componentInstanceConfig, String.valueOf(configSet) + "." + setting);
    }

    public @Nullable ISettingConfig getSetting(String type, String instanceName, String setting) {
        ComponentInstanceConfig componentInstanceConfig = this.functionalGroup.getComponentInstance(type, instanceName);
        if (componentInstanceConfig != null) {
            ISettingConfig settingConfig = this.getSetting(componentInstanceConfig, setting);
            return settingConfig;
        }
        return null;
    }

    public @Nullable ISettingConfig getSetting(String type, String instanceName, String configSet, String setting) {
        return this.getSetting(type, instanceName, String.valueOf(configSet) + "." + setting);
    }

    public boolean isSettingAvailable(ComponentInstanceConfig componentInstanceConfig, String setting) {
        ISettingConfig settingConfig = this.getSetting(componentInstanceConfig, setting);
        if (settingConfig != null) {
            return settingConfig.isAvailable();
        }
        LOGGER.warning("Setting with name: " + setting + " is not a valid setting.");
        return false;
    }

    public boolean isSettingAvailable(ComponentInstanceConfig componentInstanceConfig, String configSet, String setting) {
        return this.isSettingAvailable(componentInstanceConfig, String.valueOf(configSet) + "." + setting);
    }

    public boolean isSettingAvailable(String type, String instanceName, String configSet, String setting) {
        return this.isSettingAvailable(type, instanceName, String.valueOf(configSet) + "." + setting);
    }

    public boolean isSettingAvailable(String type, String instanceName, String setting) {
        ComponentInstanceConfig componentInstanceConfig = this.functionalGroup.getComponentInstance(type, instanceName);
        if (componentInstanceConfig != null) {
            return this.isSettingAvailable(componentInstanceConfig, setting);
        }
        return false;
    }

    public boolean isSettingEnabled(String type, String instanceName, String setting) {
        ISettingConfig child = this.getSetting(type, instanceName, setting);
        if (child != null) {
            return child.isEnabled();
        }
        return false;
    }

    public boolean isCalledFromDefaultInit() {
        return this.functionalGroup.isCalledFromDefaultInit();
    }

    public String getCore() {
        return this.functionalGroup.getCore();
    }

    public String getIdPrefix() {
        return this.functionalGroup.getIdPrefix();
    }

    public boolean isPeripheralAvailable(String peripheralName) {
        return this.functionalGroup.getMcu().isPeripheralAvailableForCore(this.functionalGroup.getCore(), peripheralName);
    }
}

