/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.dependencies;

import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryAnnotation;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryResult;
import com.nxp.swtools.provider.configuration.dependencies.DependencyResourceAnotation;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import com.nxp.swtools.provider.configuration.storage.IDependenciesConfiguration;
import com.nxp.swtools.provider.configuration.storage.INamedTool;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DependencyQueryAnnotation(resources={@DependencyResourceAnotation(resourceType="Peripheral", features={"initialized"})})
public class PeripheralsToolQuery
implements IDependencyQuery {
    public Collection<IDependencyQueryResult> query(ISharedConfiguration configuration, String resourceType, String resourceId, String featureName) {
        ArrayList<IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        StoragePeriphsTool periphsTool = configuration.getTools().getPeripherals();
        if (periphsTool == null || Controller.getInstance().getToolError() != null) {
            return result;
        }
        if (!periphsTool.isEnabled()) {
            return result;
        }
        if ("Peripheral".equalsIgnoreCase(resourceType)) {
            result.addAll(PeripheralsToolQuery.getPeripheralQueryResult(periphsTool, resourceId));
        }
        return result;
    }

    private static Collection<IDependencyQueryResult> getPeripheralQueryResult(StoragePeriphsTool periphsTool, String resourceId) {
        return PeripheralsToolQuery.queryAllConfigs((config, storageConfig) -> {
            Boolean val = Boolean.FALSE;
            for (ComponentInstanceConfig inst : config.getInstances().values()) {
                if (!inst.isEnabled() || !inst.isPeripheralUsed(resourceId)) continue;
                val = Boolean.TRUE;
                break;
            }
            if (!val.booleanValue() && Controller.getInstance().getComponentsOfPeripheral(resourceId).isEmpty()) {
                val = null;
            }
            return Stream.of(new DependencyQueryResult((Object)val, (INamedTool)periphsTool, (IDependenciesConfiguration)storageConfig));
        });
    }

    private static List<IDependencyQueryResult> queryAllConfigs(BiFunction<FunctionalGroup, StoragePeriphsFuncGroup, Stream<IDependencyQueryResult>> usingQuery) {
        ArrayList<IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        Controller.getInstance().getProfile().getFunctionalGroups().forEach(config -> {
            StoragePeriphsFuncGroup storageConfig = config.getStorageFuncGroup();
            result.addAll(((Stream)usingQuery.apply((FunctionalGroup)config, storageConfig)).collect(Collectors.toList()));
        });
        return result;
    }
}

