/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.application;

import com.nxp.swtools.common.utils.cmd.CmdSection;
import com.nxp.swtools.common.utils.cmd.ICmdApplication;
import com.nxp.swtools.common.utils.files.FileAccessFactory;
import com.nxp.swtools.common.utils.files.IAbstractFileAccess;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.ExecutableExtensionProvider;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.report.PeriphsHtmlReportGenerator;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.IDestinationPathProvider;
import com.nxp.swtools.provider.configuration.sources.SimpleDestinationPathProvider;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import com.nxp.swtools.utils.wizards.exportWizard.ExportUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class CmdApplication
implements ICmdApplication {
    protected static final String INTERNAL_PLUGIN_ID = "com.nxp.swtools.periphs.internal";
    protected static final String INTERNAL_DEVELOPMENT_ELEMENT = "internal_development";
    protected static final String INTERNAL_DEVELOPMENT_CLASS_ATTRIBUTE = "class";
    protected static final Logger LOGGER = LogManager.getLogger(CmdApplication.class);

    public boolean run(CmdSection cmdSection) {
        boolean result = true;
        Set keys = cmdSection.cmdMap.keySet();
        for (String key : keys) {
            String path;
            if (key.equals("-ExportAll") && !(path = cmdSection.getOptionValue("-ExportAll")).isEmpty()) {
                result &= CmdApplication.exportSources(path, false);
                result &= CmdApplication.exportHTML(path);
            }
            if (key.equals("-ExportSrc") && !(path = cmdSection.getOptionValue("-ExportSrc")).isEmpty()) {
                result &= CmdApplication.exportSources(path, false);
            }
            if (key.equals("-ExportMcuTemplate") && !(path = cmdSection.getOptionValue("-ExportMcuTemplate")).isEmpty()) {
                result &= CmdApplication.exportSources(path, true);
            }
            if (!key.equals("-ExportHTML") || (path = cmdSection.getOptionValue("-ExportHTML")).isEmpty()) continue;
            result &= CmdApplication.exportHTML(path);
        }
        ExecutableExtensionProvider extensionProvider = new ExecutableExtensionProvider(INTERNAL_PLUGIN_ID, INTERNAL_DEVELOPMENT_ELEMENT, INTERNAL_DEVELOPMENT_CLASS_ATTRIBUTE);
        Collection extensions = extensionProvider.getExtensions();
        for (ICmdApplication internalCmdApplication : extensions) {
            result &= internalCmdApplication.run(cmdSection);
        }
        return result;
    }

    public static boolean exportSources(String path, boolean template) {
        ScriptResult scriptResult = Controller.getInstance().waitAndGetGeneratedCode();
        if (scriptResult != null) {
            boolean result = true;
            Map generatedCode = scriptResult.getOpenedFiles();
            if (!generatedCode.isEmpty()) {
                result = ExportUtils.exportSources((Map)generatedCode, (String)path);
            }
            boolean flatten = Controller.getInstance().getMcu().getCores().size() <= 1;
            for (String core : scriptResult.getCores()) {
                generatedCode = scriptResult.getOpenedFiles(core);
                if (generatedCode == null || generatedCode.isEmpty()) continue;
                if (template) {
                    generatedCode = ExportUtils.removePackageIdFromGenCode((Map)generatedCode);
                    generatedCode = ExportUtils.removeCoreIdFromGenCode((Map)generatedCode);
                }
                Path corePath = flatten ? Paths.get(path, new String[0]) : Paths.get(path, new String[0]).resolve(core);
                result &= ExportUtils.exportSources((Map)generatedCode, (String)UtilsText.safeString((String)corePath.toString()));
            }
            return result;
        }
        LOGGER.info("Export sources did not finish correctly. Code wasn't generated");
        StoragePeriphsTool configTool = SharedConfigurationFactory.getSharedConfigurationSingleton().getTools().getPeripherals();
        if (configTool == null) {
            LOGGER.severe("Generating code for not configured Peripherals tool");
        } else if (!configTool.isEnabled()) {
            LOGGER.severe("Generating code for disabled Peripherals tool");
        }
        return false;
    }

    private static boolean exportHTML(String path) {
        AExportWizard.GenerationResult result = PeriphsHtmlReportGenerator.generateReport();
        if (result.wasSuccessful) {
            Map report = result.generatedFiles;
            assert (report != null);
            return ExportUtils.exportToFolder((IDestinationPathProvider)new SimpleDestinationPathProvider(Paths.get(path, new String[0])), (Map)report, (IAbstractFileAccess)FileAccessFactory.getFileSystemAccess(), (String)KEPreferences.getLineEnding(), null, (boolean)false);
        }
        return false;
    }
}

