/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.engine.ProblemUtils;
import com.nxp.swtools.validation.engine.ValidationProblemsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public class ValidationHelper {
    public static Map<String, List<IValidationProblem>> collectValidationProblemsOnPeripheralsTool() {
        List<String> respondsTo = Arrays.asList("Peripheral");
        Predicate<IValidationProblem> predicate = p -> respondsTo.contains(p.getDependency().getResourceType());
        Function<IValidationProblem, String> keyTransformer = p -> p.getDependency().getResourceId();
        Map problems = ValidationProblemsUtils.getValidationProblemsMap(predicate, keyTransformer);
        return problems;
    }

    public static Map<String, List<IValidationProblem>> collectComponentValidationProblemsOnPeripheralsTool() {
        Predicate<IValidationProblem> predicate = p -> !((StorageDependency)p.getDependency()).getOriginatorId().isEmpty();
        Function<IValidationProblem, String> keyTransformer = p -> ((StorageDependency)p.getDependency()).getOriginatorId();
        return ValidationProblemsUtils.getValidationProblemsMap(predicate, keyTransformer);
    }

    public static List<IValidationProblem> getComponentValidationProblems(IChild component, int problemLevel) {
        return ValidationHelper.getValidationProblems(component, problemLevel, ValidationHelper.getComponentEqualityPredicate());
    }

    public static int getHighestSeverityComponentValidationProblemLevel(IChild component) {
        return ValidationHelper.getHighestSeverityValidationProblemLevel(component, ValidationHelper.getComponentEqualityPredicate());
    }

    private static BiPredicate<IChild, IValidationProblem> getComponentEqualityPredicate() {
        BiPredicate<IChild, IValidationProblem> bipredicate = (node, problem) -> {
            if (problem.getDependency() instanceof StorageDependency) {
                StorageDependency storageDependency = (StorageDependency)problem.getDependency();
                boolean idEquals = Objects.equals(StorageDependency.extractComponentId((String)storageDependency.getOriginatorId()), StorageDependency.extractComponentId((String)node.getOriginatorId()));
                String dependencySource = storageDependency.getSource();
                String dependencyFunctionalGroupName = dependencySource.substring(dependencySource.indexOf(":") + 1);
                FunctionalGroup nodeFunctionalGroup = node.getChildContext().getFunctionalGroup();
                String nodeFunctionalGroupName = nodeFunctionalGroup != null ? nodeFunctionalGroup.getName() : "";
                boolean groupEquals = Objects.equals(nodeFunctionalGroupName, dependencyFunctionalGroupName);
                return idEquals && groupEquals;
            }
            return false;
        };
        return bipredicate;
    }

    private static BiPredicate<IChild, IValidationProblem> getSettingEqualityPredicate() {
        BiPredicate<IChild, IValidationProblem> bipredicate = (node, problem) -> {
            if (problem.getDependency() instanceof StorageDependency) {
                StorageDependency storageDependency = (StorageDependency)problem.getDependency();
                boolean idEquals = Objects.equals(storageDependency.getOriginatorId(), node.getOriginatorId());
                String dependencySource = storageDependency.getSource();
                String dependencyFunctionalGroupName = dependencySource.substring(dependencySource.indexOf(":") + 1);
                FunctionalGroup nodeFunctionalGroup = node.getChildContext().getFunctionalGroup();
                String nodeFunctionalGroupName = nodeFunctionalGroup != null ? nodeFunctionalGroup.getName() : "";
                boolean groupEquals = Objects.equals(nodeFunctionalGroupName, dependencyFunctionalGroupName);
                return idEquals && groupEquals;
            }
            return false;
        };
        return bipredicate;
    }

    public static List<IValidationProblem> getSettingValidationProblems(IChild setting, int problemLevel) {
        return ValidationHelper.getValidationProblems(setting, problemLevel, ValidationHelper.getSettingEqualityPredicate());
    }

    public static int getHighestSeveritySettingValidationProblemLevel(IChild setting) {
        return ValidationHelper.getHighestSeverityValidationProblemLevel(setting, ValidationHelper.getSettingEqualityPredicate());
    }

    private static List<IValidationProblem> getValidationProblems(IChild node, int problemLevel, BiPredicate<IChild, IValidationProblem> biPredicate) {
        ArrayList<IValidationProblem> result = new ArrayList<IValidationProblem>();
        if (problemLevel >= 0) {
            Map<String, List<IValidationProblem>> problems = ValidationHelper.collectComponentValidationProblemsOnPeripheralsTool();
            for (Map.Entry<String, List<IValidationProblem>> entry : problems.entrySet()) {
                List<IValidationProblem> entryValue = entry.getValue();
                for (IValidationProblem problem : entryValue) {
                    if (!biPredicate.test(node, problem) || problem.getProblemLevel() != problemLevel) continue;
                    result.add(problem);
                }
            }
        }
        return result;
    }

    private static int getHighestSeverityValidationProblemLevel(IChild node, BiPredicate<IChild, IValidationProblem> biPredicate) {
        Map<String, List<IValidationProblem>> problems = ValidationHelper.collectComponentValidationProblemsOnPeripheralsTool();
        int highestLevel = -1;
        for (Map.Entry<String, List<IValidationProblem>> entry : problems.entrySet()) {
            List<IValidationProblem> problemsOfComponent;
            IValidationProblem problem;
            boolean allProblemsPassedTest = true;
            List<IValidationProblem> entryValue = entry.getValue();
            for (IValidationProblem value : entryValue) {
                if (biPredicate.test(node, value)) continue;
                allProblemsPassedTest = false;
            }
            if (!allProblemsPassedTest || (problem = (IValidationProblem)ProblemUtils.getHighestSeverityNonNullProblem((problemsOfComponent = entryValue).stream())) == null) continue;
            int problemLevel = problem.getProblemLevel();
            if (problemLevel >= 3) {
                return problemLevel;
            }
            if (problemLevel <= highestLevel) continue;
            highestLevel = problemLevel;
        }
        return highestLevel;
    }
}

