/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.data.Level;
import com.nxp.swtools.validation.engine.GenericProblem;
import java.util.Objects;

public class PeripheralsProblem
extends GenericProblem {
    @Nullable
    private final String componentType;
    @Nullable
    private final String componentInstanceName;
    @Nullable
    private final String functionalGroupName;

    protected PeripheralsProblem(IChild child, String problem, Level problemLevel) {
        super("Peripherals", PeripheralsProblem.getIntLevel(problemLevel), problem, "Peripherals:" + PeripheralsProblem.getFunctionalGroupName(child.getChildContext()), PeripheralsProblem.getResource(child), problem);
        ComponentConfig componentConfig = child.getChildContext().getComponentConfig();
        this.componentType = componentConfig == null ? null : componentConfig.getName();
        ComponentInstanceConfig componentInstanceConfig = child.getChildContext().getComponentInstanceConfig();
        this.componentInstanceName = componentInstanceConfig == null ? null : componentInstanceConfig.getUiName();
        FunctionalGroup functionalGroup = child.getChildContext().getFunctionalGroup();
        this.functionalGroupName = functionalGroup == null ? null : functionalGroup.getUiName();
    }

    private static String getFunctionalGroupName(ChildContext childContext) {
        FunctionalGroup functionalGroup = childContext.getFunctionalGroup();
        return functionalGroup == null ? "" : functionalGroup.getName();
    }

    public static int getIntLevel(Level level) {
        switch (level) {
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
            case INFO: {
                return 0;
            }
        }
        return -1;
    }

    private static String getResource(IChild child) {
        ComponentInstanceConfig compInstConfig = child.getChildContext().getComponentInstanceConfig();
        ComponentConfig comConfig = child.getChildContext().getComponentConfig();
        return compInstConfig != null ? compInstConfig.getUiName() : (comConfig != null ? comConfig.getUiName() : "");
    }

    public @Nullable String getComponentInstanceName() {
        return this.componentInstanceName;
    }

    public @Nullable String getComponentType() {
        return this.componentType;
    }

    public @Nullable String getFunctionalGroupName() {
        return this.functionalGroupName;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.componentType);
        result = 31 * result + Objects.hashCode(this.componentInstanceName);
        result = 31 * result + Objects.hashCode(this.functionalGroupName);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        PeripheralsProblem other = (PeripheralsProblem)((Object)obj);
        if (!Objects.equals(this.componentType, other.componentType)) {
            return false;
        }
        if (!Objects.equals(this.componentInstanceName, other.componentInstanceName)) {
            return false;
        }
        return Objects.equals(this.functionalGroupName, other.functionalGroupName);
    }
}

