/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.scripting.PeripheralsScriptProfile;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.IStorageConfigurationPreferencesRead;
import com.nxp.swtools.utils.scripting.CodeGenerator;
import com.nxp.swtools.utils.scripting.ScriptFileProvider;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.scripting.api.IProfileProvider;
import com.nxp.swtools.utils.scripting.api.IScriptFileProvider;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;
import javax.script.CompiledScript;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class PeripheralsCodeManager {
    private static final Logger LOGGER = LogManager.getLogger(PeripheralsCodeManager.class);
    public static final int TIMEOUT_GENERATION_MS = 15000;
    public static final int TIMEOUT_WAIT_MS = 20000;
    final Controller controller;
    @Nullable
    volatile ScriptResult generatedCode;
    volatile boolean generatingCode = false;
    volatile boolean needsToRegenerate = false;
    volatile long lastGenerationStart = -1L;
    Semaphore semaphore = new Semaphore(0);

    public PeripheralsCodeManager(Controller controller) {
        this.controller = controller;
    }

    public boolean isGeneratingCode() {
        return this.generatingCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCodeDirty() {
        PeripheralsCodeManager peripheralsCodeManager = this;
        synchronized (peripheralsCodeManager) {
            return this.generatingCode || this.needsToRegenerate;
        }
    }

    public boolean waitUntilRegenerated() {
        this.semaphore.drainPermits();
        long startTimeMs = System.currentTimeMillis();
        while (this.isCodeDirty() && System.currentTimeMillis() <= startTimeMs + 20000L) {
            if (System.currentTimeMillis() <= this.lastGenerationStart + 15000L) continue;
            this.requestRegenerateCode();
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {}
        }
        return !this.isCodeDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCodeGeneration() {
        if (this.controller.isTurnedOn() && this.controller.isMcuSupported()) {
            CompiledScript compiledScriptLoc = this.controller.getMcu().getCodeGeneratorScript();
            if (compiledScriptLoc != null) {
                Thread uiThread;
                ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
                PeriphsProfile profile = this.controller.getProfile();
                final PeripheralsScriptProfile peripheralsScriptProfile = new PeripheralsScriptProfile(this.controller.getMcu(), profile);
                IProfileProvider profileProvider = new IProfileProvider(){

                    public PeripheralsScriptProfile getProfile(Thread uiThread) {
                        return peripheralsScriptProfile;
                    }
                };
                ScriptFileProvider scriptFileProvider = new ScriptFileProvider(this.controller.getMcu().getScriptFileFolders());
                Thread thread = uiThread = this.controller.display != null ? this.controller.display.getThread() : Thread.currentThread();
                assert (uiThread != null);
                CodeGenerator codeGenerator = new CodeGenerator(profileProvider, (IScriptFileProvider)scriptFileProvider, (IStorageConfigurationPreferencesRead)sharedConfig.getPreferences());
                codeGenerator.setTimeoutMs(15000);
                PeripheralsCodeManager peripheralsCodeManager = this;
                synchronized (peripheralsCodeManager) {
                    this.lastGenerationStart = System.currentTimeMillis();
                    this.generatingCode = true;
                    codeGenerator.generateAsync(compiledScriptLoc, (CodeGenerator.IGeneratorListener)new CodeGeneratorListener(peripheralsScriptProfile), uiThread);
                }
            }
        } else {
            this.generatedCode = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRegenerateCode() {
        PeripheralsCodeManager peripheralsCodeManager = this;
        synchronized (peripheralsCodeManager) {
            boolean timeout;
            boolean bl = timeout = this.lastGenerationStart >= 0L && System.currentTimeMillis() > this.lastGenerationStart + 20000L;
            if (this.generatingCode && timeout) {
                LOGGER.warning("Timeout during code generation");
            }
            if (this.generatingCode && !timeout) {
                this.needsToRegenerate = true;
                return;
            }
            this.needsToRegenerate = false;
            this.scheduleCodeGeneration();
        }
    }

    public @Nullable ScriptResult getGeneratedCode() {
        return this.generatedCode;
    }

    private class CodeGeneratorListener
    implements CodeGenerator.IGeneratorListener {
        private static final String REFRESHING_SOURCES = "Refreshing sources";
        private final Runnable refreshUIRunnable = () -> {
            if (PeripheralsCodeManager.this.generatedCode != null && !PeripheralsCodeManager.this.generatedCode.containsAnyError()) {
                profile.applyDependencies();
            }
            PeripheralsCodeManager.this.controller.updateValidationParams();
            PeripheralsCodeManager.this.controller.refreshSourceCodeView();
            this.currentRefreshJob = null;
        };
        @Nullable
        private UIJob currentRefreshJob;

        public CodeGeneratorListener(PeripheralsScriptProfile profile) {
        }

        public void onCodeGenerationFailed(ScriptResult scriptResult) {
            this.codeGenerationCompleted(scriptResult, false);
        }

        public void onCodeGenerated(ScriptResult scriptResult) {
            this.codeGenerationCompleted(scriptResult, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void codeGenerationCompleted(ScriptResult scriptResult, boolean storeResult) {
            PeripheralsCodeManager peripheralsCodeManager = PeripheralsCodeManager.this;
            synchronized (peripheralsCodeManager) {
                PeripheralsCodeManager.this.generatedCode = null;
                if (storeResult) {
                    PeripheralsCodeManager.this.generatedCode = scriptResult;
                }
                PeripheralsCodeManager.this.generatingCode = false;
                PeripheralsCodeManager.this.semaphore.release();
            }
            if (PeripheralsCodeManager.this.needsToRegenerate) {
                PeripheralsCodeManager.this.requestRegenerateCode();
            }
            if (this.isAnotherUIJobWaiting()) {
                return;
            }
            this.currentRefreshJob = UIJobHelper.runUIJob((Runnable)this.refreshUIRunnable, (String)REFRESHING_SOURCES, (boolean)false, (Display)PeripheralsCodeManager.this.controller.display);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isAnotherUIJobWaiting() {
            PeripheralsCodeManager peripheralsCodeManager = PeripheralsCodeManager.this;
            synchronized (peripheralsCodeManager) {
                UIJob currentRefreshJobLoc = this.currentRefreshJob;
                return currentRefreshJobLoc != null && currentRefreshJobLoc.getState() == 2;
            }
        }
    }
}

