/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedToolsByProcessor;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.controller.Messages;
import com.nxp.swtools.periphs.controller.PeripheralsCodeManager;
import com.nxp.swtools.periphs.controller.PeripheralsGenericProblem;
import com.nxp.swtools.periphs.controller.ValidationParams;
import com.nxp.swtools.periphs.controller.generation.PeripheralsSourceCodeRefreshHandler;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.periphs.model.config.ExpressionContext;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.periphs.model.data.MasterPeripheral;
import com.nxp.swtools.periphs.model.data.Mode;
import com.nxp.swtools.periphs.model.data.SWComponent;
import com.nxp.swtools.periphs.model.data.mcu.EmptyMcu;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.resources.DataDirectory;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.dependencies.DependencyCreator;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.helper.CommonConfigImpl;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageConfigurationPreferences;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.provider.configuration.storage.StorageDependencyFeature;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.provider.features.SdkFeaturesProvider;
import com.nxp.swtools.provider.toolchainproject.IGeneratedFilesStatusProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectProvider;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.view.IViewRefreshManager;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import com.nxp.swtools.validation.engine.GenericProblem;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Version;

public class Controller
extends APeriphController {
    private boolean disposed = false;
    protected PeripheralsCodeManager codeManager = new PeripheralsCodeManager(this);
    protected boolean isOn;
    @Nullable
    protected final Display display;
    volatile boolean otherToolChanged = false;
    @Nullable
    PeripheralsSourceCodeRefreshHandler codeRefreshManagerHandler = null;

    private Controller() {
        final ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        this.reloadFromSharedConfig(sharedConfig);
        this.display = SWToolsProperties.isHeadlessOn() ? null : Display.getCurrent();
        SharedConfigurationFactory.getSharedConfigurationSingleton().addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

            public void configurationReloaded(ISharedConfiguration sharedConfiguration, ConfigChangeReason reason) {
                if (reason != ConfigChangeReason.UNDO_REDO || !Controller.this.profile.getStoragePeripheralsTool().equals((StorageTool)sharedConfiguration.getTools().getPeripherals(), StorageTool.CompareMode.MEX_AND_YAML) || Controller.this.profile.isYamlEnabled() != sharedConfiguration.getPreferences().isYamlOutputEnabled()) {
                    Controller.this.reloadFromSharedConfig(sharedConfiguration);
                } else {
                    Controller.this.otherToolChanged = true;
                }
            }

            public void configurationChanged(ISharedConfiguration sharedConfiguration, IConfigChangeContext changeContext) {
                Object source = changeContext.getSource();
                if (source instanceof StorageConfigurationPreferences) {
                    Controller.this.profile.setYamlEnabled(((StorageConfigurationPreferences)source).isYamlOutputEnabled());
                    Controller.this.requestRegenerateCode();
                } else if (changeContext.getChangeType() == IConfigChangeContext.ConfigChangeType.TOOL_TOGGLE) {
                    if ("Peripherals".equals(changeContext.getToolId())) {
                        this.configurationReloaded(sharedConfiguration, ConfigChangeReason.UNKNOWN);
                    } else {
                        Controller.this.softRefresh();
                    }
                } else if (source instanceof CommonConfigImpl) {
                    CommonConfigImpl commonConfigImpl = (CommonConfigImpl)source;
                    ProcessorCore selectedCore = commonConfigImpl.getSelectedCore();
                    if (selectedCore != null) {
                        Controller.this.profile.setActiveCoreId(selectedCore.getID());
                        Controller.this.handleSettingChange(1, sharedConfig, null);
                    }
                } else if (!"Peripherals".equals(changeContext.getToolId())) {
                    Controller.this.otherToolChanged = true;
                }
            }

            public void commonConfigurationChanged(ISharedConfiguration sharedConfiguration) {
                if (!sharedConfiguration.getCommonConfig().getMcuIdentification().equals(Controller.this.mcu.getMcuIdentification())) {
                    this.configurationReloaded(sharedConfig, ConfigChangeReason.UNKNOWN);
                }
            }
        });
    }

    public void refreshIfChangeInOtherTool() {
        if (this.isOn && this.otherToolChanged) {
            this.otherToolChanged = false;
            this.softRefresh();
        }
    }

    public boolean waitUntilRegenerated() {
        return this.codeManager.waitUntilRegenerated();
    }

    public boolean isGeneratingCode() {
        return this.codeManager.isGeneratingCode();
    }

    public boolean isCodeDirty() {
        return this.codeManager.isCodeDirty();
    }

    @Override
    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable String actionLabel, boolean setDirty) {
        try {
            this.profile.clearCache();
            this.profile.updateStorageAvailability();
            this.requestRegenerateCode();
            ISharedConfiguration currentSharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
            if (this.isOn && this.isMcuSupported() && eventOriginator != currentSharedConfig) {
                currentSharedConfig.getTools().setPeripherals(this.profile.getStoragePeripheralsTool());
                if (setDirty) {
                    this.setDirty(currentSharedConfig, actionLabel);
                }
            }
            UIJobHelper.runNowOrInJob(() -> {
                this.updateValidationParams();
                this.fireListeners(new ToolEvent.Builder(eventType).setOriginator(eventOriginator).build());
            }, (String)"Handling changes", (Display)this.display);
        }
        catch (ExpressionException exception) {
            exception.log();
        }
    }

    public void fireListeners(Collection<ToolEvent> events) {
        UIJobHelper.runNowOrInJob(() -> super.fireListeners(events), (String)"Firing event", (Display)this.display);
    }

    void setDirty(ISharedConfiguration currentSharedConfig, @Nullable String actionLabel) {
        this.setDirty(currentSharedConfig, "Peripherals", this.functionalGroup.getStorageFuncGroup(), actionLabel, IConfigChangeContext.ConfigChangeType.TOOL_SETTING_CHANGE);
    }

    private void addDefaultFunctionalGroup(ISharedConfiguration sharedConfig) {
        FunctionalGroup functionalGroupLoc = Controller.createFunctionalGroup(this.profile.getChildContext(), this.profile.getMcu());
        functionalGroupLoc.setCalledFromDefaultInit(true);
        if (!functionalGroupLoc.setCoreFrom(sharedConfig.getCommonConfig())) {
            functionalGroupLoc.setMasterCoreAsUsed();
        }
        this.profile.addFunctionalGroup(functionalGroupLoc);
    }

    private void addSystemComponent() {
        ConfigurationComponentTypeId systemComp;
        if (this.isMcuSupported() && (systemComp = this.getMcu().getSystemComponent()) != null) {
            this.profile.addComponent(new ComponentConfig(systemComp, this.profile.getChildContext(), this.mcu));
        }
    }

    protected void reloadFromSharedConfig(ISharedConfiguration sharedConfig) {
        FunctionalGroup matchingNameGroup;
        this.profile = this.loadProfileFromSharedConfig(sharedConfig);
        this.mcu = this.profile.getMcu();
        if (this.profile.getFunctionalGroups().isEmpty()) {
            this.addDefaultFunctionalGroup(sharedConfig);
        }
        this.functionalGroup = (matchingNameGroup = this.profile.getFunctionalGroup(this.functionalGroup.getName())) != null ? matchingNameGroup : (FunctionalGroup)this.profile.getFunctionalGroups().get(0);
        if (this.profile.getComponent("system") == null) {
            this.addSystemComponent();
        }
        this.isOn = this.profile.getStoragePeripheralsTool().isEnabled();
        if (!this.isOn) {
            this.disablePeripheralsTool();
        }
        this.handleSettingChange(1, sharedConfig, null);
    }

    protected void disablePeripheralsTool() {
        EmptyMcu mcuLoc = new EmptyMcu(UtilsText.safeString((String)Messages.get().Controller_ToolDisabled));
        PeriphsProfile profileLoc = new PeriphsProfile((IMcu)mcuLoc, SharedConfigurationFactory.createSharedConfiguration());
        FunctionalGroup disabledFunctionalGroup = Controller.createFunctionalGroup(profileLoc.getChildContext(), (IMcu)mcuLoc);
        profileLoc.addFunctionalGroup(disabledFunctionalGroup);
        this.setMcu((IMcu)mcuLoc);
        this.setProfile(profileLoc);
        this.functionalGroup = disabledFunctionalGroup;
    }

    private PeriphsProfile loadProfileFromSharedConfig(ISharedConfiguration sharedConfig) {
        StoragePeriphsTool storagePeripheralsTool = sharedConfig.getTools().getPeripherals();
        IMcu profileMcu = this.getMcuFromSharedConfig(sharedConfig);
        if (storagePeripheralsTool != null && storagePeripheralsTool.isEnabled() && Controller.isMcuSupported(profileMcu)) {
            return new PeriphsProfile(profileMcu, storagePeripheralsTool, sharedConfig);
        }
        PeriphsProfile profileLoc = new PeriphsProfile(profileMcu, sharedConfig);
        if (storagePeripheralsTool != null && !storagePeripheralsTool.isEnabled()) {
            profileLoc.getStoragePeripheralsTool().setEnabled(false);
        }
        if (storagePeripheralsTool == null && Controller.isMcuSupported(profileMcu)) {
            sharedConfig.getTools().setPeripherals(profileLoc.getStoragePeripheralsTool());
        }
        return profileLoc;
    }

    public void requestRegenerateCode() {
        this.codeManager.requestRegenerateCode();
    }

    public void changeMode(String componentType, String componentName, String uiName, Object caller) {
        try {
            Mode mode;
            ComponentInstanceConfig componentInstanceConfig = this.getComponentSetting(componentType, componentName);
            if (componentInstanceConfig != null && (mode = Controller.getMode(componentInstanceConfig, uiName)) != null) {
                componentInstanceConfig.changeMode(mode);
                if (mode.getMasterPeripheral() == null) {
                    componentInstanceConfig.setPeripheral(null);
                }
                this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_ChangeMode));
            }
        }
        catch (ExpressionException ex) {
            ex.log();
        }
    }

    public void setPeripheral(String componentType, String componentName, String peripheral, Object caller) {
        ComponentInstanceConfig component = this.getComponentSetting(componentType, componentName);
        if (component != null) {
            component.setPeripheral(peripheral);
            this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_ChangePeripheral));
        }
    }

    private static @Nullable Mode getMode(ComponentInstanceConfig componentInstanceConfig, String uiName) {
        for (Mode mode : componentInstanceConfig.getComponent().getScenarios()) {
            if (!uiName.equals(mode.getUIName((IContext)componentInstanceConfig.getExpressionContext()))) continue;
            return mode;
        }
        return null;
    }

    public void setFunctionalGroup(FunctionalGroup functionalGroup, Object caller) {
        this.setFunctionalGroup(functionalGroup, true, caller);
    }

    public void setFunctionalGroup(FunctionalGroup functionalGroup, boolean fireEvent, Object caller) {
        if (!this.profile.getFunctionalGroups().contains(functionalGroup)) {
            LOGGER.severe("Trying to set active configuration which is not in the active profile");
        } else {
            this.functionalGroup = functionalGroup;
            if (fireEvent) {
                this.fireListeners(new ToolEvent.Builder(1).setOriginator(caller).build());
            }
        }
    }

    public void setFunctionalGroupProperties(FunctionalGroup group, String name, String description, String idPrefix, boolean calledFromDefaultInit, String selectedCore, Object caller) {
        Runnable setDetailsFunction = () -> {
            group.setName(name);
            group.setDescription(description);
            group.setIdPrefix(idPrefix);
            group.setCore(selectedCore);
            this.setCalledFromDefaultInit(group, calledFromDefaultInit, caller);
        };
        this.runTransaction(setDetailsFunction);
    }

    public FunctionalGroup addFunctionalGroup(String name, String description, String idPrefix, boolean calledFromDefaultInit, String selectedCore, Object caller) {
        return this.addFunctionalGroup(name, description, idPrefix, calledFromDefaultInit, selectedCore, true, caller);
    }

    public FunctionalGroup addFunctionalGroup(String name, String description, String idPrefix, boolean calledFromDefaultInit, String selectedCore, boolean handleChanges, Object caller) {
        Supplier<FunctionalGroup> addFunctionalGroupFunction = () -> {
            FunctionalGroup newGroup = Controller.createFunctionalGroup(this.profile.getChildContext(), this.profile.getMcu());
            newGroup.setName(name);
            newGroup.setDescription(description);
            newGroup.setIdPrefix(idPrefix);
            newGroup.setCore(selectedCore);
            this.profile.addFunctionalGroup(newGroup);
            if (handleChanges) {
                this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_AddFunctionalGroup));
            }
            this.setCalledFromDefaultInit(newGroup, calledFromDefaultInit, handleChanges, caller);
            this.setFunctionalGroup(newGroup, handleChanges, caller);
            return newGroup;
        };
        FunctionalGroup result = (FunctionalGroup)this.runTransaction(addFunctionalGroupFunction).get();
        assert (result != null);
        return result;
    }

    public boolean isFunctionalGroupsLimitReached() {
        return this.profile.getFunctionalGroups().size() >= 20;
    }

    public boolean removeFunctionalGroup(FunctionalGroup group, Object caller) {
        int oldIdx = this.profile.getFunctionalGroups().indexOf(group);
        if (oldIdx >= 0 && this.profile.getFunctionalGroups().size() <= 1) {
            throw new IllegalStateException(MessageFormat.format("Cannot remove the {0} functional group. Minimal number of functional groups in profile is: 1", group.getName()));
        }
        boolean result = this.profile.removeFunctionalGroup(group);
        if (result) {
            if (group == this.functionalGroup) {
                int newIdx = oldIdx;
                if (this.profile.getFunctionalGroups().size() >= newIdx) {
                    newIdx = this.profile.getFunctionalGroups().size() - 1;
                }
                if (newIdx < 0) {
                    newIdx = 0;
                }
                this.functionalGroup = (FunctionalGroup)this.profile.getFunctionalGroups().get(newIdx);
            }
            this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_RemoveFunctionalGroup));
        }
        return result;
    }

    public @Nullable ScriptResult getGeneratedCode() {
        return this.codeManager.getGeneratedCode();
    }

    public @Nullable ScriptResult waitAndGetGeneratedCode() {
        if (this.waitUntilRegenerated()) {
            return this.codeManager.getGeneratedCode();
        }
        return null;
    }

    public AExportWizard.GenerationResult waitAndGetGenerationResult(String coreId) {
        this.codeManager.waitUntilRegenerated();
        return this.getGenerationResult(coreId);
    }

    public AExportWizard.GenerationResult getGenerationResult(String coreId) {
        ScriptResult scriptResult = this.getGeneratedCode();
        String error = this.getToolError();
        if (error != null) {
            return AExportWizard.GenerationResult.fail((String)error);
        }
        if (scriptResult == null || scriptResult.isFailed()) {
            return AExportWizard.GenerationResult.fail((String)Messages.get().Controller_SourcesGeneration_CannotGenerateDueToInternalError);
        }
        return AExportWizard.GenerationResult.success((Map)CollectionsUtils.safeMap((Map)scriptResult.getOpenedFiles(coreId)));
    }

    public static Controller getInstance() {
        try {
            Controller controller = (Controller)((Object)SWTFactoryProxy.INSTANCE.getSingletonInstance(Controller.class));
            if (controller.disposed) {
                throw new IllegalStateException("Controller is disposed");
            }
            return controller;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain instance of a controller", e);
        }
    }

    public @Nullable ComponentInstanceConfig getComponentSetting(String type, String name) {
        return this.functionalGroup.getComponentInstance(type, name);
    }

    public void dispose() {
        this.disposed = true;
    }

    public void setMcu(IMcu mcu) {
        this.mcu = mcu;
    }

    @Override
    public List<ConfigurationComponentTypeId> getComponentsOfPeripheral(String peripheralInstance) {
        String peripheralType = this.mcu.getPeripheralType(peripheralInstance);
        ExpressionContext context = new ExpressionContext(this.functionalGroup.getChildContext().createForChild((IChild)this.functionalGroup), this.mcu);
        try {
            return (List)this.mcu.getAvailableComponents().getConfigCompTypeIds().stream().filter(x -> !x.getConfigurationComponent().isGlobalOnly()).filter(x -> x.getConfigurationComponent().getScenarios().stream().filter(y -> y.isAvailable((IContext)context)).map(y -> y.getMasterPeripheral()).filter(Objects::nonNull).flatMap(u -> {
                assert (u != null);
                return u.getPeripherals().stream();
            }).anyMatch(w -> w.equals(peripheralType))).collect(CollectorsUtils.toList());
        }
        catch (ExpressionException ex) {
            ex.log();
            return new ArrayList<ConfigurationComponentTypeId>();
        }
    }

    public List<String> getPeripherals(String type) {
        return this.mcu.getPeripherals(type);
    }

    public List<String> getConfigSets(String component, String mode) {
        ArrayList<String> refs = new ArrayList<String>();
        ConfigurationComponent configurationComponent = this.getConfigurationComponent(component);
        if (configurationComponent != null) {
            try {
                configurationComponent.getScenarios().stream().filter(x -> mode.equals(x.getUIName(this.profile.getExpressionContext()))).forEach(y -> {
                    boolean bl = refs.addAll(y.getConfigSetRefs());
                });
            }
            catch (ExpressionException ex) {
                ex.log();
            }
        }
        return refs;
    }

    public List<String> getModes(String component) {
        HashSet modes = new HashSet();
        ConfigurationComponent configurationComponent = this.getConfigurationComponent(component);
        if (configurationComponent != null) {
            try {
                configurationComponent.getScenarios().forEach(y -> {
                    boolean bl = modes.add(y.getUIName(this.profile.getExpressionContext()));
                });
            }
            catch (ExpressionException ex) {
                ex.log();
            }
        }
        return new ArrayList<String>(modes);
    }

    public List<String> getPeripherals() {
        return this.mcu.getPeripherals();
    }

    @Override
    public List<String> getActiveCorePeripherals() {
        return this.filterPeripheralsForCore(this.functionalGroup.getCore(), this.mcu.getPeripherals());
    }

    @Override
    public List<String> filterPeripheralsForCore(String core, Collection<String> peripherals) {
        return (List)peripherals.stream().filter(name -> this.mcu.isPeripheralAvailableForCore(core, name)).collect(CollectorsUtils.toList());
    }

    public void setProfile(PeriphsProfile profile) {
        this.profile = profile;
    }

    public @Nullable ComponentConfig createOrGetComponent(String compTypeId, Object caller) {
        ConfigurationComponentTypeId configCompTypeId = this.mcu.getAvailableComponents().getConfigCompTypeId(compTypeId);
        if (configCompTypeId == null) {
            throw new IllegalArgumentException("Component with type id: " + compTypeId + " does not exist");
        }
        ConfigurationComponent configComp = configCompTypeId.getConfigurationComponent();
        ComponentConfig component = this.profile.getComponent(configComp.getId());
        if (component != null) {
            if (!component.getComponentTypeId().equals(configCompTypeId.getTypeId())) {
                LOGGER.severe("Component with type id: " + compTypeId + " cannot be added to the profile because there already is another component with the same type");
            }
            return component;
        }
        component = new ComponentConfig(configCompTypeId, this.profile.getChildContext(), this.mcu);
        this.profile.addComponent(component);
        this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_CreateComponent));
        return component;
    }

    public @Nullable ComponentInstanceConfig createComponentInstance(String compTypeId, @Nullable String usingPeripheral, Object caller) {
        return this.createComponentInstance(compTypeId, usingPeripheral, this.functionalGroup.getName(), caller);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable ComponentInstanceConfig createComponentInstance(String compTypeId, @Nullable String usingPeripheral, String group, Object caller) {
        Supplier<@Nullable ComponentInstanceConfig> instanceCreationFunction = () -> {
            ConfigurationComponent configComp;
            @Nullable ConfigurationComponentTypeId configCompTypeId = this.mcu.getAvailableComponents().getConfigCompTypeId(compTypeId);
            ConfigurationComponent configurationComponent = configComp = configCompTypeId == null ? null : configCompTypeId.getConfigurationComponent();
            if (configComp == null || configComp.isGlobalOnly()) {
                LOGGER.severe("Component with type id: " + compTypeId + " does not exist or is global only and cannot be instantiated");
                return null;
            }
            ComponentConfig component = this.createOrGetComponent(compTypeId, caller);
            FunctionalGroup funcGroup = this.profile.getFunctionalGroup(group);
            if (component == null || funcGroup == null) {
                return null;
            }
            String name = this.createInstanceName(configComp.getLabel(component.getExpressionContext()), funcGroup);
            List<Mode> availableModes = this.getAvailableModes(configComp, funcGroup);
            Mode firstUsableMode = this.getFirstUsableMode(funcGroup, availableModes, usingPeripheral);
            Mode modeToSelect = availableModes.isEmpty() ? null : (firstUsableMode != null ? firstUsableMode : availableModes.get(0));
            String peripheralToUse = null;
            if (modeToSelect != null) {
                if (usingPeripheral == null) {
                    List<String> availablePeripherals = this.getAvailablePeripherals(funcGroup, modeToSelect);
                    List<String> usablePeripherals = this.getUsablePeripherals(funcGroup, modeToSelect);
                    peripheralToUse = availablePeripherals.isEmpty() ? (usablePeripherals.isEmpty() ? null : usablePeripherals.get(0)) : availablePeripherals.get(0);
                } else {
                    MasterPeripheral masterPeripheral = modeToSelect.getMasterPeripheral();
                    if (masterPeripheral != null && masterPeripheral.getPeripherals().stream().anyMatch(x -> this.getPeripherals((String)x).contains(usingPeripheral))) {
                        peripheralToUse = usingPeripheral;
                    }
                }
            }
            if (modeToSelect == null) {
                LOGGER.severe("The component has no available mode for the current MCU");
                return null;
            }
            if (peripheralToUse == null && modeToSelect.getMasterPeripheral() != null) {
                LOGGER.severe("There is no peripheral that can be used to create component instance");
                return null;
            }
            ComponentInstanceConfig componentSetting = new ComponentInstanceConfig(component.getComponent(), funcGroup, name, modeToSelect, peripheralToUse, component.getChildContext(), this.mcu);
            funcGroup.addInstance(componentSetting);
            this.handleSettingChange(1, Controller.class, UtilsText.safeString((String)Messages.get().Controller_Action_CreateComponentInstance));
            return componentSetting;
        };
        ComponentInstanceConfig result = (ComponentInstanceConfig)CollectionsUtils.nullableOptionalGet((Optional)this.runTransaction(instanceCreationFunction));
        return result;
    }

    private List<Mode> getAvailableModes(ConfigurationComponent configComp, FunctionalGroup funcGroup) {
        try {
            ExpressionContext ctx = new ExpressionContext(funcGroup.getChildContext().createForChild((IChild)funcGroup), this.mcu);
            List availableModes = (List)configComp.getScenarios().stream().filter(m -> m.isAvailable((IContext)ctx)).collect(CollectorsUtils.toList());
            return availableModes;
        }
        catch (ExpressionException ex) {
            ex.log();
            return new ArrayList<Mode>();
        }
    }

    private @Nullable Mode getFirstUsableMode(FunctionalGroup funcGroup, List<Mode> availableModes, @Nullable String peripheral) {
        for (Mode mode : availableModes) {
            if (mode.getMasterPeripheral() == null) {
                return mode;
            }
            List<String> availablePeripherals = this.getAvailablePeripherals(funcGroup, mode);
            if (!(peripheral == null ? !availablePeripherals.isEmpty() : availablePeripherals.contains(peripheral))) continue;
            return mode;
        }
        return null;
    }

    @Override
    public boolean isAnyPeripheralAvailable(String funcGroupName, ConfigurationComponent configComp) {
        FunctionalGroup funcGroup = this.profile.getFunctionalGroup(funcGroupName);
        if (funcGroup == null) {
            return false;
        }
        for (Mode mode : configComp.getScenarios()) {
            List<String> availablePeripherals = this.getAvailablePeripherals(funcGroup, mode);
            if (availablePeripherals.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getAvailablePeripherals(FunctionalGroup funcGroup, ConfigurationComponent configComp) {
        HashSet<String> availablePeripherals = new HashSet<String>();
        for (Mode mode : configComp.getScenarios()) {
            List<String> availableModePeripherals = this.getAvailablePeripherals(funcGroup, mode);
            if (availableModePeripherals.isEmpty()) continue;
            availablePeripherals.addAll(availableModePeripherals);
        }
        return availablePeripherals;
    }

    @Override
    protected List<String> getAvailablePeripherals(FunctionalGroup funcGroup, Mode mode) {
        List<String> usablePeripherals = this.getUsablePeripherals(funcGroup, mode);
        ArrayList<String> availablePeripherals = new ArrayList<String>();
        for (String peripheral : usablePeripherals) {
            if (!funcGroup.isPeripheralUsed(peripheral)) {
                availablePeripherals.add(peripheral);
                continue;
            }
            MasterPeripheral masterPeripheral = mode.getMasterPeripheral();
            if (masterPeripheral == null || masterPeripheral.isExclusive()) continue;
            boolean isExclusive = false;
            for (ComponentInstanceConfig component : this.getComponentInstanceConfigs(peripheral)) {
                if (!component.isPeripheralUsedExlusively(peripheral)) continue;
                isExclusive = true;
            }
            if (isExclusive) continue;
            availablePeripherals.add(peripheral);
        }
        return availablePeripherals;
    }

    @Override
    public Collection<String> getUsablePeripherals(FunctionalGroup funcGroup, ConfigurationComponent configurationComponent) {
        LinkedHashSet<String> peripherals = new LinkedHashSet<String>();
        for (Mode mode : configurationComponent.getScenarios()) {
            List<String> usablePeripherals = this.getUsablePeripherals(funcGroup, mode);
            peripherals.addAll(usablePeripherals);
        }
        return peripherals;
    }

    private List<String> getUsablePeripherals(FunctionalGroup funcGroup, Mode mode) {
        MasterPeripheral masterPeripheral;
        ExpressionContext ctx = new ExpressionContext(funcGroup.getChildContext().createForChild((IChild)funcGroup), this.mcu);
        if (mode.isAvailable((IContext)ctx) && (masterPeripheral = mode.getMasterPeripheral()) != null) {
            return (List)masterPeripheral.getPeripherals().stream().flatMap(x -> this.getPeripherals((String)x).stream()).collect(CollectorsUtils.toList());
        }
        return new ArrayList<String>();
    }

    public boolean isInstancesLimitReached(String group) {
        FunctionalGroup funcGroup = this.profile.getFunctionalGroup(group);
        return funcGroup != null && funcGroup.getInstances().size() >= 100;
    }

    public boolean isInstancesLimitReached() {
        return this.isInstancesLimitReached(this.functionalGroup.getName());
    }

    public String createInstanceName(String componentType, FunctionalGroup group) {
        return UtilsText.createUniqueName((String)componentType, this.getUsedNamesInGroupsWithSamePrefix(group.getIdPrefix()), (boolean)true);
    }

    @Override
    public Collection<String> getUsedNamesInGroupsWithSamePrefix(String prefix) {
        HashSet<String> usedNames = new HashSet<String>();
        ArrayList groupsWithPrefix = this.getProfile().getFunctionalGroupsWithPrefix(prefix);
        groupsWithPrefix.forEach(g -> {
            boolean bl = usedNames.addAll((Collection)g.getInstances().keySet().stream().filter(name -> name != null).collect(CollectorsUtils.toList()));
        });
        return usedNames;
    }

    public boolean renameComponentInstance(ComponentInstanceConfig componentInstanceConfig, String newName, Object caller) {
        if (componentInstanceConfig.getUiName().equals(newName)) {
            return false;
        }
        if (!componentInstanceConfig.getUiName().equalsIgnoreCase(newName) && !this.isNameUsable(newName)) {
            return false;
        }
        this.functionalGroup.renameInstance(componentInstanceConfig.getName(), newName);
        this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_RenameComponent));
        return true;
    }

    public boolean isNameUsable(String name) {
        return Controller.isNameValid(name) && this.isNameUnique(this.functionalGroup.createIdentifier(name));
    }

    public static boolean isNameValid(String name) {
        return UtilsText.isIdentifier((CharSequence)name);
    }

    private boolean isNameUnique(String name) {
        return this.getProfile().countSameIdentifierOccurences(this.functionalGroup.getIdPrefix(), name) == 0;
    }

    public boolean removeComponents(Collection<String> components, Object caller) {
        boolean wasRemoved = false;
        for (String component : components) {
            wasRemoved |= this.profile.removeComponent(component);
            for (FunctionalGroup group : this.profile.getFunctionalGroups()) {
                wasRemoved |= group.removeAllInstances(component);
            }
        }
        if (wasRemoved) {
            this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_RemoveComponent));
        }
        return wasRemoved;
    }

    public boolean removeComponentInstances(CollectionMap<String, String> instances, Object caller) {
        Supplier<Boolean> removeInstancesFunction = () -> {
            boolean anyRemoved = false;
            for (Map.Entry entry : instances.entrySet()) {
                String component = (String)entry.getKey();
                ComponentConfig componentConfig = this.getConfiguredComponent(component);
                if (componentConfig == null) continue;
                Collection instancesCollection = (Collection)entry.getValue();
                anyRemoved |= this.removeComponentInstances(instancesCollection, false, caller);
            }
            if (anyRemoved) {
                this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_RemoveComponentInstance));
            }
            return anyRemoved;
        };
        Boolean result = (Boolean)CollectionsUtils.nullableOptionalGet((Optional)this.runTransaction(removeInstancesFunction));
        if (result != null) {
            return result;
        }
        return false;
    }

    public boolean removeComponentInstances(Collection<String> instances, boolean update, Object caller) {
        boolean anyRemoved = false;
        for (String instance : instances) {
            anyRemoved |= this.functionalGroup.removeInstance(UtilsText.safeString((String)instance));
        }
        if (anyRemoved && update) {
            this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_RemoveComponentInstance));
        }
        return anyRemoved;
    }

    @Override
    public void reloadFromSharedConfig() {
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        this.reloadFromSharedConfig(sharedConfig);
    }

    public void refresh() {
        SdkFeaturesProvider.flushCache();
        this.mcu = new EmptyMcu("Clearing cache");
        this.reloadFromSharedConfig();
    }

    public void softRefresh() {
        this.handleSettingChange(1, (Object)this, null, false);
    }

    public String createUniqueFuncGroupName(String namePrefix) {
        return UtilsText.createUniqueName((String)namePrefix, this.profile.getFunctionalGroups().stream().map(x -> x.getName()), (boolean)false);
    }

    public boolean hasGlobalConfigSet(String componentType) {
        ConfigSetConfig globalConfigSet;
        ComponentConfig componentConfig = this.getConfiguredComponent(componentType);
        return componentConfig != null && (globalConfigSet = componentConfig.getGlobalConfigSet()) != null;
    }

    public void setCalledFromDefaultInit(FunctionalGroup group, boolean called, Object caller) {
        this.setCalledFromDefaultInit(group, called, true, caller);
    }

    public void setCalledFromDefaultInit(FunctionalGroup group, boolean called, boolean handleChanges, Object caller) {
        if (!this.profile.getFunctionalGroups().contains(group)) {
            throw new IllegalStateException("Functional group must be from the active profile");
        }
        if (this.isMcuSupported()) {
            if (called) {
                this.profile.getFunctionalGroups().forEach(x -> x.setCalledFromDefaultInit(false));
                group.setCalledFromDefaultInit(true);
            } else {
                group.setCalledFromDefaultInit(false);
            }
            if (handleChanges) {
                this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_SetCalledFromDefaultInit));
            }
        }
    }

    void updateValidationParams() {
        LinkedHashSet<GenericProblem> allProblems = new LinkedHashSet<GenericProblem>();
        if (this.isOn) {
            PeripheralsGenericProblem unsupportedMcuProblem = this.getUnsupportedMcuProblem();
            if (unsupportedMcuProblem != null) {
                allProblems.add(unsupportedMcuProblem);
            } else {
                allProblems.addAll(this.collectLocalProblems());
                allProblems.addAll(this.collectGlobalProblems());
                allProblems.addAll(this.collectScriptProblems());
            }
        }
        ValidationEngineFactory.addAndRemoveProblems((String)"Peripherals", null, allProblems);
    }

    private Collection<GenericProblem> collectGlobalProblems() {
        ValidationParams globalParams = new ValidationParams(this.profile.getConfiguredComponents().values(), Controller.makeDependencySourceName(null));
        StoragePeriphsTool periphs = SharedConfigurationFactory.getSharedConfigurationSingleton().getTools().getPeripherals();
        if (periphs != null) {
            List<IDependency> globalDeps = periphs.getGlobalDependencies();
            if (globalDeps == null) {
                globalDeps = new ArrayList<IDependency>();
            }
            globalDeps = Controller.removeToolDependencies((Collection<IDependency>)globalDeps);
            globalDeps.addAll(globalParams.getDependencies());
            ArrayList<StorageDependency> componentDeps = new ArrayList<StorageDependency>();
            for (ComponentConfig config : this.profile.getConfiguredComponents().values()) {
                if (!config.getComponent().isGlobalOnly() && !this.hasAtLeastOneInstanceEnabled(config)) continue;
                for (SWComponent component : config.getComponent().getComponents()) {
                    String configName = null;
                    StorageDependencyFeature fEnabled = new StorageDependencyFeature();
                    fEnabled.setName("enabled");
                    fEnabled.setEvaluation("equal");
                    fEnabled.setConfiguration(configName);
                    fEnabled.addData(Boolean.TRUE.toString(), "Boolean", null, null, null);
                    componentDeps.add(Controller.createSwComponentDependency(component, fEnabled, 2, MessageFormat.format(UtilsText.safeString((String)Messages.get().Controller_ProblemComponentMissing), this.getSdkComponentName(component)), configName));
                    Version version = component.getVersion();
                    if (version == null) continue;
                    StorageDependencyFeature fVersion = new StorageDependencyFeature();
                    fVersion.setName("version");
                    fVersion.setEvaluation("equivalent");
                    fVersion.setConfiguration(configName);
                    fVersion.addData(component.getVersionStr(), "Version", null, null, null);
                    componentDeps.add(Controller.createSwComponentDependency(component, fVersion, 1, MessageFormat.format(UtilsText.safeString((String)Messages.get().Controller_ProblemComponentVersionMismatch), this.getSdkComponentName(component)), configName));
                }
            }
            globalDeps.addAll(componentDeps);
            if (globalDeps.isEmpty()) {
                globalDeps = null;
            }
            periphs.setGlobalDependencies(globalDeps);
        }
        return globalParams.getProblems();
    }

    private boolean hasAtLeastOneInstanceEnabled(ComponentConfig config) {
        return !this.getAllEnabledComponentInstances(config.getComponentTypeId()).isEmpty();
    }

    private static StorageDependency createSwComponentDependency(SWComponent component, StorageDependencyFeature feature, int problemLevel, String description, @Nullable String configName) {
        StorageDependency dep = new StorageDependency();
        dep.setDependencyCreator(DependencyCreator.TOOL);
        dep.setDescription(description);
        ArrayList<StorageDependencyFeature> depFeatures = new ArrayList<StorageDependencyFeature>();
        dep.setFeatures(depFeatures);
        depFeatures.add(feature);
        dep.setProblemLevel(problemLevel);
        dep.setResourceId(component.getName());
        dep.setResourceType("SWComponent");
        dep.setSource(Controller.makeDependencySourceName(configName));
        return dep;
    }

    private Collection<GenericProblem> collectLocalProblems() {
        ArrayList<GenericProblem> localProbs = new ArrayList<GenericProblem>();
        boolean calledFromDefaultInit = false;
        for (FunctionalGroup group : this.profile.getFunctionalGroups()) {
            calledFromDefaultInit |= group.isCalledFromDefaultInit();
            ValidationParams params = new ValidationParams((IChildProvidable)group, Controller.makeDependencySourceName(group.getId()));
            StoragePeriphsFuncGroup funcGroup = group.getStorageFuncGroup();
            List<IDependency> localDeps = funcGroup.getDependencies();
            localDeps = Controller.removeToolDependencies((Collection<IDependency>)localDeps);
            localDeps.addAll(params.getDependencies());
            funcGroup.setDependencies(localDeps);
            localProbs.addAll(params.getProblems());
        }
        if (!calledFromDefaultInit) {
            localProbs.add(new PeripheralsGenericProblem("Peripherals", PeripheralsGenericProblem.Type.NO_DEFAULT_INIT_GROUP, UtilsText.safeString((String)Messages.get().Controller_NoDefaultInitializationGroup)));
        }
        return localProbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<GenericProblem> collectScriptProblems() {
        ArrayList<GenericProblem> scriptProblems = new ArrayList<GenericProblem>();
        ScriptResult generationResult = null;
        PeripheralsCodeManager peripheralsCodeManager = this.codeManager;
        synchronized (peripheralsCodeManager) {
            if (this.codeManager.isGeneratingCode()) {
                return scriptProblems;
            }
            generationResult = this.codeManager.getGeneratedCode();
        }
        String resource = "Sources";
        if (generationResult == null || generationResult.isFailed()) {
            String errorMessage = UtilsText.safeString((String)Messages.get().Controller_SourcesGeneration_CannotGenerateDueToInternalError);
            scriptProblems.add(new GenericProblem("Peripherals", 2, errorMessage, Controller.makeDependencySourceName(null), resource, errorMessage));
        } else {
            int n;
            int n2;
            String[] stringArray;
            if (!UtilsText.isEmpty((String)generationResult.getErrors())) {
                String[] errors;
                stringArray = errors = generationResult.getErrors().split("\n");
                n2 = errors.length;
                n = 0;
                while (n < n2) {
                    String error = stringArray[n];
                    if (error != null && !error.isEmpty()) {
                        scriptProblems.add(new GenericProblem("Peripherals", 2, error, Controller.makeDependencySourceName(null), resource, error));
                    }
                    ++n;
                }
            }
            if (!UtilsText.isEmpty((String)generationResult.getWarnings())) {
                String[] warnings;
                stringArray = warnings = generationResult.getWarnings().split("\n");
                n2 = warnings.length;
                n = 0;
                while (n < n2) {
                    String warning = stringArray[n];
                    if (warning != null && !warning.isEmpty()) {
                        scriptProblems.add(new GenericProblem("Peripherals", 1, warning, Controller.makeDependencySourceName(null), resource, warning));
                    }
                    ++n;
                }
            }
        }
        return scriptProblems;
    }

    private String getSdkComponentName(SWComponent swComp) {
        return this.mcu.getAvailableComponents().getSdkComponentName(swComp.getName());
    }

    private static List<IDependency> removeToolDependencies(Collection<IDependency> dependencies) {
        return (List)dependencies.stream().filter(d -> !d.getSource().startsWith("Peripherals") && DependencyCreator.TOOL != d.getDependencyCreator()).collect(CollectorsUtils.toList());
    }

    private static String makeDependencySourceName(@Nullable String configName) {
        if (UtilsText.isEmpty((String)configName)) {
            return "Peripherals";
        }
        return "Peripherals:" + configName;
    }

    @Override
    public boolean isMcuSupported(IMcuIdentification mcuId) {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcuId.getMcu(), mcuId.getSdkVersion());
        if (info != null) {
            if (SupportedToolsByProcessor.isToolDisabled((IProcessorMasterToolInfo)info, (String)"Peripherals")) {
                return false;
            }
        } else {
            LOGGER.severe("Cannot get IProcessorMasterToolInfo for " + mcuId.toString());
        }
        return DataDirectory.isPeripheralsComponentsDirDefined((IMcuIdentification)mcuId);
    }

    public @Nullable String getUnsupportedMcuError() {
        PeripheralsGenericProblem problem = this.getUnsupportedMcuProblem();
        return problem == null ? null : problem.getMessage();
    }

    public @Nullable String getToolError() {
        if (this.isOn) {
            return this.getUnsupportedMcuError();
        }
        return null;
    }

    public List<ComponentInstanceConfig> getAllComponentInstances(String componentType) {
        return (List)this.profile.getAllInstances().stream().filter(ci -> ci.getComponent().getId().equals(componentType)).collect(CollectorsUtils.toList());
    }

    public List<ComponentInstanceConfig> getAllEnabledComponentInstances(String componentTypeId) {
        return (List)this.profile.getAllInstances().stream().filter(ci -> ci.getComponentTypeId().equals(componentTypeId) && ci.isEnabled()).collect(CollectorsUtils.toList());
    }

    public boolean isTurnedOn() {
        return this.isOn;
    }

    private @Nullable PeripheralsGenericProblem getUnsupportedMcuProblem() {
        if (!Controller.isMcuSupported(this.mcu) && this.isOn) {
            String toolId = "Peripherals";
            return new PeripheralsGenericProblem(toolId, PeripheralsGenericProblem.Type.MCU_UNSUPPORTED, ((EmptyMcu)this.mcu).getReason());
        }
        return null;
    }

    public void resetToProcessorDefault(FunctionalGroup functionalGroupLoc) {
        functionalGroupLoc.setConfiguredComponents(new HashMap());
        this.handleSettingChange(1, (Object)this, UtilsText.safeString((String)Messages.get().Controller_Action_ResetToProcessorDefaults));
    }

    public void resetToStorageFuncGroup(List<StoragePeriphsFuncGroup> functions, String selectedConfiguration, StoragePeriphsFuncGroup changedFuncGroup) {
        StoragePeriphsFuncGroup boardFuncGroup = null;
        for (StoragePeriphsFuncGroup storageFuncGroup : functions) {
            if (!Objects.equals(storageFuncGroup.getConfigurationName(), selectedConfiguration)) continue;
            boardFuncGroup = storageFuncGroup;
            break;
        }
        if (boardFuncGroup != null) {
            changedFuncGroup.fillWithValues(boardFuncGroup);
            int initCounter = 0;
            for (StoragePeriphsFuncGroup storageFuncGroup : this.profile.getStoragePeripheralsTool().getFuncGroups()) {
                if (!storageFuncGroup.isCalledFromInit()) continue;
                ++initCounter;
            }
            if (initCounter > 1) {
                changedFuncGroup.setCalledFromInit(false);
            }
            this.reloadFromSharedConfig();
        }
    }

    @Override
    public boolean hasModeWithMasterPeripheralNotDefined(ConfigurationComponent configurationComponent, String funcGroupName) {
        FunctionalGroup funcGroup = this.profile.getFunctionalGroup(funcGroupName);
        if (funcGroup != null) {
            return CollectionsUtils.containsNullValue(this.getAvailableModes(configurationComponent, funcGroup).stream().map(m -> m.getMasterPeripheral()));
        }
        return false;
    }

    public void setSourceCodeRefreshManager(@Nullable PeripheralsSourceCodeRefreshHandler managerHandler) {
        this.codeRefreshManagerHandler = managerHandler;
    }

    public void removeSourceCodeRefreshManager() {
        this.codeRefreshManagerHandler = null;
    }

    public void refreshSourceCodeView() {
        IGeneratedFilesStatusProvider genFilesProvider;
        IToolchainProjectProvider toolchainProvider;
        IViewRefreshManager refreshManager;
        PeripheralsSourceCodeRefreshHandler codeRefreshManagerHandlerLoc = this.codeRefreshManagerHandler;
        if (codeRefreshManagerHandlerLoc != null && (refreshManager = codeRefreshManagerHandlerLoc.getRefreshManager()) != null) {
            refreshManager.refresh();
        }
        if ((toolchainProvider = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProjectProvider()) != null && (genFilesProvider = toolchainProvider.getGeneratedFilesStatusProvider()) != null) {
            genFilesProvider.requestUpdate();
        }
    }

    @Override
    public boolean canCopy(ISettingConfig setting) {
        return true;
    }
}

