/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.controller.AController;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.controller.Messages;
import com.nxp.swtools.periphs.controller.UiValueIdHolder;
import com.nxp.swtools.periphs.model.config.AStructuredSettingConfig;
import com.nxp.swtools.periphs.model.config.ArrayConfig;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ChildProviderHelper;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.config.IPresettable;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.config.ScalarConfig;
import com.nxp.swtools.periphs.model.config.SetConfig;
import com.nxp.swtools.periphs.model.config.StructConfig;
import com.nxp.swtools.periphs.model.data.Categories;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.periphs.model.data.Mode;
import com.nxp.swtools.periphs.model.data.QuickSelection;
import com.nxp.swtools.periphs.model.data.mcu.EmptyMcu;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.mcu.McuFactory;
import com.nxp.swtools.periphs.model.data.setting.SetSetting;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public abstract class APeriphController
extends AController {
    protected static final Logger LOGGER = LogManager.getLogger(APeriphController.class);
    protected FunctionalGroup functionalGroup;
    protected IMcu mcu;
    protected PeriphsProfile profile;
    @Nullable
    protected ISettingConfig clipboard = null;

    protected IMcu getMcuFromSharedConfig(ISharedConfiguration sharedConfig) {
        ICommonConfig commonConfig = sharedConfig.getCommonConfig();
        EmptyMcu mcuLoc = null;
        if (!commonConfig.getMcu().isEmpty()) {
            IMcu currentMcu = this.getMcu();
            if (Objects.nonNull(currentMcu) && commonConfig.getMcuIdentification().equals(currentMcu.getMcuIdentification()) && !SWToolsProperties.isVerificationOn() && !(currentMcu instanceof EmptyMcu)) {
                mcuLoc = currentMcu;
            } else if (this.isMcuSupported((IMcuIdentification)commonConfig)) {
                ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
                mcuLoc = McuFactory.create((ISupportedDerivativesForSwTools)derivatives, (ICommonConfig)commonConfig);
            }
        } else {
            mcuLoc = new EmptyMcu(UtilsText.safeString((String)Messages.get().Controller_McuNotSelectedMessage));
        }
        if (mcuLoc == null) {
            StoragePeriphsTool peripherals = sharedConfig.getTools().getPeripherals();
            mcuLoc = peripherals != null && peripherals.isEnabled() ? new EmptyMcu(UtilsText.safeString((String)Messages.get().Controller_McuNotSupportedAndToolEnabled)) : (SWToolsProperties.isVerificationOn() ? new EmptyMcu(UtilsText.safeString((String)Messages.get().Controller_CorruptedMcuData)) : new EmptyMcu(UtilsText.safeString((String)Messages.get().Controller_McuNotSupported)));
        }
        return mcuLoc;
    }

    protected List<String> getAvailablePeripherals(FunctionalGroup funcGroup, Mode mode) {
        return new ArrayList<String>();
    }

    public Collection<String> getAvailablePeripherals(FunctionalGroup funcGroup, ConfigurationComponent configComp) {
        return new ArrayList<String>();
    }

    public boolean hasModeWithMasterPeripheralNotDefined(ConfigurationComponent configurationComponent, String funcGroupName) {
        return false;
    }

    public boolean isAnyPeripheralAvailable(String funcGroupName, ConfigurationComponent configComp) {
        return false;
    }

    public Collection<String> getUsablePeripherals(FunctionalGroup funcGroup, ConfigurationComponent configurationComponent) {
        return new ArrayList<String>();
    }

    public List<String> filterPeripheralsForCore(String core, Collection<String> peripherals) {
        return new ArrayList<String>();
    }

    public List<ConfigurationComponentTypeId> getComponents() {
        return new ArrayList<ConfigurationComponentTypeId>(this.mcu.getAvailableComponents().getConfigCompTypeIds());
    }

    public @Nullable ComponentConfig getConfiguredComponent(String type) {
        return (ComponentConfig)this.profile.getConfiguredComponents().get(type);
    }

    public abstract boolean isMcuSupported(IMcuIdentification var1);

    protected APeriphController() {
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        this.mcu = this.getMcuFromSharedConfig(sharedConfig);
        this.profile = new PeriphsProfile(this.mcu, sharedConfig);
        this.functionalGroup = APeriphController.createFunctionalGroup(this.profile.getChildContext(), this.mcu);
    }

    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable String actionLabel) {
        this.handleSettingChange(eventType, eventOriginator, actionLabel, true);
    }

    protected abstract void handleSettingChange(int var1, @Nullable Object var2, @Nullable String var3, boolean var4);

    public FunctionalGroup getFunctionalGroup() {
        return this.functionalGroup;
    }

    public abstract void reloadFromSharedConfig();

    public Collection<String> getUsedNamesInGroupsWithSamePrefix(String prefix) {
        return new ArrayList<String>();
    }

    public @Nullable Categories getCategories() {
        return this.getMcu().getCategories();
    }

    public IMcu getMcu() {
        return this.mcu;
    }

    public PeriphsProfile getProfile() {
        return this.profile;
    }

    public void setComponentInstancesEnabled(Collection<ComponentInstanceConfig> configs, boolean enabled, Object caller) {
        configs.forEach(cic -> cic.setEnabled(enabled));
        String actionLabel = enabled ? Messages.get().Controller_Action_EnableComponentInstance : Messages.get().Controller_Action_DisableComponentInstance;
        this.handleSettingChange(1, caller, actionLabel);
    }

    public abstract List<ConfigurationComponentTypeId> getComponentsOfPeripheral(String var1);

    public List<String> getActiveCorePeripherals() {
        return new ArrayList<String>();
    }

    public List<ComponentInstanceConfig> getComponentInstanceConfigs(String peripheralInstanceName) {
        return (List)this.getFunctionalGroup().getInstances().values().stream().filter(c -> Objects.nonNull(c) && c.isPeripheralUsed(peripheralInstanceName)).collect(CollectorsUtils.toList());
    }

    public @Nullable ConfigurationComponentTypeId getConfigurationComponentTypeId(String id) {
        return (ConfigurationComponentTypeId)CollectionsUtils.findAny((Collection)this.mcu.getAvailableComponents().getConfigCompTypeIds(), x -> id.equals(x.getConfigurationComponent().getId()));
    }

    public boolean setValue(ScalarConfig child, String newVal, Object caller) {
        return this.setValue(child, newVal, true, caller);
    }

    public boolean setValue(ScalarConfig child, String newVal, boolean handleChanges, Object caller) {
        boolean result = child.setValue(newVal);
        if (result) {
            APeriphController.unsetParentQuickSelections((IChild)child);
            if (handleChanges) {
                this.handleSettingChange(2, caller, UtilsText.safeString((String)Messages.get().Controller_Action_SetValueOfSetting));
            }
        }
        return result;
    }

    public @Nullable ConfigurationComponent getConfigurationComponent(String id) {
        return (ConfigurationComponent)CollectionsUtils.findAny((Collection)this.profile.getActiveComponents().getConfigComps(), x -> id.equals(x.getId()));
    }

    public List<UiValueIdHolder> getEnumItems(ISettingConfig settingConfig) {
        ArrayList items = null;
        if (settingConfig instanceof ScalarConfig) {
            items = ((ScalarConfig)settingConfig).getEnumItems();
        } else {
            LOGGER.severe("Setting is not instance of an enumsetting: " + settingConfig.getModelData().getId());
            items = new ArrayList();
        }
        return (List)items.stream().filter(x -> x.isAvailable(settingConfig.getExpressionContext())).map(x -> new UiValueIdHolder(x.getUIName(settingConfig.getExpressionContext()), x.getId(), x.getResolvedDescription(settingConfig.getExpressionContext()))).collect(CollectorsUtils.toList());
    }

    public UiValueIdHolder getEnumItemById(ISettingConfig settingConfig, String itemId) {
        SetSetting.Item item = null;
        if (settingConfig instanceof ScalarConfig) {
            List items = ((ScalarConfig)settingConfig).getEnumItems();
            item = (SetSetting.Item)CollectionsUtils.nullableOptionalGet(items.stream().filter(x -> x.getId().equals(itemId)).findFirst());
        } else {
            LOGGER.severe("Setting is not an enum: " + settingConfig.getModelData().getId());
        }
        if (item == null) {
            return new UiValueIdHolder("", itemId, "");
        }
        return new UiValueIdHolder(item.getUIName(settingConfig.getExpressionContext()), item.getId(), item.getResolvedDescription(settingConfig.getExpressionContext()));
    }

    public void setSetPresence(SetConfig.SetPresence setPresence, boolean newVal, Object caller) {
        this.setSetPresence(setPresence, newVal, true, caller);
    }

    public void setSetPresence(SetConfig.SetPresence setPresence, boolean newVal, boolean handleChanges, Object caller) {
        setPresence.setValue(newVal);
        APeriphController.unsetParentQuickSelections((IChild)setPresence);
        if (handleChanges) {
            this.handleSettingChange(2, caller, UtilsText.safeString((String)Messages.get().Controller_Action_SetValueOfSet));
        }
    }

    protected static void unsetParentQuickSelections(IChild child) {
        IChildProvidable parent = child.getChildContext().getParent();
        while (parent != null) {
            if (parent instanceof IPresettable) {
                ((IPresettable)parent).setQuickSelection(null);
            }
            parent = parent.getChildContext().getParent();
        }
    }

    public boolean canCopy(ISettingConfig setting) {
        return false;
    }

    public void paste(ISettingConfig setting) {
        ISettingConfig clipboardLoc = this.clipboard;
        if (clipboardLoc != null && this.canPaste(setting)) {
            setting.applyOther(clipboardLoc);
            this.handleSettingChange(2, (Object)this, "Paste of stored setting into another setting", true);
        }
    }

    public boolean canPaste(ISettingConfig setting) {
        StructConfig pastedStruct;
        StructConfig clipboardStruct;
        ISettingConfig clipboardLoc = this.clipboard;
        if (clipboardLoc == null) {
            return false;
        }
        if (!UtilsText.safeString((String)clipboardLoc.getTypeName()).equals(setting.getTypeName())) {
            return false;
        }
        if (setting instanceof StructConfig && !ChildProviderHelper.typesOfChildrenEquals((AStructuredSettingConfig)(clipboardStruct = (StructConfig)clipboardLoc), (StructConfig)(pastedStruct = (StructConfig)setting))) {
            return false;
        }
        if (setting instanceof ArrayConfig) {
            pastedStruct = (ArrayConfig)setting;
            clipboardStruct = (ArrayConfig)clipboardLoc;
            if (!pastedStruct.getId().equals(clipboardStruct.getId())) {
                return false;
            }
        }
        return true;
    }

    public void copy(ISettingConfig setting) {
        this.clipboard = setting;
    }

    public void clearClipboard() {
        this.clipboard = null;
    }

    public void pasteAsNewItem(ArrayConfig array) {
        ISettingConfig clipboardLoc = this.clipboard;
        if (clipboardLoc != null && this.canPasteAsNewItem(array)) {
            ISettingConfig addedItem = array.addNewItem();
            addedItem.applyOther(clipboardLoc);
            this.handleSettingChange(2, (Object)this, "Paste of stored setting into another setting", true);
        }
    }

    public boolean canPasteAsNewItem(ArrayConfig array) {
        if (!array.canAddItem()) {
            return false;
        }
        ISettingConfig clipboardLoc = this.clipboard;
        if (clipboardLoc == null) {
            return false;
        }
        boolean idEquals = UtilsText.safeString((String)clipboardLoc.getModelData().getId()).equals(array.getInstanceSetting().getId());
        boolean typeEquals = clipboardLoc.getModelData().getClass().equals(array.getInstanceSetting().getClass());
        return idEquals && typeEquals;
    }

    public void addItem(ArrayConfig arrayConfig, Object caller) {
        this.addItem(arrayConfig, true, caller);
    }

    public void addItem(ArrayConfig arrayConfig, boolean handleChanges, Object caller) {
        try {
            arrayConfig.addNewItem();
        }
        catch (ExpressionException ex) {
            ex.log();
        }
        APeriphController.unsetParentQuickSelections((IChild)arrayConfig);
        if (handleChanges) {
            this.handleSettingChange(2, caller, UtilsText.safeString((String)Messages.get().Controller_Action_AddItemToArray));
        }
    }

    public boolean moveItemFront(ArrayConfig arrayConfig, ISettingConfig childConfig, Object caller) {
        try {
            if (arrayConfig.moveFront(childConfig)) {
                this.handleSettingChange(2, caller, UtilsText.safeString((String)Messages.get().Controller_Action_MoveItem));
                return true;
            }
        }
        catch (ExpressionException ex) {
            ex.log();
        }
        return false;
    }

    public boolean moveItemBack(ArrayConfig arrayConfig, ISettingConfig childConfig, Object caller) {
        try {
            if (arrayConfig.moveBack(childConfig)) {
                this.handleSettingChange(2, caller, UtilsText.safeString((String)Messages.get().Controller_Action_MoveItem));
                return true;
            }
        }
        catch (ExpressionException ex) {
            ex.log();
        }
        return false;
    }

    public boolean moveItemBeginning(ArrayConfig arrayConfig, ISettingConfig childConfig, Object caller) {
        try {
            if (arrayConfig.moveBeginning(childConfig)) {
                this.handleSettingChange(2, caller, UtilsText.safeString((String)Messages.get().Controller_Action_MoveItem));
                return true;
            }
        }
        catch (ExpressionException ex) {
            ex.log();
        }
        return false;
    }

    public boolean moveItemEnd(ArrayConfig arrayConfig, ISettingConfig childConfig, Object caller) {
        try {
            if (arrayConfig.moveEnd(childConfig)) {
                this.handleSettingChange(2, caller, UtilsText.safeString((String)Messages.get().Controller_Action_MoveItem));
                return true;
            }
        }
        catch (ExpressionException ex) {
            ex.log();
        }
        return false;
    }

    public boolean removeItem(ArrayConfig arrayConfig, ISettingConfig childConfig, Object caller) {
        return this.removeItem(arrayConfig, childConfig, true, caller);
    }

    public boolean removeItem(ArrayConfig arrayConfig, ISettingConfig childConfig, boolean handleChanges, Object caller) {
        try {
            if (arrayConfig.remove(childConfig)) {
                APeriphController.unsetParentQuickSelections((IChild)arrayConfig);
                if (handleChanges) {
                    this.handleSettingChange(2, caller, UtilsText.safeString((String)Messages.get().Controller_Action_RemoveItemFromArray));
                }
                return true;
            }
        }
        catch (ExpressionException ex) {
            ex.log();
        }
        return false;
    }

    public void setAllSettingsTo(String value, List<IChild> settings, Object caller) {
        for (IChild setting : settings) {
            if (setting instanceof ScalarConfig) {
                ((ScalarConfig)setting).setValue(value);
                continue;
            }
            if (!(setting instanceof SetConfig.SetPresence)) continue;
            ((SetConfig.SetPresence)setting).setValue(Boolean.valueOf(value).booleanValue());
        }
        this.handleSettingChange(2, caller, Messages.get().Controller_Action_SettingAllItemsTo);
    }

    public void applyQuickSelection(String quickSelUiName, IPresettable presettable, Object caller) {
        QuickSelection quickSelection = (QuickSelection)CollectionsUtils.nullableOptionalGet(presettable.getQuickSelectionGroup().getQuickSelections().stream().filter(x -> x.getUIName(presettable.getExpressionContext()).equals(quickSelUiName)).findFirst());
        if (quickSelection != null) {
            presettable.setQuickSelection(quickSelection);
            presettable.applySelectedQuickSelection();
            APeriphController.unsetParentQuickSelections((IChild)presettable);
            this.handleSettingChange(2, caller, UtilsText.safeString((String)Messages.get().Controller_Action_ApplyQuickSelection));
        }
    }

    protected static FunctionalGroup createFunctionalGroup(ChildContext childContext, IMcu mcu) {
        if (APeriphController.isMcuSupported(mcu)) {
            return new FunctionalGroup(childContext, mcu);
        }
        return new FunctionalGroup(childContext, mcu){

            public @NonNull String getError() {
                return ((EmptyMcu)this.mcu).getReason();
            }

            public String getName() {
                return ((EmptyMcu)this.mcu).getReason();
            }
        };
    }

    public static boolean isMcuSupported(IMcu mcuToCheck) {
        return !(mcuToCheck instanceof EmptyMcu);
    }

    public boolean isMcuSupported() {
        return APeriphController.isMcuSupported(this.mcu);
    }
}

