/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.internal.sdk;

import com.nxp.s32ds.cle.runtime.hardware.sdk.DeviceCoreSdkDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.sdk.DeviceCoreSdkRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class DeviceCoreSdkRegistryImplementation
extends BaseRegistry
implements DeviceCoreSdkRegistry {
    private final Map<String, Collection<DeviceCoreSdkDescriptor>> core2deviceCoreSDKDescriptors = new HashMap<String, Collection<DeviceCoreSdkDescriptor>>();
    private final Map<String, Collection<DeviceCoreSdkDescriptor>> sdk2deviceCoreSDKDescriptors = new HashMap<String, Collection<DeviceCoreSdkDescriptor>>();

    @Override
    public List<DeviceCoreSdkDescriptor> getDeviceCoreSdkDescriptorsByCoreId(String coreId) {
        return this.getReferenceDescriptorsBySourceId(coreId, this.core2deviceCoreSDKDescriptors, DeviceCoreSdkDescriptor.class);
    }

    @Override
    public List<DeviceCoreSdkDescriptor> getDeviceCoreSdkDescriptorsBySdkId(String sdkId) {
        return this.getReferenceDescriptorsByTargetId(sdkId, this.sdk2deviceCoreSDKDescriptors, DeviceCoreSdkDescriptor.class);
    }

    @Override
    public void addDeviceCoreSdkDescriptor(DeviceCoreSdkDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.core2deviceCoreSDKDescriptors, this.sdk2deviceCoreSDKDescriptors, DeviceCoreSdkDescriptor.class);
    }

    @Override
    public void removeDeviceCoreSdkDescriptor(DeviceCoreSdkDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.core2deviceCoreSDKDescriptors, this.sdk2deviceCoreSDKDescriptors, DeviceCoreSdkDescriptor.class);
    }

    @Override
    public void removeDeviceCoreSdkDescriptorsBySdkId(String sdkId) {
        Collection<DeviceCoreSdkDescriptor> collection = this.sdk2deviceCoreSDKDescriptors.get(sdkId);
        if (collection != null) {
            ArrayList<DeviceCoreSdkDescriptor> descriptors = new ArrayList<DeviceCoreSdkDescriptor>(collection);
            descriptors.forEach(this::removeDeviceCoreSdkDescriptor);
            descriptors.clear();
        }
    }

    @Override
    public List<DeviceCoreSdkDescriptor> getDeviceCoreSdkDescriptors() {
        ArrayList<DeviceCoreSdkDescriptor> result = new ArrayList<DeviceCoreSdkDescriptor>();
        this.core2deviceCoreSDKDescriptors.values().stream().flatMap(v -> v.stream()).forEach(result::add);
        return result;
    }
}

