/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal;

import com.nxp.s32ds.rcp.modular.ModularFactory;
import com.nxp.s32ds.rcp.modular.ModularFeature;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.ModularRegistry;
import com.nxp.s32ds.rcp.modular.internal.ModularFactoryImplementation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.osgi.service.component.annotations.Component;

@Component
public class ModularRegistryImplementation
implements ModularRegistry {
    private Collection<ModularPack> packs = new ArrayList<ModularPack>();

    @Override
    public void addPack(ModularPack pack) {
        this.packs.add(pack);
    }

    @Override
    public Collection<ModularPack> getAllPacks() {
        return Collections.unmodifiableCollection(this.packs);
    }

    @Override
    public Collection<ModularFeature> getPackFeatures(String packageId) {
        Collection<ModularFeature> result = null;
        for (ModularPack clPackage : this.packs) {
            if (!clPackage.getId().equals(packageId)) continue;
            result = clPackage.getFeatures();
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public ModularPack getPacksById(String packageId) {
        for (ModularPack collateralPack : this.packs) {
            if (!packageId.equals(collateralPack.getId())) continue;
            return collateralPack;
        }
        return null;
    }

    @Override
    public ModularFeature getFeatureById(String featureId) {
        for (ModularPack collateralPack : this.packs) {
            for (ModularFeature feature : collateralPack.getFeatures()) {
                if (!featureId.equals(feature.getId())) continue;
                return feature;
            }
        }
        return null;
    }

    @Override
    public ModularFactory getModularFactory() {
        return ModularFactoryImplementation.getInstance();
    }
}

