/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal;

import com.nxp.s32ds.rcp.modular.HWFamily;
import com.nxp.s32ds.rcp.modular.ModularFeature;
import com.nxp.s32ds.rcp.modular.ModularLicense;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.internal.ModularObjectImplementation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.ILicense;

public class ModularPackImplementation
extends ModularObjectImplementation
implements ModularPack {
    private static final String SPLITTER = ";";
    private Collection<ModularFeature> features;
    private Collection<ILicense> licenses = new ArrayList<ILicense>();
    private boolean isUninstalled = true;
    private String icon;
    private Collection<String> thirdPartyIds;
    private final List<ModularLicense> licenseData = new ArrayList<ModularLicense>();
    private String p2featureId;
    private Collection<HWFamily> hWFamilies;
    private String p2featureVersion;
    private Map<String, Set<String>> supportProductName2Vesrions;

    public ModularPackImplementation(String id, String name, String description, String version, URI uri) {
        super(id, name, description, version, uri);
        this.features = new ArrayList<ModularFeature>();
        this.thirdPartyIds = new HashSet<String>();
        this.hWFamilies = new ArrayList<HWFamily>();
        this.supportProductName2Vesrions = new HashMap<String, Set<String>>();
    }

    public void addModularFeature(ModularFeature modularFeature) {
        this.features.add(modularFeature);
    }

    @Override
    public Collection<ModularFeature> getFeatures() {
        return Collections.unmodifiableCollection(this.features);
    }

    @Override
    public Collection<ILicense> getLicenses() {
        return Collections.unmodifiableCollection(this.licenses);
    }

    public void addLicense(ILicense license) {
        this.licenses.add(license);
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public void addModularLicense(String licenseParams, String title) {
        int licenseParamSize;
        String[] split = licenseParams.split(SPLITTER);
        if (split.length == (licenseParamSize = 3)) {
            this.licenseData.add(new ModularLicense(split[0], split[1], split[2], title));
        }
    }

    @Override
    public List<ModularLicense> getLicenseData() {
        return this.licenseData;
    }

    @Override
    public boolean isUninstallable() {
        return this.isUninstalled;
    }

    public void setUninstall(boolean isUninstalled) {
        this.isUninstalled = isUninstalled;
    }

    public void addAllThirdPartyIds(Collection<String> thirdPartyIds) {
        this.thirdPartyIds.addAll(thirdPartyIds);
    }

    @Override
    public Collection<String> getThirdPartyIds() {
        return Collections.unmodifiableCollection(this.thirdPartyIds);
    }

    public void setP2FeatureId(String featureId) {
        this.p2featureId = featureId;
    }

    @Override
    public String getP2FeatureId() {
        return this.p2featureId;
    }

    public void addHwFamily(HWFamily hwFamily) {
        this.hWFamilies.add(hwFamily);
    }

    @Override
    public Collection<HWFamily> getHWFamilies() {
        return Collections.unmodifiableCollection(this.hWFamilies);
    }

    @Override
    public String getP2featureVersion() {
        return this.p2featureVersion;
    }

    public void setP2featureVersion(String p2featureVersion) {
        this.p2featureVersion = p2featureVersion;
    }

    public void addSupportProduct(String productName, Set<String> productVersion) {
        this.supportProductName2Vesrions.put(productName, productVersion);
    }

    @Override
    public Map<String, Set<String>> getSupporProductName2Versions() {
        return this.supportProductName2Vesrions;
    }
}

