/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuflow.util;

import com.nxp.s32ds.gte.apuflow.ApuConsumer;
import com.nxp.s32ds.gte.apuflow.ApuContainer;
import com.nxp.s32ds.gte.apuflow.ApuContent;
import com.nxp.s32ds.gte.apuflow.ApuDefinition;
import com.nxp.s32ds.gte.apuflow.ApuFlowPackage;
import com.nxp.s32ds.gte.apuflow.ApuNode;
import com.nxp.s32ds.gte.apuflow.ApuPort;
import com.nxp.s32ds.gte.apuflow.ApuProducer;
import com.nxp.s32ds.gte.apuflow.ApuUsage;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class ApuFlowValidator
extends EObjectValidator {
    public static final ApuFlowValidator INSTANCE = new ApuFlowValidator();
    public static final String DIAGNOSTIC_SOURCE = "com.nxp.s32ds.gte.apuflow";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return ApuFlowPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateApuDefinition((ApuDefinition)value, diagnostics, context);
            }
            case 1: {
                return this.validateApuUsage((ApuUsage)value, diagnostics, context);
            }
            case 2: {
                return this.validateApuContainer((ApuContainer)value, diagnostics, context);
            }
            case 3: {
                return this.validateApuContent((ApuContent)value, diagnostics, context);
            }
            case 4: {
                return this.validateApuNode((ApuNode)value, diagnostics, context);
            }
            case 5: {
                return this.validateApuPort((ApuPort)value, diagnostics, context);
            }
            case 6: {
                return this.validateApuConsumer((ApuConsumer)value, diagnostics, context);
            }
            case 7: {
                return this.validateApuProducer((ApuProducer)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateApuDefinition(ApuDefinition apuDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuDefinition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuDefinition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuDefinition_must_have_name(apuDefinition, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuDefinition_must_have_name(ApuDefinition apuDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateApuUsage(ApuUsage apuUsage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuUsage, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuUsage, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuUsage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuUsage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuUsage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuUsage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuUsage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuUsage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuUsage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuUsage_must_have_definition(apuUsage, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuUsage_must_have_definition(ApuUsage apuUsage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuUsage.getDefinition() == null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Must have a definition", ApuFlowValidator.getObjectLabel((EObject)apuUsage, context)}, new Object[]{apuUsage}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuContainer(ApuContainer apuContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(apuContainer, diagnostics, context);
    }

    public boolean validateApuContent(ApuContent apuContent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuContent, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuContent, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuContent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuContent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuContent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuContent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuContent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuContent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuContent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuContent_must_have_container(apuContent, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuContent_must_have_container(ApuContent apuContent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuContent.getContainer() == null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Must have a container", ApuFlowValidator.getObjectLabel((EObject)apuContent, context)}, new Object[]{apuContent}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuNode(ApuNode apuNode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(apuNode, diagnostics, context);
    }

    public boolean validateApuPort(ApuPort apuPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuPort, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuPort, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuPort_must_have_node(apuPort, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuPort_must_have_node(ApuPort apuPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuPort.getNode() == null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Must have a node", ApuFlowValidator.getObjectLabel((EObject)apuPort, context)}, new Object[]{apuPort}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuConsumer(ApuConsumer apuConsumer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuConsumer, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuConsumer, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuConsumer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuConsumer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuConsumer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuConsumer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuConsumer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuConsumer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuConsumer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuPort_must_have_node(apuConsumer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuConsumer_must_have_producer(apuConsumer, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuConsumer_must_have_producer(ApuConsumer apuConsumer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuConsumer.getProducer() == null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Must have a producer", ApuFlowValidator.getObjectLabel((EObject)apuConsumer, context)}, new Object[]{apuConsumer}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateApuProducer(ApuProducer apuProducer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuProducer, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuProducer, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuProducer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuProducer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuProducer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuProducer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuProducer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuProducer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuProducer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuPort_must_have_node(apuProducer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProducer_must_have_consumer(apuProducer, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuProducer_must_have_consumer(ApuProducer apuProducer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuProducer.getConsumers() == null || apuProducer.getConsumers().isEmpty()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Must have a consumer", ApuFlowValidator.getObjectLabel((EObject)apuProducer, context)}, new Object[]{apuProducer}, context));
            }
            return false;
        }
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

