/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuflow;

import com.nxp.s32ds.gte.apuflow.ApuDefinition;
import com.nxp.s32ds.gte.apuflow.ApuUsage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApuUsages {
    private static final String NUMBERS_POSTFIX = "\\d+$";
    private static final Pattern PATTERN_NUMBERS_POSTFIX = Pattern.compile("\\d+$");

    public static <U extends ApuUsage> List<U> findUsages(List<U> usages, String identifier) {
        ArrayList<ApuUsage> result = new ArrayList<ApuUsage>();
        for (ApuUsage usage : usages) {
            String name;
            ApuDefinition definition = usage.getDefinition();
            if (definition == null || !Objects.equals(name = definition.getName(), identifier)) continue;
            result.add(usage);
        }
        return result;
    }

    public static String composeNextName(List<String> list, String pattern) {
        return ApuUsages.composeNextNameWithPrefix(list, "", pattern);
    }

    public static String composeNextNameWithPrefix(List<String> list, String prefix, String pattern) {
        int index = 0;
        String format = prefix.isEmpty() ? MessageFormat.format(pattern, index) : MessageFormat.format(pattern, prefix, index);
        while (list.contains(format)) {
            String string = format = prefix.isEmpty() ? MessageFormat.format(pattern, index) : MessageFormat.format(pattern, prefix, ++index);
        }
        return format;
    }

    public static String getNameWithoutPostfix(String name) {
        String postfix = ApuUsages.getNamePostfix(name);
        if (postfix != null) {
            name = name.substring(0, name.length() - postfix.length());
        }
        return name;
    }

    private static String getNamePostfix(String name) {
        Matcher matcher = PATTERN_NUMBERS_POSTFIX.matcher(name);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }
}

