/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuflow;

import com.nxp.s32ds.gte.apuflow.ApuConsumer;
import com.nxp.s32ds.gte.apuflow.ApuContent;
import com.nxp.s32ds.gte.apuflow.ApuNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class ApuFlowResolver {
    private static final String pluginID = "com.nxp.s32ds.gte.apuflow";

    private ApuFlowResolver() {
    }

    public static List<ApuContent> getApuContentsOrder(Collection<ApuContent> apuContents) throws CoreException {
        HashMap<ApuContent, List<ApuContent>> apuContentWhithLinks = new HashMap<ApuContent, List<ApuContent>>();
        ArrayList<ApuContent> orderedContent = new ArrayList<ApuContent>();
        ApuFlowResolver.findLinks(apuContents, apuContentWhithLinks);
        for (ApuContent apuContent : apuContents) {
            if (((List)apuContentWhithLinks.get(apuContent)).isEmpty()) {
                if (orderedContent.contains(apuContent)) continue;
                orderedContent.add(apuContent);
                continue;
            }
            ApuFlowResolver.resolveDependency(apuContent, new ArrayList<ApuContent>(), apuContentWhithLinks, orderedContent, null);
        }
        return orderedContent;
    }

    private static void findLinks(Collection<ApuContent> apuContents, Map<ApuContent, List<ApuContent>> apuContentWhithLinks) {
        for (ApuContent apuContent : apuContents) {
            ArrayList<ApuContent> links = new ArrayList<ApuContent>();
            for (ApuConsumer apuConsumer : apuContent.getInputs()) {
                apuConsumer.getProducer();
                ApuNode node = apuConsumer.getProducer().getNode();
                if (!(node instanceof ApuContent)) continue;
                links.add((ApuContent)node);
            }
            apuContentWhithLinks.put(apuContent, links);
        }
    }

    private static void resolveDependency(ApuContent target, List<ApuContent> trace, Map<ApuContent, List<ApuContent>> apuContentWhithLinks, List<ApuContent> orderedContent, Iterator<ApuContent> parentLinks) throws CoreException {
        if (trace.contains(target)) {
            Status error = new Status(4, pluginID, "Cyclic dependency");
            throw new CoreException((IStatus)error);
        }
        trace.add(target);
        List<ApuContent> list = apuContentWhithLinks.get(target);
        Iterator<ApuContent> iterator = list.iterator();
        while (iterator.hasNext()) {
            ApuContent apuContent = iterator.next();
            if (apuContentWhithLinks.get(apuContent).isEmpty() && orderedContent.contains(apuContent)) {
                iterator.remove();
                continue;
            }
            if (apuContentWhithLinks.get(apuContent).isEmpty() && !orderedContent.contains(apuContent)) {
                orderedContent.add(apuContent);
                iterator.remove();
                continue;
            }
            ApuFlowResolver.resolveDependency(apuContent, trace, apuContentWhithLinks, orderedContent, iterator);
        }
        if (list.isEmpty() && !orderedContent.contains(target)) {
            orderedContent.add(target);
            if (parentLinks != null) {
                parentLinks.remove();
            }
        }
    }
}

