/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.launch.core;

import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import com.nxp.s32ds.mdt.ide.internal.launch.core.MdtIdeLaunchCoreActivator;
import com.nxp.s32ds.mdt.ide.launch.core.MdtLaunchParams;
import com.nxp.s32ds.mdt.ide.launch.core.Messages;
import java.lang.reflect.Field;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.emf.ecore.EObject;

public interface MdtLaunchDelegate {
    public static final String NOTIFY_EMIT_FINISHED_HANDLER_ID = "com.nxp.s32ds.mdt.ide.launch.core.notifyEmitFinishedHandler";

    default public void showFinish() throws CoreException {
        RcpStatusHandlers.handleStatus((String)NOTIFY_EMIT_FINISHED_HANDLER_ID, (IStatus)MdtIdeLaunchCoreActivator.getInstance().createStatus(1, ""), null);
    }

    default public void postGenerate(IProject project, IProgressMonitor monitor) throws CoreException {
        if (this.cancelled(monitor) || !this.projectAccessible(project)) {
            return;
        }
        this.doPostGenerate(null, null, null, null);
        this.refreshProject(Messages.refreshing_project, monitor, project);
    }

    public void doPostGenerate(MdtLaunchParams var1, IProject var2, EObject var3, IProgressMonitor var4) throws CoreException;

    default public IProject getTargetProject(ILaunchConfiguration configuration) {
        try {
            if (configuration instanceof LaunchConfiguration) {
                Field containerField = LaunchConfiguration.class.getDeclaredField("fContainer");
                containerField.setAccessible(true);
                Object object = containerField.get(configuration);
                if (object instanceof IContainer) {
                    return ((IContainer)object).getProject();
                }
            }
        }
        catch (Exception e) {
            MdtIdeLaunchCoreActivator.getInstance().logError(Messages.error_reading_a_container_of_a_launch_configuration, e);
        }
        return null;
    }

    default public boolean cancelled(IProgressMonitor monitor) {
        return monitor.isCanceled();
    }

    default public boolean projectAccessible(IProject project) {
        return project != null && project.isAccessible();
    }

    default public void refreshProject(String taskName, IProgressMonitor monitor, IProject project) throws CoreException {
        monitor.worked(10);
        monitor.setTaskName(taskName);
        project.refreshLocal(2, monitor);
    }
}

