/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.launch.core;

import com.nxp.s32ds.mdt.ide.core.vsdk.EmitterProperties;
import com.nxp.s32ds.mdt.ide.core.vsdk.MdtVsdkHelper;
import com.nxp.s32ds.mdt.ide.internal.launch.core.MdtIdeLaunchCoreActivator;
import com.nxp.s32ds.mdt.ide.launch.core.MdtLaunchParams;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public abstract class MdtLaunchConfiguration {
    private String location;
    private String workingDirectory;
    private IStatus status;
    private final String name;

    protected MdtLaunchConfiguration(String name) {
        this.name = name;
        this.init();
        this.getVsdkHelper().addListener(() -> this.init());
    }

    protected abstract MdtVsdkHelper getVsdkHelper();

    private void init() {
        this.location = null;
        this.workingDirectory = null;
        this.status = Status.OK_STATUS;
        try {
            EmitterProperties emitterProperties = new EmitterProperties(this.name, this.getVsdkHelper().getVsdkPropertiesFilePath().toString());
            this.location = emitterProperties.getScriptLocation();
            this.workingDirectory = emitterProperties.getBaseDir();
        }
        catch (CoreException e) {
            MdtIdeLaunchCoreActivator.getInstance().logError(e.getStatus().getMessage());
            this.status = e.getStatus();
        }
    }

    public void applyExternalToolAtributes(ILaunchConfigurationWorkingCopy workingCopy, MdtLaunchParams params) throws CoreException {
        if (!this.status.isOK()) {
            throw new CoreException(MdtIdeLaunchCoreActivator.getInstance().createError(this.status.getMessage()));
        }
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", this.workingDirectory);
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", this.location);
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", params.constructArgs());
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
    }
}

