/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.internal.launch.core;

import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import com.nxp.s32ds.mdt.ide.internal.launch.core.MdtIdeLaunchCoreActivator;
import com.nxp.s32ds.mdt.ide.internal.launch.core.Messages;
import com.nxp.s32ds.mdt.ide.launch.core.BuildParticipant;
import com.nxp.s32ds.mdt.ide.launch.core.MdtIdeLaunchCore;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class MdtProjectBuilder
extends IncrementalProjectBuilder {
    private static final String MODEL_PROBLEM_MARKER = "com.nxp.s32ds.mdt.ide.launch.core.model.problem.marker";
    private static final String ERROR_HANDLER_ID = "com.nxp.s32ds.mdt.ide.internal.launch.ui.MdtBuilderErrorStatusHandler";
    private static final IResourceDeltaVisitor DUMMY_VISITOR = d -> true;

    protected IProject[] build(int kind, Map<String, String> arguments, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta;
        if (!MdtProjectBuilder.isEnabled(arguments)) {
            return null;
        }
        if (kind == 15) {
            this.clean(monitor);
        }
        if (kind != 6 && (delta = this.getDelta(this.getProject())) != null) {
            delta.accept(DUMMY_VISITOR);
        }
        try {
            MdtProjectBuilder.fullBuild(monitor, this.getProject());
        }
        catch (OperationCanceledException operationCanceledException) {}
        return null;
    }

    private static void fullBuild(IProgressMonitor monitor, IProject project) throws CoreException {
        project.deleteMarkers(MODEL_PROBLEM_MARKER, true, 2);
        List<ILaunchConfiguration> launchConfigs = MdtIdeLaunchCore.extractLaunchConfigurations(project, "emit_build");
        Map<String, BuildParticipant> allPparticipants = MdtIdeLaunchCoreActivator.getInstance().getBuildParticipants();
        try {
            for (ILaunchConfiguration config : launchConfigs) {
                String launchConfigId = config.getType().getIdentifier();
                BuildParticipant bp = allPparticipants.get(launchConfigId);
                MdtProjectBuilder.performBuildOperation(project, config, bp, () -> config.launch("emit_build", monitor));
            }
        }
        catch (CoreException ce) {
            IStatus status = ce.getStatus();
            if (status.getSeverity() == 8) {
                throw new OperationCanceledException(Messages.MdtProjectBuilder_canceled_by_user);
            }
            RcpStatusHandlers.handleStatus((String)ERROR_HANDLER_ID, (IStatus)status, null);
            throw new OperationCanceledException(Messages.MdtProjectBuilder_build_error);
        }
    }

    protected void clean(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        Map arguments = this.getCommand().getArguments();
        if (!MdtProjectBuilder.isEnabled(arguments)) {
            return;
        }
        IProject project = this.getProject();
        List<ILaunchConfiguration> allLaunchConfigurations = MdtIdeLaunchCore.extractLaunchConfigurations(project, "clean");
        Map<String, BuildParticipant> allPparticipants = MdtIdeLaunchCoreActivator.getInstance().getBuildParticipants();
        for (ILaunchConfiguration config : allLaunchConfigurations) {
            if (config == null) continue;
            String launchConfigId = config.getType().getIdentifier();
            BuildParticipant bp = allPparticipants.get(launchConfigId);
            MdtProjectBuilder.performBuildOperation(project, config, bp, () -> bp.clean(project, config, monitor));
        }
    }

    private static void createProblemMarker(IStatus modelFileStatus, IProject project) throws CoreException {
        IMarker m = project.createMarker(MODEL_PROBLEM_MARKER);
        m.setAttribute("message", (Object)modelFileStatus.getMessage());
        m.setAttribute("priority", 2);
        m.setAttribute("location", (Object)project.getName());
        m.setAttribute("severity", 2);
    }

    private static void performBuildOperation(IProject project, ILaunchConfiguration config, BuildParticipant bp, BuildOperationFunction function) throws CoreException {
        if (bp == null) {
            return;
        }
        IStatus modelFileStatus = bp.checkModelingFileExists(config);
        if (modelFileStatus.isOK()) {
            function.apply();
        } else {
            MdtProjectBuilder.createProblemMarker(modelFileStatus, project);
        }
    }

    private static boolean isEnabled(Map<String, String> arguments) {
        String commandEnabled = arguments.get("CommandEnabled");
        return commandEnabled == null || !commandEnabled.trim().toLowerCase().equals("false");
    }

    private static interface BuildOperationFunction {
        public void apply() throws CoreException;
    }
}

