/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.IRenameParticipant;
import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import com.nxp.s32ds.ext.ide.ui.internal.ExtIdeUiActivator;
import com.nxp.s32ds.ext.ide.utils.OSFamily;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.osgi.service.prefs.BackingStoreException;

public class RenameOperationContext {
    private static final String PREF_WIZARD = "com.freescale.s32ds.cross.wizard";
    private static final String GROUP_NAME = "groupName";
    public static final String EMPTY = "";
    private final String userProjectName;
    private final ProjectSet projectsSet;
    private final Map<String, String> nameMap;
    private List<IRenameParticipant> lstParticipants;

    public RenameOperationContext(String userProjectName, ProjectSet projects, List<IRenameParticipant> lstParticipants) {
        this.userProjectName = userProjectName;
        this.projectsSet = projects;
        this.nameMap = Collections.unmodifiableMap(Stream.concat(projects.getProjects().map(IProjectDescription::getName), Stream.of(projects.getName())).distinct().collect(Collectors.toMap(String::toString, RenameOperationContext.replaceAllQuoted("^" + Pattern.quote(projects.getName()), userProjectName))));
        this.lstParticipants = lstParticipants;
    }

    public IProject performProjectOperation(IProjectDescription project, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException, BackingStoreException {
        RenameOperationContext.unHide(project);
        IPath newPath = this.calcNewPath(project);
        String newProjectName = this.nameMap.get(project.getName());
        IProject tgtProject = RenameOperationContext.toProject(newProjectName);
        IProjectDescription targetProjectDecsr = RenameOperationContext.newProjectDescription(project, newProjectName, newPath.toString());
        tgtProject.create(targetProjectDecsr, monitor);
        tgtProject.open(128, monitor);
        RenameOperationContext.importSource(tgtProject, project.getLocation().toFile(), monitor);
        RenameOperationContext.unHide(tgtProject.getDescription());
        IProject srcProject = RenameOperationContext.toProject(project.getName());
        this.invokeParticipants(tgtProject, srcProject, monitor);
        this.updateProjectPreferences(tgtProject);
        return tgtProject;
    }

    public IPath calcNewPath(IProjectDescription project) {
        String name = this.userProjectName.equals(this.projectsSet.getName()) ? project.getName() : project.getName().replaceFirst(Matcher.quoteReplacement(this.projectsSet.getName()), this.userProjectName);
        String prefix = this.projectsSet.getProjects().count() > 1L ? String.valueOf(this.userProjectName) + '/' : EMPTY;
        return Path.fromOSString((String)(String.valueOf(prefix) + name));
    }

    private void updateProjectPreferences(IProject newProject) throws BackingStoreException {
        IEclipsePreferences prefs = new ProjectScope(newProject).getNode(PREF_WIZARD);
        prefs.put(GROUP_NAME, this.getName(prefs.get(GROUP_NAME, EMPTY)));
        prefs.flush();
    }

    private static IProjectDescription newProjectDescription(IProjectDescription src, String name, String path) {
        IProjectDescription dst = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        dst.setLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(path));
        dst.setBuildSpec(src.getBuildSpec());
        dst.setComment(src.getComment());
        dst.setDynamicReferences(src.getDynamicReferences());
        dst.setNatureIds(src.getNatureIds());
        dst.setReferencedProjects(src.getReferencedProjects());
        return dst;
    }

    private void invokeParticipants(IProject target, IProject source, IProgressMonitor monitor) {
        String oldNamePart = this.projectsSet.getName();
        String newNamePart = this.userProjectName;
        for (IRenameParticipant iter : this.lstParticipants) {
            iter.renameProject(target, source, oldNamePart, newNamePart, monitor);
        }
    }

    private String getName(String key) {
        return this.nameMap.getOrDefault(key, key);
    }

    private static void importSource(IProject project, File importSource, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
        IOverwriteQuery owRenameQuery = new IOverwriteQuery(){

            public String queryOverwrite(String path) {
                return "YES";
            }
        };
        ImportOperation impOperation = new ImportOperation(project.getFullPath(), (Object)importSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, owRenameQuery, FileSystemStructureProvider.INSTANCE.getChildren((Object)importSource));
        impOperation.setOverwriteResources(true);
        impOperation.setCreateContainerStructure(false);
        impOperation.run(monitor);
        IStatus result = impOperation.getStatus();
        if (!result.isOK()) {
            throw new CoreException(result);
        }
    }

    private static void unHide(IProjectDescription project) {
        File f;
        if (OSFamily.WINDOWS.isCurrent() && (f = new File(new File(project.getLocationURI()), ".project")).isHidden()) {
            try {
                Files.setAttribute(f.toPath(), "dos:hidden", false, new LinkOption[0]);
            }
            catch (IOException e) {
                ExtIdeUiActivator.getInstance().logWarning("Cannot unset hidden attribute", e);
            }
        }
    }

    private static IProject toProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    private static Function<String, String> replaceAllQuoted(String regex, String replacement) {
        return str -> str.replaceAll(regex, Matcher.quoteReplacement(replacement));
    }

    public ProjectSet getProjectsSet() {
        return this.projectsSet;
    }
}

