/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import com.nxp.s32ds.ext.ide.core.refactoring.RenameRefactorService;
import com.nxp.s32ds.ext.ide.ui.internal.ExtIdeUiActivator;
import com.nxp.s32ds.ext.ide.ui.internal.Messages;
import com.nxp.s32ds.ext.ide.ui.refactoring.RenameHelper;
import com.nxp.s32ds.ext.ide.ui.refactoring.RenameOperationContext;
import com.nxp.s32ds.ext.ide.utils.IOUtils;
import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.WorkbenchJob;

public class RenameJob
extends WorkbenchJob {
    private final ProjectSet originalProjectSet;
    private final String newName;

    public RenameJob(ProjectSet projects, String name) {
        super("Rename S32DS project");
        this.originalProjectSet = projects;
        this.newName = name;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        try {
            final RenameOperationContext renameContext = new RenameOperationContext(this.newName, this.originalProjectSet, RenameRefactorService.getRenameRefactoringParticipants());
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor renameMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                    try {
                        try {
                            if (RenameJob.checkUnsavedEditors(renameContext)) {
                                RenameHelper.performRename(renameMonitor, renameContext);
                                RenameJob.this.deleteOldProjects(renameMonitor);
                            }
                        }
                        catch (Exception e) {
                            throw new CoreException(ExtIdeUiActivator.getInstance().createError("", e));
                        }
                    }
                    finally {
                        renameMonitor.done();
                    }
                }
            }.run(monitor);
            return Status.OK_STATUS;
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        catch (InvocationTargetException e) {
            IStatus status = ExtIdeUiActivator.getInstance().createError("Unexpected error during rename", e.getTargetException());
            ExtIdeUiActivator.getInstance().log(status);
            return status;
        }
    }

    private static boolean checkUnsavedEditors(RenameOperationContext renameContext) {
        List<IResource> projectsList = renameContext.getProjectsSet().getProjects().map(descr -> ResourcesPlugin.getWorkspace().getRoot().getProject(descr.getName())).collect(Collectors.toList());
        IResource[] projectsArray = projectsList.toArray(new IResource[projectsList.size()]);
        if (!IDE.saveAllEditors((IResource[])projectsArray, (boolean)true)) {
            ExtIdeUiActivator.getInstance().logWarning(Messages.warningRenameCanceledDueToUnsavedResources);
            return false;
        }
        return true;
    }

    private void deleteOldProjects(IProgressMonitor monitor) {
        this.originalProjectSet.getProjects().map(IProjectDescription::getName).map(arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getProject(arg_0)).forEach(FuncUtils.loggingConsumer(p -> p.delete(true, monitor)));
        IOUtils.rm((File)this.originalProjectSet.getPath().makeAbsolute().toFile());
    }
}

