/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.refactoring;

import com.nxp.s32ds.ext.ide.ui.internal.ExtIdeUiActivator;
import com.nxp.s32ds.ext.ide.ui.refactoring.RenameOperationContext;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.prefs.BackingStoreException;

public class RenameHelper {
    public static List<IProject> performRename(IProgressMonitor monitor, RenameOperationContext renameContext) {
        ArrayList<IProject> projectsPerfomed = new ArrayList<IProject>();
        for (IProjectDescription iter : renameContext.getProjectsSet().getProjects().collect(Collectors.toList())) {
            try {
                IProject newProject = renameContext.performProjectOperation(iter, monitor);
                newProject.refreshLocal(2, monitor);
                projectsPerfomed.add(newProject);
            }
            catch (InterruptedException | InvocationTargetException | CoreException | BackingStoreException e) {
                ExtIdeUiActivator.getInstance().logError("Unexpected error during rename", e);
            }
        }
        return projectsPerfomed;
    }
}

