/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.IRenameParticipant;
import com.nxp.s32ds.ext.ide.ui.refactoring.IChangeValidator;
import com.nxp.s32ds.ext.ide.validation.ui.TextChangeFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class LcResourcesRefactoring
implements IRenameParticipant,
IChangeValidator {
    private static final String BUNDLE_ID = "com.nxp.s32ds.ext.ide.ui.refactoring";
    private static final String AFFECTED_KEY_PATTERN = "key";
    private static final String AFFECTED_VALUE_PATTERN = "value=\"[^\"]*?%s[^\"]*?\"";
    protected static final String[] LAUNCH_FILES;
    private static final String RENAME_ATTRIBUTES_EXTENSION_POINT = "com.nxp.s32ds.ext.ide.core.renameRefactoringLaunchAttributes";
    private static final String ATTRIBUTE_CONFIGURATION_ELEMENT = "attribute";
    private static final String LAUNCH_ATTRIBUTE_NAME_KEY = "name";
    private static final String LAUNCH_TYPE_KEY = "launchConfigurationType";
    private static final List<IChangeValidator.AttributeLine> ATTRIBUTES_AFFECTED;

    static {
        IExtension[] extensions;
        LAUNCH_FILES = new String[]{"*.launch"};
        ATTRIBUTES_AFFECTED = new ArrayList<IChangeValidator.AttributeLine>();
        IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(RENAME_ATTRIBUTES_EXTENSION_POINT).getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElement = iConfigurationElementArray[n4];
                if (configElement.getName().equals(ATTRIBUTE_CONFIGURATION_ELEMENT)) {
                    String attributeName = configElement.getAttribute(LAUNCH_ATTRIBUTE_NAME_KEY);
                    String launchConfigurationTypeId = configElement.getAttribute(LAUNCH_TYPE_KEY);
                    ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine(AFFECTED_KEY_PATTERN, Arrays.asList(AFFECTED_VALUE_PATTERN), attributeName, launchConfigurationTypeId));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public IStatus renameProject(IProject tgtResources, IProject srcResource, String search, String replace, IProgressMonitor monitor) {
        IStatus operationStatus;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((operationStatus = this.modifyLaunchConfigurationOperation((IResource)tgtResources, LAUNCH_FILES, search, replace, monitor)).isOK()) {
            operationStatus = this.modifyReferencedLaunchConfigurationOperation(tgtResources, srcResource, LAUNCH_FILES, srcResource.getName(), tgtResources.getName(), monitor);
        }
        return operationStatus;
    }

    public IStatus renameProject(IProject resources, String search, String replace, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    private IStatus modifyReferencedLaunchConfigurationOperation(IProject tgtProject, IProject srcProject, String[] launchFiles, String search, String replace, IProgressMonitor monitor) {
        MultiStatus mtStatus = new MultiStatus(BUNDLE_ID, 0, "", null);
        IWorkspace wrk = ResourcesPlugin.getWorkspace();
        if (wrk != null) {
            IProject[] iProjectArray = wrk.getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!project.getName().equals(tgtProject.getName()) && !project.getName().equals(srcProject.getName()) && project.isAccessible()) {
                    mtStatus.add(this.modifyLaunchConfigurationOperation((IResource)project, LAUNCH_FILES, search, replace, monitor));
                }
                ++n2;
            }
        }
        return mtStatus;
    }

    protected IStatus modifyLaunchConfigurationOperation(IResource projects, String[] filesExt, String search, String replace, IProgressMonitor monitor) {
        MultiStatus mtStatus = new MultiStatus(BUNDLE_ID, 0, "", null);
        try {
            Map<IFile, List<ReplaceEdit>> mapEdit = TextChangeFinder.findInResource(projects, filesExt, search, replace, monitor);
            List<IFile> fileForRenameNotMatcher = TextChangeFinder.findResourceOutofMatching(projects, filesExt, search, replace, monitor);
            if (!mapEdit.isEmpty()) {
                for (Map.Entry<IFile, List<ReplaceEdit>> iter : mapEdit.entrySet()) {
                    this.applyChanges(iter.getKey(), iter.getValue(), monitor);
                    mtStatus.add(this.renameFile(iter.getKey(), search, replace, monitor));
                }
            }
            if (!fileForRenameNotMatcher.isEmpty()) {
                for (IFile file : fileForRenameNotMatcher) {
                    mtStatus.add(this.renameFile(file, search, replace, monitor));
                }
            }
        }
        catch (CoreException e) {
            mtStatus.add(e.getStatus());
        }
        return mtStatus;
    }

    public void applyChanges(IFile fCurrentFile, List<ReplaceEdit> lstChanges, IProgressMonitor monitor) throws CoreException {
        IDocument result = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            try {
                IPath path = fCurrentFile.getFullPath();
                manager.connect(path, LocationKind.NORMALIZE, monitor);
                ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
                result = buffer.getDocument();
                MultiTextEdit mte = new MultiTextEdit();
                String type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(fCurrentFile).getType().getIdentifier();
                Predicate<IChangeValidator.AttributeLine> predicate = e -> e.launchConfigurationType != null ? e.launchConfigurationType.equals(type) : true;
                List actualAttributes = ATTRIBUTES_AFFECTED.stream().filter(predicate).collect(Collectors.toList());
                for (ReplaceEdit it : lstChanges) {
                    if (this.skipChange(actualAttributes, result, it)) continue;
                    mte.addChild((TextEdit)it);
                }
                mte.apply(result);
                buffer.commit(monitor, true);
            }
            catch (Exception e2) {
                Status status = new Status(4, BUNDLE_ID, e2.getMessage(), (Throwable)e2);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            if (result != null) {
                manager.disconnect(fCurrentFile.getFullPath(), LocationKind.NORMALIZE, monitor);
            }
        }
        monitor.done();
    }
}

