/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.refactoring;

import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import com.nxp.s32ds.ext.ide.ui.refactoring.LcResourcesRefactoring;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class LcResourcesImportRefactoring
extends LcResourcesRefactoring {
    private static final String LAUNCH_EXT = "launch";
    private static final String BUNDLE_ID = "com.nxp.s32ds.ext.ide.ui.refactoring";

    @Override
    public IStatus renameProject(IProject tgtResources, IProject srcResource, String search, String replace, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IStatus operationStatus = this.modifyLaunchConfigurationOperation((IResource)tgtResources, LAUNCH_FILES, search, replace, monitor);
        this.resolvePathSourceLocation(tgtResources);
        return operationStatus;
    }

    private IStatus resolvePathSourceLocation(IProject tgtResources) {
        MultiStatus mtStatus = new MultiStatus(BUNDLE_ID, 0, "", null);
        try {
            List listFiles = WorkspaceResources.collectFiles((IResource)tgtResources, (String[])new String[]{LAUNCH_EXT});
            for (IFile configuration : listFiles) {
                ILaunchConfiguration launchConfiguartion = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(configuration);
                try {
                    ILaunchConfigurationWorkingCopy workingCopy = launchConfiguartion.getWorkingCopy();
                    String values = workingCopy.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, "");
                    if (values.isEmpty()) continue;
                    IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
                    String substitutedValue = stringVariableManager.performStringSubstitution(values);
                    workingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, substitutedValue);
                    workingCopy.doSave();
                }
                catch (CoreException e) {
                    mtStatus.add(e.getStatus());
                }
            }
        }
        catch (CoreException e) {
            mtStatus.add(e.getStatus());
        }
        return mtStatus;
    }
}

