/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.internal.viewers;

import com.nxp.s32ds.ext.ide.ui.internal.ExtIdeUiActivator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.ViewPart;

public class ActiveProjectDecorator
implements ILightweightLabelDecorator,
IWindowListener,
IPartListener {
    private final Font activeFont = (Font)new AtomicReference<Font>(){
        {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    this.set(FontDescriptor.createFrom((Font)Display.getDefault().getSystemFont()).setStyle(1).createFont((Device)Display.getDefault()));
                }
            });
        }
    }.get();
    private final Set<ILabelProviderListener> listeners = new HashSet<ILabelProviderListener>();
    private IProject active = null;

    public ActiveProjectDecorator() {
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IPartService partSvc = window.getPartService();
            partSvc.addPartListener((IPartListener)this);
            this.partActivated(partSvc.getActivePart());
            ++n2;
        }
    }

    public IProject getActive() {
        return this.active;
    }

    private void setActive(IProject newActive) {
        this.active = newActive;
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.windowOpened(window);
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener)this);
        this.partActivated(window.getPartService().getActivePart());
    }

    public void windowDeactivated(IWorkbenchWindow window) {
        this.windowClosed(window);
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
        IResource resource = null;
        try {
            ViewPart viewPart;
            IEditorPart activeEditor;
            if (part instanceof IEditorPart) {
                IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
                resource = ResourceUtil.getResource((IEditorInput)editorInput);
            } else if (part instanceof ViewPart && (activeEditor = (viewPart = (ViewPart)part).getViewSite().getWorkbenchWindow().getActivePage().getActiveEditor()) != null) {
                IEditorInput editorInput = activeEditor.getEditorInput();
                resource = ResourceUtil.getResource((IEditorInput)editorInput);
            }
        }
        catch (Exception e) {
            ExtIdeUiActivator.getInstance().logError("Unexpected error", e);
        }
        this.setActive(resource != null ? resource.getProject() : null);
    }

    private void fireLabelProviderChanged(LabelProviderChangedEvent event) {
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
        this.activeFont.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void decorate(Object element, IDecoration decoration) {
        IProject iProject = (IProject)Adapters.adapt((Object)element, IProject.class);
        if (iProject == null) {
            return;
        }
        if (this.areProjectsHaveEqualNames(iProject)) {
            decoration.setFont(this.activeFont);
        }
    }

    private boolean areProjectsHaveEqualNames(IProject iProject) {
        return this.active != null && !iProject.getName().isEmpty() && !this.active.getName().isEmpty() && iProject.getName().equals(this.active.getName());
    }
}

