/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.handler;

import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import com.nxp.s32ds.ext.ide.ui.dialogs.RenameDialog;
import com.nxp.s32ds.ext.ide.ui.internal.ExtIdeUiActivator;
import com.nxp.s32ds.ext.ide.ui.refactoring.RenameJob;
import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RenameDialog dialog;
        ProjectSet projectSet;
        block8: {
            block7: {
                IResource res = RenameHandler.findSelectedResource(event);
                if (res == null) {
                    return null;
                }
                projectSet = RenameHandler.findProjectSet(res);
                IStatus projectsStatus = RenameHandler.validateProjectSet(projectSet);
                if (projectsStatus.isOK()) break block7;
                RcpStatusHandlers.handleStatus((String)"com.nxp.s32ds.ext.rcp.statushandlers.defaultHandler", (IStatus)projectsStatus, (Object)projectsStatus.getMessage());
                return null;
            }
            dialog = new RenameDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), projectSet);
            if (dialog.open() == 0) break block8;
            return null;
        }
        try {
            String newName = dialog.getResult();
            new RenameJob(projectSet, newName).schedule();
        }
        catch (Exception e) {
            try {
                RcpStatusHandlers.handleStatus((String)"com.nxp.s32ds.ext.rcp.statushandlers.defaultHandler", (IStatus)ExtIdeUiActivator.getInstance().createError("Rename failed", e), null);
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private static IResource findSelectedResource(ExecutionEvent event) {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IResource res = RenameHandler.stream(selection, IResource.class).findAny().orElse(RenameHandler.stream(selection, IAdaptable.class).map(adaptable -> (IResource)adaptable.getAdapter(IResource.class)).filter(IResource.class::isInstance).map(IResource.class::cast).findAny().orElse(RenameHandler.adapt(selection, ResourceMapping.class).map(FuncUtils.loggingFunction(RenameHandler::getTraversals, null)).filter(Objects::nonNull).flatMap(resourceTraversalArray -> Stream.of(resourceTraversalArray)).map(ResourceTraversal::getResources).flatMap(iResourceArray -> Stream.of(iResourceArray)).findAny().orElse(null)));
        return res;
    }

    private static ProjectSet findProjectSet(IResource resource) throws CoreException {
        int matchingSymb;
        ProjectSet projects = null;
        IPath wsLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        int segWorkspace = wsLocation.segmentCount();
        if (segWorkspace == (matchingSymb = wsLocation.matchingFirstSegments(resource.getLocation())) && (projects = RenameHandler.getProjects(resource)).isEmpty()) {
            projects = RenameHandler.getProjectsWithGraphs(resource);
        }
        return projects;
    }

    private static IStatus validateProjectSet(ProjectSet projects) {
        if (projects == null || projects.isEmpty()) {
            return ExtIdeUiActivator.getInstance().createError("Selection is empty or project(s) are out of workspace.");
        }
        for (IProjectDescription project : projects.getProjects().collect(Collectors.toList())) {
            String projectFolde = project.getLocation().lastSegment();
            if (project.getName().equals(projectFolde)) continue;
            return ExtIdeUiActivator.getInstance().createError(NLS.bind((String)"Project name ''{0}'' and project folder ''{1}'' are not consistent.", (Object)project.getName(), (Object)projectFolde));
        }
        return Status.OK_STATUS;
    }

    private static ProjectSet getProjects(IResource resource) throws CoreException {
        if (resource.getLocation().makeRelativeTo(ResourcesPlugin.getWorkspace().getRoot().getLocation()).segmentCount() == 1) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(resource.getName());
            IProjectDescription pd = project.getDescription();
            pd.setLocation(project.getLocation());
            return new ProjectSet(pd);
        }
        File fileParent = resource.getLocation().toFile().getParentFile();
        Path path = new Path(fileParent.getAbsolutePath());
        ArrayList<IProjectDescription> listProjectDescr = new ArrayList<IProjectDescription>();
        File[] fileArray = fileParent.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(folder.getName());
            if (project.isAccessible()) {
                listProjectDescr.add(project.getDescription());
            }
            ++n2;
        }
        return new ProjectSet(fileParent.getName(), "", (IPath)path, listProjectDescr);
    }

    private static ProjectSet getProjectsWithGraphs(IResource resource) {
        IPath location = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IPath resLocation = resource.getLocation();
        File resParent = resLocation.toFile().getParentFile();
        if (resLocation.makeRelativeTo(location).segmentCount() == 2) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(resource.getName());
            return new ProjectSet(project.getName(), project.getName(), resLocation, RenameHandler.collectSiblingProjects(resParent).collect(Collectors.toList()));
        }
        return null;
    }

    private static Stream<IProjectDescription> collectSiblingProjects(File parent) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        return Stream.of(parent.listFiles(File::isDirectory)).map(file -> new File((File)file, ".project")).filter(file -> file.isFile() && file.length() > 0L).map(File::toString).map(Path::new).map(FuncUtils.loggingFunction(arg_0 -> ((IWorkspace)ws).loadProjectDescription(arg_0), null)).filter(Objects::nonNull);
    }

    public boolean isEnabled() {
        return true;
    }

    private static <T> Stream<T> stream(IStructuredSelection selection, Class<T> clazz) {
        return selection.toList().stream().filter(clazz::isInstance);
    }

    private static <T> Stream<T> adapt(IStructuredSelection selection, Class<T> clazz) {
        return selection.toList().stream().map(o -> Platform.getAdapterManager().getAdapter(o, clazz)).filter(clazz::isInstance);
    }

    private static ResourceTraversal[] getTraversals(ResourceMapping mapping) throws CoreException {
        return mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
    }
}

