/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.vpt.acf;

import java.util.Map;

public class ACFMakefileGenerator {
    private static final String HEADER = "################################################################################";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String WHITESPACE = " ";
    private static final String TAB = "\t";
    private static final String COLON = ":";
    private static final String CX = "g++";
    private static final String LD = "g++";
    private static final String I_INCLUDE = "-I\"$(VSDK_DIR)/include\"";
    private static final String I_ACF_OFFLINE = "-I\"$(VSDK_DIR)/libs/apex/acf_offline/include\"";
    private static final String I_USER = "-I\"../APU_kernels\"";
    private static final String CXX_OPTS = "-std=c++11 -D_GLIBCXX_USE_CXX11_ABI=0 -includeapu2_kernel_db_lib.h -Wall -c -fmessage-length=0 -MMD";
    private static final String L_ACF_OFFLINE_PATH_WINDOWS = "-L\"$(VSDK_DIR)/libs/apex/acf_offline/build-x86-gnu-windows-d\"";
    private static final String L_ACF_OFFLINE_PATH_LINUX = "-L\"$(VSDK_DIR)/libs/apex/acf_offline/build-x86-gnu-linux-d\"";
    private static final String L_ACF_OFFLINE = "-lacf_offline";
    private static final String GRAPHS_DIR_VAR = "$(GRAPHS_DIR)";
    private static final String ACF_SRC_PATH = "../$(ACF_DIR)/";
    private static final String ACF_DIR_VAR = "$(ACF_DIR)";

    public static CharSequence populateMakefile(Map<String, String> variables, String graphsDirectory, String acfDirectory, String vsdkDirectory, String acfSourceSignature) {
        StringBuilder builder = new StringBuilder();
        builder.append(ACFMakefileGenerator.addHeader());
        builder.append(ACFMakefileGenerator.addMacros(graphsDirectory, acfDirectory, vsdkDirectory));
        builder.append(ACFMakefileGenerator.addACFRules(acfSourceSignature));
        return builder;
    }

    private static CharSequence addHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append(HEADER + NEWLINE);
        builder.append("# Automatically-generated file. Do not edit!" + NEWLINE);
        builder.append(HEADER + NEWLINE + NEWLINE);
        return builder;
    }

    private static Object addMacros(String graphsDirectory, String acfDirectory, String vsdkDirectory) {
        StringBuilder builder = new StringBuilder();
        builder.append("ECHO = @echo" + NEWLINE);
        builder.append("RM := rm -rf" + NEWLINE);
        builder.append("CD := cd" + NEWLINE + NEWLINE);
        builder.append("CURRENT_DIR := $(notdir $(shell pwd))" + NEWLINE);
        builder.append("GRAPHS_DIR := " + graphsDirectory + NEWLINE);
        builder.append("ACF_DIR := " + acfDirectory + NEWLINE);
        builder.append("VSDK_DIR := " + vsdkDirectory + NEWLINE + NEWLINE);
        builder.append("-include ../makefile.acf.init" + NEWLINE + NEWLINE);
        return builder;
    }

    private static Object addACFRules(String acfSourceSignature) {
        String acfSrc = String.valueOf(acfSourceSignature) + ".cpp";
        String acfObj = String.valueOf(acfSourceSignature) + ".o";
        String acfDep = String.valueOf(acfSourceSignature) + ".d";
        StringBuilder builder = new StringBuilder();
        builder.append("GRAPHS := $(patsubst %" + acfSrc + ",%, $(notdir $(wildcard" + WHITESPACE + ACF_SRC_PATH + "*" + acfSrc + ")))" + NEWLINE + NEWLINE);
        builder.append("CX := g++" + NEWLINE);
        builder.append("LD := g++" + NEWLINE);
        builder.append("CXX_INCS += -I\"$(VSDK_DIR)/include\" -I\"$(VSDK_DIR)/libs/apex/acf_offline/include\" -I\"../APU_kernels\"" + NEWLINE);
        builder.append("CXX_OPTS := -std=c++11 -D_GLIBCXX_USE_CXX11_ABI=0 -includeapu2_kernel_db_lib.h -Wall -c -fmessage-length=0 -MMD" + NEWLINE);
        builder.append("LD_OPTS := " + (System.getProperty("os.name").toLowerCase().contains("win") ? L_ACF_OFFLINE_PATH_WINDOWS : L_ACF_OFFLINE_PATH_LINUX) + NEWLINE);
        builder.append("ACF_LIBS := -lacf_offline" + NEWLINE);
        builder.append("UP_CASE_GRAPHS := $(shell echo $(GRAPHS) | tr '[:lower:]' '[:upper:]')" + NEWLINE);
        builder.append("ACF_MKDBSTUBS := $(foreach graph,$(UP_CASE_GRAPHS),../$(GRAPHS_DIR)/$(graph)__MKDBstub.cpp)" + NEWLINE);
        builder.append("ACF_NATIVEKERNELS := $(foreach graph,$(UP_CASE_GRAPHS),../$(GRAPHS_DIR)/$(graph)_nativekernel.hpp)" + NEWLINE);
        builder.append("ACF_CPPS := $(foreach graph,$(UP_CASE_GRAPHS),../$(GRAPHS_DIR)/$(graph).cpp)" + NEWLINE);
        builder.append("ACF_HPPS := $(foreach graph,$(UP_CASE_GRAPHS),../$(GRAPHS_DIR)/$(graph).hpp)" + NEWLINE);
        builder.append("ACF_TXTS := $(foreach graph,$(UP_CASE_GRAPHS),../$(GRAPHS_DIR)/$(graph)_analysis_log.txt)" + NEWLINE);
        builder.append("ACF_TARGETS := $(foreach graph,$(GRAPHS),$(graph).exe)" + NEWLINE);
        builder.append("ACF_TARGETS += $(ACF_MKDBSTUBS) $(ACF_NATIVEKERNELS) $(ACF_CPPS) $(ACF_HPPS) $(ACF_TXTS)" + NEWLINE + NEWLINE);
        builder.append("define acf_rules" + NEWLINE);
        builder.append("ACF_OBJS += $(ACF_DIR)/$(1)" + acfObj + NEWLINE);
        builder.append("ACF_DEPS += $(ACF_DIR)/$(1)" + acfDep + NEWLINE + NEWLINE);
        builder.append("$(ACF_DIR)/$(1)" + acfObj + COLON + WHITESPACE + "../" + ACF_DIR_VAR + "/" + "$(1)" + acfSrc + NEWLINE);
        builder.append("\t$(ECHO) ' '" + NEWLINE);
        builder.append("\t$(ECHO) 'Building file: ../$(ACF_DIR)/$(1)" + acfSrc + "'" + NEWLINE);
        builder.append("\t$(ECHO) 'Invoking: Cross G++ Compiler'" + NEWLINE);
        builder.append("\t$(CX) $(CXX_OPTS) $(CXX_INCS) -o $(ACF_DIR)/$(1)" + acfObj + WHITESPACE + "../" + ACF_DIR_VAR + "/" + "$(1)" + acfSrc + NEWLINE);
        builder.append("\t$(ECHO) 'Finished building: ../$(ACF_DIR)/$(1)" + acfSrc + "'" + NEWLINE + NEWLINE);
        builder.append("$(1).exe: $(ACF_DIR)/$(1)" + acfObj + NEWLINE);
        builder.append("\t$(ECHO) ' '" + NEWLINE);
        builder.append("\t$(ECHO) 'Building target: $(1).exe'" + NEWLINE);
        builder.append("\t$(ECHO) 'Invoking: Cross G++ Linker'" + NEWLINE);
        builder.append("\t$(LD) $(LD_OPTS) -o $(1).exe $(ACF_DIR)/$(1)" + acfObj + WHITESPACE + "$(ACF_LIBS)" + NEWLINE);
        builder.append("\t$(ECHO) 'Finished building target: $(1).exe'" + NEWLINE + NEWLINE);
        builder.append("../$(GRAPHS_DIR)/$(shell echo $(1) | tr '[:lower:]' '[:upper:]')__MKDBstub.cpp: $(1).exe" + NEWLINE);
        builder.append("\t$(ECHO) ' '" + NEWLINE);
        builder.append("\t$(ECHO) 'Executing ACF resolver: $(1)'" + NEWLINE);
        builder.append("\t$(CD) ../$(GRAPHS_DIR) && ../../$(CURRENT_DIR)/$(1).exe && $(CD) -" + NEWLINE + NEWLINE);
        builder.append("../$(GRAPHS_DIR)/$(shell echo $(1) | tr '[:lower:]' '[:upper:]')_nativekernel.hpp: $(1).exe" + NEWLINE);
        builder.append("\t$(ECHO) ' '" + NEWLINE);
        builder.append("\t$(ECHO) 'Executing ACF resolver: $(1)'" + NEWLINE);
        builder.append("\t$(CD) ../$(GRAPHS_DIR) && ../../$(CURRENT_DIR)/$(1).exe && $(CD) -" + NEWLINE + NEWLINE);
        builder.append("../$(GRAPHS_DIR)/$(shell echo $(1) | tr '[:lower:]' '[:upper:]').cpp: $(1).exe" + NEWLINE);
        builder.append("\t$(ECHO) ' '" + NEWLINE);
        builder.append("\t$(ECHO) 'Executing ACF resolver: $(1)'" + NEWLINE);
        builder.append("\t$(CD) ../$(GRAPHS_DIR) && ../../$(CURRENT_DIR)/$(1).exe && $(CD) -" + NEWLINE + NEWLINE);
        builder.append("../$(GRAPHS_DIR)/$(shell echo $(1) | tr '[:lower:]' '[:upper:]').hpp: $(1).exe" + NEWLINE);
        builder.append("\t$(ECHO) ' '" + NEWLINE);
        builder.append("\t$(ECHO) 'Executing ACF resolver: $(1)'" + NEWLINE);
        builder.append("\t$(CD) ../$(GRAPHS_DIR) && ../../$(CURRENT_DIR)/$(1).exe && $(CD) -" + NEWLINE + NEWLINE);
        builder.append("../$(GRAPHS_DIR)/$(shell echo $(1) | tr '[:lower:]' '[:upper:]')_analysis_log.txt: $(1).exe" + NEWLINE);
        builder.append("\t$(ECHO) ' '" + NEWLINE);
        builder.append("\t$(ECHO) 'Executing ACF resolver: $(1)'" + NEWLINE);
        builder.append("\t$(CD) ../$(GRAPHS_DIR) && ../../$(CURRENT_DIR)/$(1).exe && $(CD) -" + NEWLINE);
        builder.append("endef" + NEWLINE + NEWLINE);
        builder.append("$(foreach graph,$(GRAPHS),$(eval $(call acf_rules,$(graph))))" + NEWLINE + NEWLINE);
        builder.append("-include $(ACF_DEPS)" + NEWLINE + NEWLINE);
        builder.append("all: $(ACF_TARGETS)" + NEWLINE);
        builder.append("\t$(ECHO) ' '" + NEWLINE + NEWLINE);
        builder.append("clean-acf-outputs:" + NEWLINE);
        builder.append("\t-$(RM) $(ACF_MKDBSTUBS) $(ACF_NATIVEKERNELS) $(ACF_CPPS) $(ACF_HPPS) $(ACF_TXTS)" + NEWLINE + NEWLINE);
        builder.append("clean:" + NEWLINE);
        builder.append("\t-$(RM) $(ACF_DEPS) $(ACF_OBJS) $(ACF_TARGETS)" + NEWLINE + NEWLINE);
        builder.append(".PHONY: all clean clean-acf-outputs" + NEWLINE);
        return builder;
    }
}

