/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.updateprojectcode;

import com.nxp.swtools.common.ui.utils.editors.EditorHelper;
import com.nxp.swtools.common.ui.utils.swt.CompareContentProvider;
import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ErrorLevels;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContext;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProviderWrapper;
import com.nxp.swtools.provider.configuration.storage.GeneratedProjectFile;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.toolchainproject.IGeneratedFilesStatusProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.Messages;
import com.nxp.swtools.sdkproject.ToolSourceFileProvider;
import com.nxp.swtools.sdkproject.ToolchainProjectDestinationPathProvider;
import com.nxp.swtools.sdkproject.swt.LinkStyler;
import com.nxp.swtools.sdkproject.swt.StyledLabelProviderAdapter;
import com.nxp.swtools.sdkproject.updateprojectcode.TreeItemData;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tools.ITool;
import com.nxp.swtools.utils.tools.Tools;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class UpdateCodeDialog
extends Dialog {
    static final long serialVersionUID = 1L;
    private static final int HINT_DIFF_WIDHT = 800;
    private static final int HINT_DIFF_HEIGHT = 600;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(UpdateCodeDialog.class);
    final boolean showOpenDialogOption;
    @Nullable
    Boolean showOpenDialogOptionValue = null;
    @Nullable
    Boolean returnToDevelop = null;
    @Nullable
    Composite diffContainer;
    @Nullable
    Composite scrollContent;
    @NonNull
    @NonNull List<@NonNull TreeItemData> treeItems = new ArrayList<TreeItemData>();
    @Nullable
    Tree filesTree;
    @Nullable
    Sash splitter;
    @Nullable
    Font treeBoldFont;
    @Nullable
    Font treeUnderlineFont;
    @Nullable
    LinkStyler linkStyler;
    @NonNull
    @NonNull Map<@NonNull Path, TreeItemData> folders = new HashMap<Path, TreeItemData>();
    @NonNull
    private static final String CANNOT_GENERATE_ERROR_PREFIX = "E:";
    @NonNull
    private static final String CANNOT_GENERATE_WARN_PREFIX = "W:";

    public UpdateCodeDialog(@NonNull Shell parent, boolean showOpenDialogOption) {
        super(parent);
        this.showOpenDialogOption = showOpenDialogOption;
    }

    void showFileDiff(@NonNull Path cmpPrjFilePath, @NonNull String newFileContent) {
        UpdateCodeDialog dlg;
        Shell dlgShell;
        IToolchainProjectWithSdk toolchainProject;
        ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        IToolchainProjectProvider projectProvider = shrdConfig.getToolchainProjectProvider();
        IToolchainProjectWithSdk iToolchainProjectWithSdk = toolchainProject = projectProvider != null ? projectProvider.getToolchainProject() : null;
        assert (toolchainProject != null);
        String prjContent = toolchainProject.getSourceFile_AsCachedString(cmpPrjFilePath);
        Composite container = this.diffContainer;
        Composite curScrollContent = this.scrollContent;
        Tree tree = this.filesTree;
        Sash theSplitter = this.splitter;
        if (prjContent == null || container == null || curScrollContent == null || tree == null || theSplitter == null) {
            return;
        }
        if (OSDetect.isMac()) {
            this.setLayoutDefferedRecursively((Composite)this.getShell(), false);
        }
        theSplitter.setVisible(true);
        FormData fdata = (FormData)tree.getLayoutData();
        if (fdata != null) {
            fdata.right = new FormAttachment((Control)theSplitter, 0);
        }
        byte[] newContArr = newFileContent.getBytes(StandardCharsets.US_ASCII);
        byte[] prjContArr = prjContent.getBytes(StandardCharsets.US_ASCII);
        CompareContentProvider contProvider = new CompareContentProvider(cmpPrjFilePath.toString(), newContArr, prjContArr);
        boolean resizeDlg = true;
        while (container.getChildren().length > 0) {
            container.getChildren()[0].dispose();
            resizeDlg = false;
        }
        Control diffCtrl = EditorHelper.createCompareControl((Composite)container, (CompareContentProvider)contProvider, (IProgressMonitor)new NullProgressMonitor());
        if (diffCtrl == null) {
            return;
        }
        diffCtrl.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setSize(container.computeSize(750, 300));
        int minWdt = Integer.max(800, container.getSize().x);
        int minHigh = Integer.max(600, container.getSize().y);
        Rectangle dispRect = container.getDisplay().getClientArea();
        ScrolledComposite par = (ScrolledComposite)curScrollContent.getParent();
        if (par != null) {
            par.setMinSize(minWdt, minHigh);
        }
        container.layout();
        curScrollContent.setSize(curScrollContent.computeSize(dispRect.width * 2 / 3, dispRect.height * 2 / 3));
        curScrollContent.layout(true, true);
        if (resizeDlg && (dlgShell = (dlg = this).getShell()) != null) {
            dlgShell.pack(true);
            dlgShell.setLocation(dlg.getNewLocation());
        }
    }

    void setLayoutDefferedRecursively(@Nullable Composite composite, boolean layoutDeffered) {
        if (composite != null) {
            composite.setLayoutDeferred(layoutDeffered);
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof Composite) {
                    this.setLayoutDefferedRecursively((Composite)control, layoutDeffered);
                }
                ++n2;
            }
        }
    }

    @NonNull TreeItemData findTreeItemFolder(@NonNull TreeItemData treeParent, @NonNull Path relPath) {
        TreeItemData result = treeParent;
        Path curPath = Paths.get("", new String[0]);
        int index = -1;
        while (++index < relPath.getNameCount()) {
            curPath = curPath.resolve(relPath.getName(index));
            TreeItemData newFolder = this.folders.get(relPath);
            if (newFolder == null) {
                String folderText = String.valueOf(relPath.getName(index).toString()) + File.separator;
                newFolder = TreeItemData.newItem(result, TreeItemData.ItemType.FOLDER, folderText, Messages.get().UpdPrjCode_Tooltip_ProjectSubFolder);
                this.folders.put(curPath, newFolder);
            }
            result = newFolder;
        }
        return result;
    }

    public static @NonNull Path getDefaultDestPathForGeneratedFile(@NonNull String filePath, @NonNull IToolchainProjectWithSdk toolchainProject) {
        Path relPath = Paths.get(filePath, new String[0]);
        if (relPath.startsWith(toolchainProject.getProjectRoot())) {
            relPath = toolchainProject.getProjectRoot().relativize(relPath);
        }
        return relPath;
    }

    protected void createTreeItemDataForFile(@NonNull String toolId, @NonNull String filePath, @Nullable String fileRawContent, @NonNull TreeItemData treeParent, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IGeneratedFilesStatusProvider.GeneratedFileStatus status, boolean derivedSource) {
        String icon;
        String fileTooltip;
        String fileStatus;
        IGeneratedFilesStatusProvider genStatusProvider;
        ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        IToolchainProjectProvider projectProvider = shrdConfig.getToolchainProjectProvider();
        IToolchainProjectWithSdk toolchainProject = projectProvider != null ? projectProvider.getToolchainProject() : null;
        IGeneratedFilesStatusProvider iGeneratedFilesStatusProvider = genStatusProvider = projectProvider != null ? projectProvider.getGeneratedFilesStatusProvider() : null;
        assert (toolchainProject != null && genStatusProvider != null);
        String fileName = UtilsFile.getFileNameWithExtension((String)filePath);
        int statusDecorator = -1;
        String statusTooltip = null;
        String statusSuffix = "";
        Path relPath = toolchainProject.findSourceFileRelPath(fileName);
        if (relPath == null) {
            relPath = UpdateCodeDialog.getDefaultDestPathForGeneratedFile(filePath, toolchainProject);
            if (!SWToolsPlatform.isRunningInEclipseIde()) {
                statusDecorator = 1;
                statusTooltip = String.valueOf(ErrorLevels.levelToText((int)statusDecorator)) + ": " + Messages.get().UpdPrjCode_ErrTheSourceFileNotInProject;
                statusSuffix = Messages.get().UpdPrjCode_FileStatus_NotInProject;
            }
        }
        Runnable showDiff = null;
        if (status == null) {
            assert (false);
            fileStatus = "???";
            fileTooltip = "";
            icon = "icons/updateProjectCode_Disabled.png";
        } else {
            switch (status.statusInfo) {
                default: {
                    assert (false);
                }
                case NOT_EXIST: {
                    fileStatus = String.valueOf(Messages.get().UpdPrjCode_FileStatus_Create) + statusSuffix;
                    fileTooltip = Messages.get().UpdPrjCode_FileStatus_Create_Tooltip;
                    icon = "icons/updateProjectCode_Dirty.png";
                    break;
                }
                case USER_TEMPLATE: {
                    fileStatus = String.valueOf(Messages.get().UpdPrjCode_FileStatus_UserFile) + statusSuffix;
                    fileTooltip = Messages.get().UpdPrjCode_FileStatus_UserFile_Tooltip;
                    icon = "icons/userTemplateProjectCode.png";
                    break;
                }
                case DELETE: {
                    fileStatus = Messages.get().UpdPrjCode_FileStatus_Delete;
                    fileTooltip = Messages.get().UpdPrjCode_FileStatus_Delete_Tooltip;
                    icon = "icons/updateProjectCode_Delete.png";
                    break;
                }
                case MODIFIED: {
                    fileStatus = String.valueOf(Messages.get().UpdPrjCode_FileStatus_Changed) + statusSuffix;
                    fileTooltip = Messages.get().UpdPrjCode_FileStatus_Changed_Tooltip;
                    icon = "icons/updateProjectCode_Dirty.png";
                    assert (fileRawContent != null);
                    String fileContent = UtilsText.convertLineEndings((String)fileRawContent, (String)"\r\n");
                    Path cmpPrjFilePath = relPath;
                    showDiff = () -> this.showFileDiff(cmpPrjFilePath, fileContent);
                    break;
                }
                case UP_TO_DATE: {
                    assert (!genStatusProvider.isNeededUpdateProjectCode(status));
                    fileStatus = String.valueOf(Messages.get().UpdPrjCode_FileStatus_Same) + statusSuffix;
                    fileTooltip = Messages.get().UpdPrjCode_FileStatus_Same_Tooltip;
                    icon = "icons/updateProjectCode_Updated.png";
                }
            }
        }
        Path relPathWithoutFileName = relPath.getParent();
        assert (relPathWithoutFileName != null);
        TreeItemData fldr = this.findTreeItemFolder(treeParent, relPathWithoutFileName);
        if (statusTooltip != null) {
            fileTooltip = String.valueOf(statusTooltip) + "\r\n" + fileTooltip;
        }
        StorageTool storageTool = shrdConfig.getTools().getTool(toolId);
        assert (storageTool != null);
        TreeItemData fileItem = TreeItemData.newItem(fldr, TreeItemData.ItemType.FILE, Objects.requireNonNull(relPath.getFileName()).toString(), fileTooltip);
        fileItem.setDerived(derivedSource);
        if (icon == "icons/userTemplateProjectCode.png") {
            fileItem.setSelection(TreeItemData.Selection.CANNOT_SELECT);
        } else if (!storageTool.isProjectFileUpdateEnabled(fileItem.getText())) {
            fileItem.setSelection(TreeItemData.Selection.UNSELECTED);
        }
        if (icon == "icons/updateProjectCode_Delete.png") {
            fileItem.setForRemoval(true);
        }
        if (!fileStatus.isEmpty()) {
            Image iconImg = statusDecorator < 0 ? ToolsImages.getLocalImage((String)icon) : ToolsImages.getImageWithProblemDecorator((String)icon, (int)statusDecorator, (int)0);
            fileItem.setFileStatus(iconImg, fileStatus, showDiff);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable String createFileControlsForTheTool(@NonNull String toolId, @NonNull ISourceFileProviderWrapper srcFileProvider, @NonNull TreeItemData treeParent) {
        String msgWhyCannotGenerateTool;
        ArrayList<@NonNull E> generatedFiles = new ArrayList();
        ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        ProcessorCore selCore = shrdConfig.getCommonConfig().getSelectedCore();
        IToolchainProjectProvider projectProvider = shrdConfig.getToolchainProjectProvider();
        IToolchainProjectWithSdk toolchainProject = projectProvider != null ? projectProvider.getToolchainProject() : null;
        IGeneratedFilesStatusProvider genStatusProvider = projectProvider != null ? projectProvider.getGeneratedFilesStatusProvider() : null;
        ITool tool = Tools.getTool((String)toolId);
        assert (tool != null);
        if (toolchainProject == null || genStatusProvider == null || selCore == null) {
            LOGGER.severe("toolchainProject or genStatusProvider or selCore is null");
            assert (false) : "toolchainProject or genStatusProvider or selCore is null";
            return "Unexpected failure";
        }
        if (!tool.isProcessorSupported(shrdConfig)) {
            msgWhyCannotGenerateTool = CANNOT_GENERATE_WARN_PREFIX + Messages.get().UpdPrjCode_ErrProcessorNotSupported;
        } else {
            StorageTool storageTool = shrdConfig.getTools().getTool(toolId);
            if (storageTool == null || !storageTool.isEnabled()) {
                String toolName = tool.getToolId();
                SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProduct((String)toolName);
                if (product != null) {
                    toolName = product.getProductName();
                }
                msgWhyCannotGenerateTool = CANNOT_GENERATE_WARN_PREFIX + String.format(Messages.get().UpdPrjCode_ToolIsDisabledTooltip, toolName);
            } else {
                genStatusProvider.getGeneratedFiles(true, toolId);
                ISourceFileProviderWrapper.ISourceGenerateResult genResult = srcFileProvider.generate(selCore.getID(), true);
                msgWhyCannotGenerateTool = genResult.getErrorMessage();
                generatedFiles.addAll(genResult.getAllGeneratedFiles());
                if (msgWhyCannotGenerateTool != null) {
                    msgWhyCannotGenerateTool = CANNOT_GENERATE_ERROR_PREFIX + msgWhyCannotGenerateTool;
                } else if (generatedFiles.isEmpty()) {
                    msgWhyCannotGenerateTool = CANNOT_GENERATE_WARN_PREFIX + Messages.get().UpdPrjCode_ErrNoFileGenerated;
                } else {
                    ToolchainProjectDestinationPathProvider pathProvider = new ToolchainProjectDestinationPathProvider(toolchainProject, "board");
                    String prjRoot = toolchainProject.getProjectRoot().toString();
                    HashMap<@NonNull K, @NonNull V> generatedFilePaths = new HashMap();
                    generatedFiles.forEach(source -> {
                        @NonNull String path = pathProvider.getDestinationPath(source.getRelFileName()).toString();
                        if (!prjRoot.isEmpty() && path.startsWith(prjRoot)) {
                            path = path.substring(prjRoot.length() + 1);
                        }
                        generatedFilePaths.put(path, source.getAsString());
                    });
                    genStatusProvider.getGeneratedFiles(false, toolId).sorted().forEach(fileName -> {
                        IGeneratedFilesStatusProvider.GeneratedFileStatus status = genStatusProvider.getGeneratedFileProjectStatus(fileName, true);
                        if (status != null && status.statusInfo == IGeneratedFilesStatusProvider.GeneratedFileInfo.DELETE) {
                            generatedFilePaths.put(fileName, "");
                        }
                    });
                    generatedFilePaths.entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareTo((String)b.getKey())).forEach(k -> {
                        String fileName = (String)k.getKey();
                        IGeneratedFilesStatusProvider.GeneratedFileStatus status = genStatusProvider.getGeneratedFileProjectStatus(fileName, true);
                        boolean derivedSource = genResult.isDerivedSource(fileName);
                        if (status == null && derivedSource) {
                            status = new IGeneratedFilesStatusProvider.GeneratedFileStatus(IGeneratedFilesStatusProvider.GeneratedFileInfo.MODIFIED, true, toolId);
                        }
                        this.createTreeItemDataForFile(toolId, fileName, (String)k.getValue(), treeParent, status, derivedSource);
                    });
                }
            }
        }
        this.folders.clear();
        return msgWhyCannotGenerateTool;
    }

    protected @NonNull Point getNewLocation() {
        Shell shell = this.getShell();
        if (shell == null) {
            return new Point(0, 0);
        }
        Point result = this.getInitialLocation(shell.getSize());
        assert (result != null);
        return result;
    }

    protected boolean createControlsForTheTool(@NonNull ToolSourceFileProvider toolSrcFileProvider, boolean withoutProblems) {
        StorageTool storageTool = toolSrcFileProvider.getStorageTool();
        ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        IToolchainProjectWithSdk toolchainProject = shrdConfig.getToolchainProject();
        assert (toolchainProject != null);
        ProcessorCore selCore = shrdConfig.getCommonConfig().getSelectedCore();
        ISourceFileProviderWrapper srcFileProvider = toolSrcFileProvider.getSourceFileProvider();
        assert (selCore != null);
        ITool tool = Tools.getTool((String)toolSrcFileProvider.getToolId());
        assert (tool != null);
        TreeItemData toolItem = TreeItemData.newRootItem(toolSrcFileProvider.getTool().getProductName(), toolSrcFileProvider, Messages.get().UpdPrjCode_ToolCheckboxTooltip);
        String reasonWhyToolCannotGenerate = this.createFileControlsForTheTool(toolSrcFileProvider.getToolId(), srcFileProvider, toolItem);
        if (withoutProblems && reasonWhyToolCannotGenerate != null) {
            return false;
        }
        this.treeItems.add(toolItem);
        if (storageTool != null) {
            if (!storageTool.getUpdateCode()) {
                toolItem.setSelection(TreeItemData.Selection.UNSELECTED);
            }
        } else if (reasonWhyToolCannotGenerate == null) {
            assert (false);
            reasonWhyToolCannotGenerate = "E:Tool not configured";
        }
        if (reasonWhyToolCannotGenerate != null) {
            boolean error = reasonWhyToolCannotGenerate.startsWith(CANNOT_GENERATE_ERROR_PREFIX);
            assert (reasonWhyToolCannotGenerate.startsWith(CANNOT_GENERATE_WARN_PREFIX) || error);
            reasonWhyToolCannotGenerate = reasonWhyToolCannotGenerate.substring(CANNOT_GENERATE_WARN_PREFIX.length());
            toolItem.setSelection(TreeItemData.Selection.NEVER_SELECTED);
            toolItem.setTooltip(reasonWhyToolCannotGenerate);
            Image icon = PlatformUI.getWorkbench().getSharedImages().getImage(error ? "IMG_OBJS_ERROR_TSK" : "IMG_OBJS_WARN_TSK");
            assert (icon != null);
            if (error) {
                toolItem.setFileStatus(icon, UtilsText.safeString((String)Messages.get().UpdPrjCode_FileStatus_Error), null);
            } else {
                toolItem.setFileStatus(icon, UtilsText.safeString((String)Messages.get().UpdPrjCode_FileStatus_Warn), null);
            }
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        String mexStatus;
        Tree tree;
        Composite newScrollContent;
        ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        Composite mainContainer = (Composite)super.createDialogArea(parent);
        ScrolledComposite scrollContainer = new ScrolledComposite(mainContainer, 768);
        scrollContainer.setExpandHorizontal(true);
        scrollContainer.setExpandVertical(true);
        scrollContainer.setAlwaysShowScrollBars(false);
        this.scrollContent = newScrollContent = new Composite((Composite)scrollContainer, 0);
        scrollContainer.setContent((Control)newScrollContent);
        newScrollContent.setLayout((Layout)new FormLayout());
        scrollContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        newScrollContent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                newScrollContent.layout(true, true);
            }
        });
        final CheckboxTreeViewerWithRows filesTreeViewer = new CheckboxTreeViewerWithRows(newScrollContent);
        filesTreeViewer.setAutoExpandLevel(4);
        this.filesTree = tree = filesTreeViewer.getTree();
        tree.setHeaderVisible(true);
        FormData fd = new FormData(100, 300);
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        tree.setLayoutData((Object)fd);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)tree, "UpdateProjectFilesWindowTree");
        TreeViewerColumn firstColumnViewer = new TreeViewerColumn((TreeViewer)filesTreeViewer, 0, 0);
        TreeColumn firstColumn = firstColumnViewer.getColumn();
        firstColumn.setWidth(300);
        firstColumn.setText(UtilsText.safeString((String)Messages.get().UpdPrjCode_ColumnTitle_GeneratedFile));
        TreeViewerColumn statusColumnViewer = new TreeViewerColumn((TreeViewer)filesTreeViewer, 0, 1);
        TreeColumn statusColumn = statusColumnViewer.getColumn();
        statusColumn.setWidth(100);
        statusColumn.setMoveable(false);
        statusColumn.setText(UtilsText.safeString((String)Messages.get().UpdPrjCode_ColumnTitle_Status));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)filesTreeViewer, (int)2);
        filesTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return Objects.requireNonNull(UpdateCodeDialog.this.treeItems.toArray());
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof TreeItemData) {
                    return Objects.requireNonNull(((TreeItemData)parentElement).getChildren().toArray());
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof TreeItemData) {
                    return !((TreeItemData)element).getChildren().isEmpty();
                }
                return false;
            }
        });
        firstColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getText();
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getIcon();
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getTooltip();
                }
                return null;
            }

            public Font getFont(Object element) {
                TreeItemData item;
                if (element instanceof TreeItemData && (item = (TreeItemData)element).getItemType().equals((Object)TreeItemData.ItemType.TOOL)) {
                    return UpdateCodeDialog.this.getTreeBoldFont(tree);
                }
                return null;
            }

            public Color getForeground(Object element) {
                if (element instanceof TreeItemData) {
                    TreeItemData item = (TreeItemData)element;
                    if (item.getSelection().isReadOnly()) {
                        return tree.getDisplay().getSystemColor(17);
                    }
                    if (item.isForRemoval()) {
                        return tree.getDisplay().getSystemColor(3);
                    }
                }
                return super.getForeground(element);
            }
        });
        statusColumnViewer.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new StyledLabelProviderAdapterWithTooltip(){

            @Override
            public Image getImage(Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getFileStatusIcon();
                }
                return null;
            }

            public StyledString getStyledText(Object element) {
                if (element instanceof TreeItemData) {
                    TreeItemData item = (TreeItemData)element;
                    String text = ((TreeItemData)element).getFileStatusLabel();
                    if (text != null) {
                        StyledString result = new StyledString(text);
                        if (item.getFileStatusAction() != null) {
                            result = new StyledString(text, (StyledString.Styler)UpdateCodeDialog.this.getLinkStyler((Control)newScrollContent));
                        }
                        return result;
                    }
                }
                return new StyledString("");
            }

            public String getToolTipText(Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getTooltip();
                }
                return null;
            }
        }));
        filesTreeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getSelection().isChecked();
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getSelection().isGrayed();
                }
                return false;
            }
        });
        tree.addListener(13, event -> {
            if (event.detail == 32 && event.item instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)event.item;
                Object itmObj = treeItem.getData();
                if (itmObj instanceof TreeItemData) {
                    TreeItemData item = (TreeItemData)itmObj;
                    if (item.getSelection().isReadOnly()) {
                        event.detail = 0;
                        event.type = 0;
                        event.doit = false;
                    } else {
                        item.toggleSelection();
                    }
                    while (treeItem.getParentItem() != null) {
                        treeItem = treeItem.getParentItem();
                    }
                    try {
                        tree.setRedraw(false);
                        this.refreshTreeItemSelection(treeItem);
                    }
                    finally {
                        tree.setRedraw(true);
                    }
                } else {
                    event.detail = 0;
                    event.type = 0;
                    event.doit = false;
                }
            }
        });
        tree.addMouseMoveListener(event -> {
            ViewerCell cell = filesTreeViewer.getCell(new Point(event.x, event.y));
            if (cell != null && cell.getColumnIndex() == 1) {
                TreeItemData itemData = filesTreeViewer.getItemData(cell);
                if (itemData != null && itemData.getFileStatusAction() != null) {
                    tree.setCursor(new Cursor((Device)tree.getDisplay(), 21));
                } else {
                    tree.setCursor(null);
                }
            } else {
                tree.setCursor(null);
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                ViewerCell cell = filesTreeViewer.getCell(new Point(event.x, event.y));
                if (cell != null && cell.getColumnIndex() == 1) {
                    Runnable runnable;
                    TreeItemData itemData = filesTreeViewer.getItemData(cell);
                    Runnable runnable2 = runnable = itemData != null ? itemData.getFileStatusAction() : null;
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            }
        });
        ArrayList<@NonNull ToolSourceFileProvider> disabledToolProviers = new ArrayList<ToolSourceFileProvider>();
        for (ToolSourceFileProvider toolSrcFileProvider : ToolSourceFileProvider.getToolSourceFileProviders()) {
            if (this.createControlsForTheTool(toolSrcFileProvider, true)) continue;
            disabledToolProviers.add(toolSrcFileProvider);
        }
        for (ToolSourceFileProvider toolSrcFileProvider : disabledToolProviers) {
            boolean result = this.createControlsForTheTool(toolSrcFileProvider, false);
            assert (result);
        }
        TreeItemData confCheckBox = TreeItemData.newRootItem(UtilsText.safeString((String)Messages.get().UpdPrjCode_Configuration), null, Messages.get().UpdPrjCode_ConfigurationTooltip);
        this.treeItems.add(confCheckBox);
        String string = mexStatus = shrdConfig.isDirty() ? Messages.get().UpdPrjCode_MexModified : Messages.get().UpdPrjCode_MexSaved;
        assert (mexStatus != null);
        TreeItemData mexFile = TreeItemData.newItem(confCheckBox, TreeItemData.ItemType.FILE, UtilsFile.getFileNameWithExtension((String)UtilsText.safeString((String)shrdConfig.getLocationOnDisk())), Messages.get().UpdPrjCode_ConfigurationTooltip);
        Image mexIcon = ToolsImages.getLocalImage((String)(shrdConfig.isDirty() ? "icons/updateProjectCode_Dirty.png" : "icons/updateProjectCode_Updated.png"));
        mexFile.setFileStatus(mexIcon, mexStatus, null);
        confCheckBox.setSelection(TreeItemData.Selection.ALWAYS_SELECTED);
        Sash theSplitter = new Sash(newScrollContent, 2560);
        theSplitter.addListener(13, e -> {
            Rectangle parentRect = newScrollContent.getClientArea();
            int left = e.x;
            if (left < 150) {
                left = 150;
            } else if (left > parentRect.width - 300) {
                left = parentRect.width - 300;
            }
            FormData fdata = (FormData)theSplitter.getLayoutData();
            if (fdata != null) {
                fdata.left = new FormAttachment(0, left);
                newScrollContent.layout();
            }
        });
        theSplitter.setVisible(false);
        this.splitter = theSplitter;
        Composite newDiffContainer = new Composite(newScrollContent, 0);
        newDiffContainer.setLayout((Layout)new GridLayout(1, false));
        fd = new FormData(0, 100);
        fd.left = new FormAttachment((Control)theSplitter, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        newDiffContainer.setLayoutData((Object)fd);
        this.diffContainer = newDiffContainer;
        fd = new FormData(2, 2);
        fd.left = new FormAttachment(40, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        theSplitter.setLayoutData((Object)fd);
        scrollContainer.layout();
        newScrollContent.setSize(newScrollContent.computeSize(-1, -1));
        newScrollContent.addDisposeListener(e -> {
            if (this.treeBoldFont != null) {
                this.treeBoldFont.dispose();
            }
            if (this.treeUnderlineFont != null) {
                this.treeUnderlineFont.dispose();
            }
        });
        filesTreeViewer.setInput(this.treeItems);
        firstColumn.pack();
        firstColumn.setWidth(firstColumn.getWidth() + 10);
        statusColumn.pack();
        statusColumn.setWidth(statusColumn.getWidth() + 10);
        return mainContainer;
    }

    void refreshTreeItemSelection(@NonNull TreeItem treeItem) {
        TreeItemData dataItem = (TreeItemData)treeItem.getData();
        assert (dataItem != null);
        treeItem.setChecked(dataItem.getSelection().isChecked());
        treeItem.setGrayed(dataItem.getSelection().isGrayed());
        if (treeItem.getExpanded()) {
            TreeItem[] treeItemArray = treeItem.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem itm = treeItemArray[n2];
                assert (itm != null);
                this.refreshTreeItemSelection(itm);
                ++n2;
            }
        }
    }

    @NonNull Font getTreeBoldFont(@Nullable Tree tree) {
        if (this.treeBoldFont != null) {
            return this.treeBoldFont;
        }
        assert (tree != null);
        Font font = tree.getFont();
        assert (font != null);
        this.treeBoldFont = font = FontFactory.changeStyle((Font)font, (int)1);
        return font;
    }

    @NonNull Font getTreeUnderlineFont(@Nullable Tree tree) {
        if (this.treeUnderlineFont != null) {
            return this.treeUnderlineFont;
        }
        assert (tree != null);
        Font font = tree.getFont();
        assert (font != null);
        this.treeUnderlineFont = font = FontFactory.changeStyle((Font)font, (int)0);
        return font;
    }

    @NonNull LinkStyler getLinkStyler(@NonNull Control ctrl) {
        if (this.linkStyler != null) {
            return this.linkStyler;
        }
        this.linkStyler = LinkStyler.createLinkStyler(ctrl);
        return this.linkStyler;
    }

    private void createOptions(@NonNull Composite bottomGrp) {
        Button opt;
        if (!this.showOpenDialogOption && !SWToolsPlatform.isRunningInMCUXpressoIde()) {
            return;
        }
        Group optionsGrp = new Group(bottomGrp, 4);
        optionsGrp.setText(Messages.get().UpdPrjCode_OptionsGrpTitle);
        GridLayout layout = new GridLayout(1, false);
        optionsGrp.setLayout((Layout)layout);
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        optionsGrp.setLayoutData((Object)gridData);
        if (this.showOpenDialogOption) {
            opt = new Button((Composite)optionsGrp, 32);
            opt.setText(com.nxp.swtools.utils.Messages.get().KEPreferenceHelper_ShowUpdProjectDialog);
            opt.setSelection(KEPreferences.showUpdateCodeDialog());
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)opt, com.nxp.swtools.utils.Messages.get().KEPreferenceHelper_ShowUpdProjectDialogTooltip);
            opt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UpdateCodeDialog.this.showOpenDialogOptionValue = opt.getSelection();
                }
            });
        }
        if (SWToolsPlatform.isRunningInMCUXpressoIde()) {
            opt = new Button((Composite)optionsGrp, 32);
            opt.setText(com.nxp.swtools.utils.Messages.get().KEPreferenceHelper_ReturnToDevelopAfterUpdateProject);
            opt.setSelection(KEPreferences.returnToDevelopAfterUpdateProject());
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)opt, com.nxp.swtools.utils.Messages.get().KEPreferenceHelper_ReturnToDevelopAfterUpdateProjectTooltip);
            opt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UpdateCodeDialog.this.returnToDevelop = opt.getSelection();
                }
            });
        }
    }

    protected Control createButtonBar(Composite parent) {
        assert (parent != null);
        Composite bottomGrp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        bottomGrp.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        bottomGrp.setLayoutData((Object)gridData);
        bottomGrp.setFont(parent.getFont());
        this.createOptions(bottomGrp);
        return super.createButtonBar(bottomGrp);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.get().UpdPrjCode_DlgTitle);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)newShell, "UpdateProjectCodeDialog");
    }

    protected Point getInitialSize() {
        Shell shell = this.getShell();
        if (shell == null) {
            return new Point(0, 0);
        }
        Point size = shell.computeSize(-1, -1, true);
        shell.setMinimumSize(size);
        return size;
    }

    protected boolean isResizable() {
        return true;
    }

    private static void retrieveFiles(@NonNull Collection<@NonNull TreeItemData> tree, @NonNull Collection<@NonNull TreeItemData> files) {
        for (TreeItemData item : tree) {
            if (TreeItemData.ItemType.FILE.equals((Object)item.getItemType())) {
                files.add(item);
            }
            UpdateCodeDialog.retrieveFiles(item.getChildren(), files);
        }
    }

    public int open() {
        int result = super.open();
        if (result == 0) {
            ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
            for (TreeItemData tool : this.treeItems) {
                boolean toolUpdated;
                ToolSourceFileProvider toolSrcProvider = tool.getToolSourceFileProvider();
                if (!TreeItemData.ItemType.TOOL.equals((Object)tool.getItemType()) || toolSrcProvider == null) continue;
                StorageTool storageTool = shrdConfig.getTools().getTool(toolSrcProvider.getToolId());
                assert (storageTool != null);
                boolean strgToolChanged = false;
                boolean bl = toolUpdated = !tool.getSelection().equals((Object)TreeItemData.Selection.UNSELECTED);
                if (toolUpdated != storageTool.getUpdateCode()) {
                    StorageTool.setToolUpdateCode((StorageTool)storageTool, (boolean)toolUpdated);
                    strgToolChanged = true;
                }
                ArrayList<@NonNull TreeItemData> files = new ArrayList<TreeItemData>();
                UpdateCodeDialog.retrieveFiles(tool.getChildren(), files);
                ArrayList<GeneratedProjectFile> genFiles = new ArrayList<GeneratedProjectFile>();
                for (TreeItemData file : files) {
                    genFiles.add(file.toGeneratedProjectFile());
                }
                if (storageTool.setGeneratedProjectFiles(genFiles)) {
                    strgToolChanged = true;
                }
                if (!strgToolChanged) continue;
                shrdConfig.setDirty((IConfigChangeContext)new DefaultConfigChangeContext(IConfigChangeContext.ConfigChangeType.UNKNOWN, toolSrcProvider.getToolId(), (Object)storageTool, Messages.get().UpdPrjCode_SetDirty_UpdPrjGenFiles));
            }
            if (this.showOpenDialogOptionValue != null) {
                KEPreferences.setShowUpdateCodeDialog((boolean)this.showOpenDialogOptionValue);
            }
            if (this.returnToDevelop != null) {
                KEPreferences.setReturnToDevelopAfterUpdateProject((boolean)this.returnToDevelop);
            }
        }
        return result;
    }

    static class CheckboxTreeViewerWithRows
    extends CheckboxTreeViewer {
        public CheckboxTreeViewerWithRows(@NonNull Composite parent) {
            super(parent);
        }

        protected ViewerRow getViewerRow(Point point) {
            ViewerRow result;
            TreeColumn[] treeCols = this.getTree().getColumns();
            if (treeCols == null || treeCols.length == 0) {
                assert (false);
                return null;
            }
            int wasPointX = point.x;
            point.x = treeCols[0].getWidth() - 2;
            do {
                result = super.getViewerRow(point);
                point.x -= 8;
            } while (result == null && point.x > 0);
            point.x = wasPointX;
            return result;
        }

        @Nullable TreeItemData getItemData(@NonNull ViewerCell cell) {
            Object data = cell.getViewerRow().getItem().getData();
            return data instanceof TreeItemData ? (TreeItemData)data : null;
        }
    }

    static abstract class StyledLabelProviderAdapterWithTooltip
    extends StyledLabelProviderAdapter
    implements IToolTipProvider {
        StyledLabelProviderAdapterWithTooltip() {
        }
    }
}

