/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.parsers.ArmGccPrjAdapter;
import com.nxp.swtools.sdkproject.parsers.DsMdkPrjAdapter;
import com.nxp.swtools.sdkproject.parsers.GenericPrjAdapterWithParser;
import com.nxp.swtools.sdkproject.parsers.IarEmbWrkbnchPrjAdapter;
import com.nxp.swtools.sdkproject.parsers.MdkUVisionPrjAdapter;
import java.io.File;

public class PrjFileParserFactory {
    @NonNull
    static final @NonNull String @NonNull [] PRJ_FILE_SUFFIX = new String[]{"CMakeLists.txt", ".uvprojx", ".ewp"};
    @NonNull
    static final @NonNull String @NonNull [] PRJ_FILE_SUBDIR = new String[]{"armgcc", "mdk", "iar"};

    public static boolean isItProjectFileSubDirectory(@NonNull File dir) {
        String[] stringArray = PRJ_FILE_SUBDIR;
        int n = PRJ_FILE_SUBDIR.length;
        int n2 = 0;
        while (n2 < n) {
            String subdir = stringArray[n2];
            if (subdir.equals(dir.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static @Nullable GenericPrjAdapterWithParser getProjectFileParser(@NonNull File file, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        String fileName = file.getName();
        if (fileName.endsWith(".cproject")) {
            return new DsMdkPrjAdapter(file, prjDir, existingProcessorDetector);
        }
        if (fileName.endsWith("CMakeLists.txt")) {
            return new ArmGccPrjAdapter(file, prjDir, existingProcessorDetector);
        }
        if (fileName.endsWith(".uvprojx")) {
            return new MdkUVisionPrjAdapter(file, prjDir, existingProcessorDetector);
        }
        if (fileName.endsWith(".ewp")) {
            return new IarEmbWrkbnchPrjAdapter(file, prjDir, existingProcessorDetector);
        }
        return null;
    }
}

